/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtbot.generator.client.commands;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swtbot.generator.client.Recorder;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class ImportClientCodeHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.addTextToEditorAtCursor(Recorder.INSTANCE.getDocumentText());
        Recorder.INSTANCE.clearDocument();
        return null;
    }

    private void addTextToEditorAtCursor(String text) throws ExecutionException {
        IWorkbenchWindow activeWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage page = activeWindow.getActivePage();
        IEditorPart editorPart = page.getActiveEditor();
        if (!(editorPart instanceof AbstractTextEditor)) {
            throw new ExecutionException("Code can only be inserted within a text editor");
        }
        ITextEditor editor = (ITextEditor)editorPart;
        IDocumentProvider documentProvider = editor.getDocumentProvider();
        IDocument document = documentProvider.getDocument((Object)editor.getEditorInput());
        ISelection selection = editor.getSelectionProvider().getSelection();
        if (!(selection instanceof TextSelection)) {
            throw new ExecutionException("Could not find text selection");
        }
        int offset = ((TextSelection)selection).getOffset();
        try {
            document.replace(offset, 0, text);
        }
        catch (BadLocationException e) {
            throw new ExecutionException("Could not insert code: " + e.getMessage());
        }
    }
}

