/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.services.files;

import java.util.ResourceBundle;
import org.eclipse.osgi.util.NLS;
import org.eclipse.rse.internal.services.RSEServicesMessages;
import org.eclipse.rse.services.clientserver.messages.SimpleSystemMessage;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.services.clientserver.messages.SystemRemoteMessageException;

public class RemoteFileException
extends SystemRemoteMessageException {
    private static final long serialVersionUID = 1L;

    public RemoteFileException(ResourceBundle bundle, String key) {
        this(RemoteFileException.getString(bundle, key));
    }

    public RemoteFileException(String msg) {
        this(msg, new Exception(msg));
    }

    public RemoteFileException(ResourceBundle bundle, String key, Exception remoteException) {
        this(RemoteFileException.getString(bundle, key), remoteException);
    }

    public RemoteFileException(String msg, Exception remoteException) {
        super(msg, remoteException);
        String msgTxt = RSEServicesMessages.FILEMSG_OPERATION_FAILED;
        if (remoteException != null && remoteException.getMessage() != null && !remoteException.getMessage().equals(msg)) {
            msg = msg == null ? remoteException.getMessage() : String.valueOf(msg) + ": " + remoteException.getMessage();
        }
        String msgDetails = NLS.bind((String)RSEServicesMessages.FILEMSG_OPERATION_FAILED_DETAILS, (Object)msg);
        SimpleSystemMessage myMessage = new SimpleSystemMessage("org.eclipse.rse.services", "RSEF1002", 4, msgTxt, msgDetails);
        this.setSystemMessage(myMessage);
    }

    public RemoteFileException(SystemMessage msg) {
        this(msg, new Exception(msg.getLevelOneText()));
    }

    public RemoteFileException(SystemMessage msg, Exception remoteException) {
        super(msg, remoteException);
    }

    private static String getString(ResourceBundle bundle, String key) {
        String msg = null;
        try {
            msg = bundle.getString(key);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (msg == null) {
            msg = "Message with key " + key + " not found";
        }
        return msg;
    }
}

