/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.junit.internal.runner;

import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;

public class TestsExecutionManager {
    private Set<Class<?>> allTestClasses = new TreeSet(classNameComparator);
    private Set<Class<?>> executedTestClasses = new TreeSet(classNameComparator);
    private static Comparator<Class<?>> classNameComparator = new Comparator<Class<?>>(){

        @Override
        public int compare(Class<?> clazz0, Class<?> clazz1) {
            return clazz0.getName().compareTo(clazz1.getName());
        }
    };

    public void addTest(Class<?> testClass) {
        this.allTestClasses.add(testClass);
    }

    public void addExecutedTest(Class<?> testClass) {
        this.addTest(testClass);
        this.executedTestClasses.add(testClass);
    }

    public boolean allTestsAreExecuted() {
        int notExecutedTestsCount = this.allTestClasses.size() - this.executedTestClasses.size();
        return notExecutedTestsCount == 0;
    }

    public boolean isExecuted(Class<?> testClass) {
        return this.executedTestClasses.contains(testClass);
    }
}

