/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.eclipse.jdt.debug.ui.jres;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.reddeer.core.exception.CoreLayerException;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.eclipse.exception.EclipseLayerException;
import org.eclipse.reddeer.eclipse.jdt.debug.ui.jres.AddVMInstallWizard;
import org.eclipse.reddeer.eclipse.jdt.ui.preferences.JREItem;
import org.eclipse.reddeer.eclipse.jdt.ui.preferences.internal.StandardVMPage;
import org.eclipse.reddeer.eclipse.jdt.ui.preferences.internal.VMTypePage;
import org.eclipse.reddeer.jface.preference.PreferencePage;
import org.eclipse.reddeer.jface.wizard.WizardDialog;
import org.eclipse.reddeer.swt.api.TableItem;
import org.eclipse.reddeer.swt.impl.button.PushButton;
import org.eclipse.reddeer.swt.impl.table.DefaultTable;

public class JREsPreferencePage
extends PreferencePage {
    public JREsPreferencePage(ReferencedComposite referencedComposite) {
        super(referencedComposite, new String[]{"Java", "Installed JREs"});
    }

    public JREsPreferencePage addJRE(String path) {
        this.addJRE(path, null);
        return this;
    }

    public JREsPreferencePage addJRE(String path, String name) {
        AddVMInstallWizard wizard = this.openAddJREWizard();
        StandardVMPage vmPage = this.fillJREDialog(wizard, path, name);
        if (!wizard.isFinishEnabled()) {
            String errorMessage = vmPage.getErrorMessage();
            wizard.cancel();
            throw new EclipseLayerException(errorMessage);
        }
        wizard.finish();
        return this;
    }

    public String validateJRELocation(String path, String name) {
        AddVMInstallWizard wizard = this.openAddJREWizard();
        StandardVMPage vmPage = this.fillJREDialog(wizard, path, name);
        if (!wizard.isFinishEnabled()) {
            String errorMessage = vmPage.getErrorMessage();
            wizard.cancel();
            return errorMessage;
        }
        wizard.cancel();
        return null;
    }

    public List<JREItem> getJREs() {
        ArrayList<JREItem> resultList = new ArrayList<JREItem>();
        DefaultTable table = new DefaultTable((ReferencedComposite)this);
        for (TableItem item : table.getItems()) {
            resultList.add(new JREItem(item.getText(0), item.getText(1), item.getText(2)));
        }
        return resultList;
    }

    public JREsPreferencePage deleteJRE(String name) {
        this.selectJRE(name);
        new PushButton(this.referencedComposite, "Remove").click();
        return this;
    }

    public JREsPreferencePage toggleJRE(String name, boolean toggle) {
        this.getJRETableItem(name).setChecked(toggle);
        if (!new PushButton(this.referencedComposite, "Apply").isEnabled()) {
            throw new EclipseLayerException("At least one valid JRE must be chosen - expected default JRE for workspace");
        }
        return this;
    }

    public JREsPreferencePage selectJRE(String name) {
        this.getJRETableItem(name).select();
        return this;
    }

    public TableItem getJRETableItem(String name) {
        DefaultTable table = new DefaultTable((ReferencedComposite)this);
        try {
            return table.getItem(name);
        }
        catch (CoreLayerException coreLayerException) {
            return table.getItem(String.valueOf(name) + " (default)");
        }
    }

    public JREItem getJREItem(String name) {
        TableItem item = this.getJRETableItem(name);
        return new JREItem(item.getText(0), item.getText(1), item.getText(2), item.isChecked());
    }

    public JREsPreferencePage setDefaultJRE(String name) {
        return this.toggleJRE(name, true);
    }

    private AddVMInstallWizard openAddJREWizard() {
        new PushButton((ReferencedComposite)this, "Add...").click();
        AddVMInstallWizard wizard = new AddVMInstallWizard();
        new VMTypePage((ReferencedComposite)wizard).selectType("Standard VM");
        wizard.next();
        return wizard;
    }

    private StandardVMPage fillJREDialog(WizardDialog wizard, String path, String name) {
        StandardVMPage standardVMPage = new StandardVMPage((ReferencedComposite)wizard);
        standardVMPage.setJREHome(path);
        if (name != null) {
            standardVMPage.setName(name);
        }
        return standardVMPage;
    }
}

