/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.ui.launcher;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.launcher.JREBlock;
import org.eclipse.pde.internal.ui.launcher.ProgramBlock;
import org.eclipse.pde.internal.ui.launcher.WorkspaceDataBlock;
import org.eclipse.pde.launching.IPDELauncherConstants;
import org.eclipse.pde.ui.launcher.AbstractLauncherTab;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.PlatformUI;

public class MainTab
extends AbstractLauncherTab
implements IPDELauncherConstants {
    protected WorkspaceDataBlock fDataBlock;
    protected ProgramBlock fProgramBlock;
    protected JREBlock fJreBlock;
    private Image fImage;

    public MainTab() {
        this.createWorkspaceDataBlock();
        this.createProgramBlock();
        this.createJREBlock();
        this.fImage = PDEPluginImages.DESC_MAIN_TAB.createImage();
    }

    public void dispose() {
        this.fImage.dispose();
        super.dispose();
    }

    public void createControl(Composite parent) {
        Control[] controls;
        ScrolledComposite scrollContainer = new ScrolledComposite(parent, 512);
        scrollContainer.setLayoutData((Object)new GridData(768));
        Composite composite = new Composite((Composite)scrollContainer, 0);
        scrollContainer.setContent((Control)composite);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(768));
        this.fDataBlock.createControl(composite);
        this.fProgramBlock.createControl(composite);
        this.fJreBlock.createControl(composite);
        Listener listener = e -> {
            Control child = (Control)e.widget;
            Rectangle bounds = child.getBounds();
            Rectangle area = scrollContainer.getClientArea();
            Point origin = scrollContainer.getOrigin();
            if (origin.x > bounds.x) {
                origin.x = Math.max(0, bounds.x);
            }
            if (origin.y > bounds.y) {
                origin.y = Math.max(0, bounds.y);
            }
            if (origin.x + area.width < bounds.x + bounds.width) {
                origin.x = Math.max(0, bounds.x + bounds.width - area.width);
            }
            if (origin.y + area.height < bounds.y + bounds.height) {
                origin.y = Math.max(0, bounds.y + bounds.height - area.height);
            }
            scrollContainer.setOrigin(origin);
        };
        Control[] controlArray = controls = composite.getChildren();
        int n = controls.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            control.addListener(26, listener);
            ++n2;
        }
        Dialog.applyDialogFont((Control)composite);
        composite.setSize(composite.computeSize(-1, -1));
        scrollContainer.setExpandHorizontal(true);
        this.setControl((Control)scrollContainer);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.pde.doc.user.launcher_basic");
    }

    public void applyData(Object data) {
        if (data == "location") {
            this.fDataBlock.selectWorkspaceLocation();
        }
    }

    public void initializeFrom(ILaunchConfiguration config) {
        try {
            this.fDataBlock.initializeFrom(config, false);
            this.fProgramBlock.initializeFrom(config);
            this.fJreBlock.initializeFrom(config);
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        this.fDataBlock.setDefaults(config, false);
        this.fProgramBlock.setDefaults(config);
        this.fJreBlock.setDefaults(config);
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        this.fDataBlock.performApply(config, false);
        this.fProgramBlock.performApply(config);
        this.fJreBlock.performApply(config);
    }

    public String getName() {
        return PDEUIMessages.MainTab_name;
    }

    public Image getImage() {
        return this.fImage;
    }

    protected void createWorkspaceDataBlock() {
        this.fDataBlock = new WorkspaceDataBlock(this);
    }

    protected void createProgramBlock() {
        this.fProgramBlock = new ProgramBlock(this);
    }

    protected void createJREBlock() {
        this.fJreBlock = new JREBlock(this);
    }

    @Override
    public void validateTab() {
        String error = this.fDataBlock.validate();
        if (error == null) {
            error = this.fJreBlock.validate();
        }
        this.setErrorMessage(error);
    }

    public String getId() {
        return "org.eclipse.pde.ui.launch.tab.main";
    }

    protected void initializeAttributes() {
        super.initializeAttributes();
        this.getAttributesLabelsForPrototype().put("pde.version", PDEUIMessages.MainTab_AttributeLabel_LauncherPDEVersion);
        this.getAttributesLabelsForPrototype().put("append.args", PDEUIMessages.MainTab_AttributeLabel_AppendArgs);
        this.getAttributesLabelsForPrototype().put("location", PDEUIMessages.MainTab_AttributeLabel_WorkspaceLocation);
        this.getAttributesLabelsForPrototype().put("clearws", PDEUIMessages.MainTab_AttributeLabel_ClearWorkspace);
        this.getAttributesLabelsForPrototype().put("clearwslog", PDEUIMessages.MainTab_AttributeLabel_ClearLogOnly);
        this.getAttributesLabelsForPrototype().put("askclear", PDEUIMessages.MainTab_AttributeLabel_ClearAskForConfirmation);
        this.getAttributesLabelsForPrototype().put("useProduct", PDEUIMessages.MainTab_AttributeLabel_UseProduct);
        this.getAttributesLabelsForPrototype().put("product", PDEUIMessages.MainTab_AttributeLabel_Product);
        this.getAttributesLabelsForPrototype().put("application", PDEUIMessages.MainTab_AttributeLabel_Application);
        this.getAttributesLabelsForPrototype().put(IJavaLaunchConfigurationConstants.ATTR_JAVA_COMMAND, PDEUIMessages.MainTab_AttributeLabel_JavaExecutable);
        this.getAttributesLabelsForPrototype().put(IJavaLaunchConfigurationConstants.ATTR_JRE_CONTAINER_PATH, PDEUIMessages.MainTab_AttributeLabel_JREContainerPath);
        this.getAttributesLabelsForPrototype().put(IJavaLaunchConfigurationConstants.ATTR_SOURCE_PATH_PROVIDER, PDEUIMessages.MainTab_AttributeLabel_SourcePathProvider);
        this.getAttributesLabelsForPrototype().put("bootstrap", PDEUIMessages.MainTab_AttributeLabel_BootstrapEntries);
    }
}

