/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.ds.internal.annotations;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.pde.ds.internal.annotations.DSAnnotationCompilationParticipant;
import org.eclipse.pde.ds.internal.annotations.Messages;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class DSAnnotationPreferenceListener
implements IEclipsePreferences.IPreferenceChangeListener {
    public DSAnnotationPreferenceListener() {
        InstanceScope.INSTANCE.getNode("org.eclipse.pde.ds.annotations").addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
    }

    public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
        final IWorkspace ws = ResourcesPlugin.getWorkspace();
        final boolean autoBuilding = ws.isAutoBuilding();
        if (!autoBuilding) {
            return;
        }
        WorkspaceJob job = new WorkspaceJob(Messages.DSAnnotationPreferenceListener_jobName){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                IProject[] projects = ws.getRoot().getProjects();
                ArrayList<IProject> managedProjects = new ArrayList<IProject>(projects.length);
                IProject[] iProjectArray = projects;
                int n = projects.length;
                int n2 = 0;
                while (n2 < n) {
                    IProject project = iProjectArray[n2];
                    if (project.isOpen() && DSAnnotationCompilationParticipant.isManaged(project)) {
                        managedProjects.add(project);
                    }
                    ++n2;
                }
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.DSAnnotationPreferenceListener_taskName, (int)(managedProjects.size() * 2));
                for (IProject project : managedProjects) {
                    progress.worked(1);
                    if (autoBuilding) {
                        project.build(6, (IProgressMonitor)progress.newChild(1));
                        continue;
                    }
                    progress.worked(1);
                }
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                return autoBuilding && ResourcesPlugin.FAMILY_AUTO_BUILD.equals(family);
            }
        };
        Display display = Display.getCurrent();
        if (display != null) {
            PlatformUI.getWorkbench().getProgressService().showInDialog(display.getActiveShell(), (Job)job);
        }
        job.schedule();
    }

    public void dispose() {
        InstanceScope.INSTANCE.getNode("org.eclipse.pde.ds.annotations").removePreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
    }
}

