/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.views.properties.storage;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.plugin.RegistryReader;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.papyrus.infra.properties.contexts.Context;
import org.eclipse.papyrus.views.properties.Activator;
import org.eclipse.papyrus.views.properties.storage.IContextStorageProvider;

public class ContextStorageRegistry {
    private static final String EXT_POINT = "contextStorage";
    private final List<IContextStorageProvider> providers = new ArrayList<IContextStorageProvider>();
    private final ResourceSet resourceSet;

    public ContextStorageRegistry(ResourceSet resourceSet) {
        this.resourceSet = resourceSet;
        new MyRegistryReader().readRegistry();
    }

    public List<IContextStorageProvider> getStorageProviders() {
        return Collections.unmodifiableList(this.providers);
    }

    public IContextStorageProvider getStorageProvider(Context context) {
        IContextStorageProvider result = IContextStorageProvider.NULL;
        for (IContextStorageProvider next : this.providers) {
            if (!next.providesFor(context)) continue;
            result = next;
            break;
        }
        return result;
    }

    private class MyRegistryReader
    extends RegistryReader {
        private static final String A_CLASS = "class";
        private static final String E_PROVIDER = "provider";

        MyRegistryReader() {
            super(Platform.getExtensionRegistry(), "org.eclipse.papyrus.views.properties", ContextStorageRegistry.EXT_POINT);
        }

        public void readRegistry() {
            super.readRegistry();
        }

        protected boolean readElement(IConfigurationElement element, boolean add) {
            boolean result = true;
            if (E_PROVIDER.equals(element.getName())) {
                if (add) {
                    try {
                        IContextStorageProvider provider = (IContextStorageProvider)element.createExecutableExtension(A_CLASS);
                        provider.initialize(ContextStorageRegistry.this.resourceSet);
                        ContextStorageRegistry.this.providers.add(provider);
                    }
                    catch (Exception e) {
                        result = false;
                        Activator.log.error("Failed to initialize context storage provider extension.", (Throwable)e);
                    }
                } else {
                    try {
                        String className = element.getAttribute(A_CLASS);
                        Iterator<IContextStorageProvider> iter = ContextStorageRegistry.this.providers.iterator();
                        while (iter.hasNext()) {
                            IContextStorageProvider next = iter.next();
                            if (!className.equals(next.getClass().getName())) continue;
                            try {
                                next.dispose();
                            }
                            catch (Exception e) {
                                Activator.log.error("Uncaught exception in disposal of context storage provider extension.", (Throwable)e);
                            }
                            iter.remove();
                        }
                    }
                    catch (Exception e) {
                        result = false;
                        Activator.log.error("Failed to remove context storage provider extension.", (Throwable)e);
                    }
                }
            }
            return result;
        }
    }
}

