/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.widgets.editors;

import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.papyrus.infra.widgets.creation.IAtomicOperationExecutor;
import org.eclipse.papyrus.infra.widgets.editors.ICommitListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public abstract class AbstractEditor
extends Composite
implements DisposeListener {
    protected Label label;
    protected String labelText;
    protected Set<ICommitListener> commitListeners = new LinkedHashSet<ICommitListener>();
    protected Binding binding;
    protected String toolTipText;
    protected DataBindingContext dbc;
    public static final TabbedPropertySheetWidgetFactory factory = new TabbedPropertySheetWidgetFactory();

    static {
        factory.setBackground(null);
        factory.setBorderStyle(2048);
    }

    protected AbstractEditor(Composite parent) {
        this(parent, 0, null);
    }

    protected AbstractEditor(Composite parent, int style) {
        this(parent, style, null);
    }

    protected AbstractEditor(Composite parent, String label) {
        this(parent, 0, label);
    }

    protected AbstractEditor(Composite parent, int style, String label) {
        super(parent, style);
        GridLayout layout = new GridLayout(1, false);
        this.setLayout((Layout)layout);
        if (label != null) {
            this.createLabel(label);
        }
        parent.addDisposeListener((DisposeListener)this);
    }

    protected void createLabel(String text) {
        this.label = factory.createLabel((Composite)this, text);
        this.label.setLayoutData((Object)this.getLabelLayoutData());
        if (this.toolTipText != null) {
            this.label.setToolTipText(this.toolTipText);
        }
        ++((GridLayout)this.getLayout()).numColumns;
    }

    protected GridData getLabelLayoutData() {
        GridData data = new GridData();
        data.widthHint = 120;
        data.verticalAlignment = 0x1000000;
        return data;
    }

    protected GridData getDefaultLayoutData() {
        GridData data = new GridData(4, 1, true, false);
        return data;
    }

    public void setLabel(String label) {
        this.labelText = label;
        if (this.label != null) {
            this.label.setText(label);
        } else {
            this.createLabel(label);
            this.label.moveAbove(this.getChildren()[0]);
        }
    }

    public void setDisplayLabel(boolean displayLabel) {
        if (displayLabel) {
            this.setLabel(this.labelText);
        } else if (this.label != null) {
            this.label.dispose();
            --((GridLayout)this.getLayout()).numColumns;
        }
    }

    public void addCommitListener(ICommitListener listener) {
        this.commitListeners.add(listener);
    }

    public void removeCommitListener(ICommitListener listener) {
        this.commitListeners.remove(listener);
    }

    public void removeAllCommitListeners() {
        this.commitListeners.clear();
    }

    protected void commit() {
        for (ICommitListener listener : this.commitListeners) {
            listener.commit(this);
        }
    }

    protected DataBindingContext getBindingContext() {
        if (this.dbc == null) {
            this.dbc = new DataBindingContext();
        }
        return this.dbc;
    }

    public abstract void setConverters(IConverter var1, IConverter var2);

    protected abstract void doBinding();

    public abstract Object getEditableType();

    public abstract void setReadOnly(boolean var1);

    public abstract boolean isReadOnly();

    protected void setCommitOnFocusLost(Control control) {
        control.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                AbstractEditor.this.commit();
            }
        });
    }

    public void refreshValue() {
        if (this.binding != null) {
            this.binding.updateModelToTarget();
        }
    }

    public void refreshModel() {
        if (this.binding != null) {
            this.binding.updateTargetToModel();
        }
    }

    protected void setLabelToolTipText(String text) {
        this.toolTipText = text;
        if (this.label != null && !this.label.isDisposed()) {
            this.label.setToolTipText(text);
        }
    }

    protected void setExclusion(Control control, boolean exclude) {
        GridData data;
        if (control.getLayoutData() == null) {
            data = new GridData();
            control.setLayoutData((Object)data);
        }
        data = (GridData)control.getLayoutData();
        if (data.exclude != exclude) {
            data.exclude = exclude;
            GridLayout layout = (GridLayout)control.getParent().getLayout();
            layout.numColumns = exclude ? --layout.numColumns : ++layout.numColumns;
        }
    }

    public void widgetDisposed(DisposeEvent e) {
        this.dispose();
    }

    public void changeColorField() {
    }

    public IAtomicOperationExecutor getOperationExecutor(Object context) {
        IAtomicOperationExecutor result = context instanceof IAdaptable ? (IAtomicOperationExecutor)((IAdaptable)context).getAdapter(IAtomicOperationExecutor.class) : (context != null ? (IAtomicOperationExecutor)Platform.getAdapterManager().getAdapter(context, IAtomicOperationExecutor.class) : null);
        if (result == null) {
            result = IAtomicOperationExecutor.DEFAULT;
        }
        return result;
    }

    protected final void acceptingFocus() {
        FocusVeto.vetoFocus((Control)this);
    }

    protected abstract Object getContextElement();

    static class FocusVeto {
        private static final boolean IS_SWT_COCOA = "cocoa".equals(Platform.getWS());
        private final Control focusControl;

        private FocusVeto(Control focusControl) {
            this.focusControl = focusControl;
            final Shell shell = focusControl.getShell();
            focusControl.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    FocusVeto.removeFocusVeto(shell, this);
                    if (!focusControl.isDisposed() && !focusControl.isFocusControl()) {
                        focusControl.setFocus();
                    }
                }
            });
        }

        Control getFocusControl() {
            return this.focusControl;
        }

        static Control getFocusVetoControl(Control context) {
            FocusVeto veto = IS_SWT_COCOA ? FocusVeto.getFocusVeto(context.getShell()) : null;
            return veto == null ? null : veto.getFocusControl();
        }

        static void vetoFocus(Control focusControl) {
            Shell shell;
            FocusVeto current;
            if (IS_SWT_COCOA && (current = FocusVeto.getFocusVeto(shell = focusControl.getShell())) == null) {
                FocusVeto.setFocusVeto(shell, new FocusVeto(focusControl));
            }
        }

        static FocusVeto getFocusVeto(Shell shell) {
            return (FocusVeto)shell.getData(FocusVeto.class.getName());
        }

        static void setFocusVeto(Shell shell, FocusVeto focusVeto) {
            shell.setData(FocusVeto.class.getName(), (Object)focusVeto);
        }

        static void removeFocusVeto(Shell shell, FocusVeto focusVeto) {
            if (FocusVeto.getFocusVeto(shell) == focusVeto) {
                shell.setData(FocusVeto.class.getName(), null);
            }
        }
    }
}

