/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.internationalization.controlmode.participants;

import java.util.Locale;
import java.util.Map;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.resource.NotFoundException;
import org.eclipse.papyrus.infra.internationalization.controlmode.commands.ControlPropertiesCommand;
import org.eclipse.papyrus.infra.internationalization.controlmode.commands.CreatePropertiesControlResourceCommand;
import org.eclipse.papyrus.infra.internationalization.controlmode.commands.RemovePropertiesControlResourceCommand;
import org.eclipse.papyrus.infra.internationalization.modelresource.InternationalizationModelResource;
import org.eclipse.papyrus.infra.services.controlmode.ControlModeRequest;
import org.eclipse.papyrus.infra.services.controlmode.participants.IUncontrolCommandParticipant;

public class PropertiesUncontrolParticipant
implements IUncontrolCommandParticipant {
    private static final String PARTICIPANT_ID = "org.eclipse.papyrus.infra.internationalization.controlmode.PropertiesUncontrolParticipant";
    private InternationalizationModelResource internationalizationModelResource;

    public String getID() {
        return PARTICIPANT_ID;
    }

    public int getPriority() {
        return 70;
    }

    public boolean provideUnControlCommand(ControlModeRequest request) {
        boolean result = false;
        EObject objectToUncontrol = request.getTargetObject();
        if (objectToUncontrol != null) {
            InternationalizationModelResource modelResource = this.getInternationalizationModelResource(request);
            Map localesAndResourcesForURI = modelResource.getLocalesAndResourcesForURI(request.getSourceURI().trimFileExtension().appendFileExtension("properties"));
            result = localesAndResourcesForURI != null && !localesAndResourcesForURI.isEmpty();
        }
        return result;
    }

    public ICommand getPreUncontrolCommand(ControlModeRequest request) {
        boolean result = this.setPropertiesTargetRequest(request);
        UnexecutableCommand compositeCommand = null;
        if (result) {
            InternationalizationModelResource modelResource;
            compositeCommand = new CompositeTransactionalCommand(request.getEditingDomain(), "Uncontrol command");
            URI newPropertiesURI = request.getNewURI().trimFileExtension().appendFileExtension("properties");
            URI sourcePropertiesURI = request.getSourceURI().trimFileExtension().appendFileExtension("properties");
            ModelSet modelSet = request.getModelSet();
            if (modelSet != null && (modelResource = this.getInternationalizationModelResource(request)) != null) {
                Map newLocalesAndResources = modelResource.getLocalesAndResourcesForURI(newPropertiesURI);
                Map sourceLocalesAndResources = modelResource.getLocalesAndResourcesForURI(sourcePropertiesURI);
                for (Locale sourceLocale : sourceLocalesAndResources.keySet()) {
                    if (newLocalesAndResources.containsKey(sourceLocale)) continue;
                    compositeCommand.add((IUndoableOperation)new CreatePropertiesControlResourceCommand(request, "properties", sourceLocale));
                }
            }
            compositeCommand.add((IUndoableOperation)new ControlPropertiesCommand(request));
        }
        return compositeCommand != null ? compositeCommand : UnexecutableCommand.INSTANCE;
    }

    public ICommand getPostUncontrolCommand(ControlModeRequest request) {
        UnexecutableCommand commandResult = UnexecutableCommand.INSTANCE;
        Map<Locale, Resource> result = this.getPropertiesSourceRequest(request);
        if (result != null && !result.isEmpty()) {
            CompositeTransactionalCommand compositeCommand = new CompositeTransactionalCommand(request.getEditingDomain(), "Remove properties resources");
            for (Map.Entry<Locale, Resource> entry : result.entrySet()) {
                compositeCommand.add((IUndoableOperation)new RemovePropertiesControlResourceCommand(request, "properties", entry.getValue(), entry.getKey()));
            }
            commandResult = compositeCommand;
        }
        this.internationalizationModelResource = null;
        return commandResult;
    }

    protected boolean setPropertiesTargetRequest(ControlModeRequest request) {
        Map localesAndResources;
        InternationalizationModelResource modelResource;
        boolean result = false;
        URI propertiesURI = request.getNewURI().trimFileExtension().appendFileExtension("properties");
        ModelSet modelSet = request.getModelSet();
        if (modelSet != null && (modelResource = this.getInternationalizationModelResource(request)) != null && !(localesAndResources = modelResource.getLocalesAndResourcesForURI(propertiesURI)).isEmpty()) {
            request.setParameter("createdPropertiesResources", (Object)localesAndResources);
            result = true;
        }
        return result;
    }

    protected Map<Locale, Resource> getPropertiesSourceRequest(ControlModeRequest request) {
        InternationalizationModelResource modelResource;
        Map result = null;
        URI propertiesURI = request.getSourceURI().trimFileExtension().appendFileExtension("properties");
        ModelSet modelSet = request.getModelSet();
        if (modelSet != null && (modelResource = this.getInternationalizationModelResource(request)) != null) {
            result = modelResource.getLocalesAndResourcesForURI(propertiesURI);
        }
        return result;
    }

    protected InternationalizationModelResource getInternationalizationModelResource(ControlModeRequest request) {
        ModelSet modelSet;
        if (this.internationalizationModelResource == null && request != null && (modelSet = request.getModelSet()) != null) {
            try {
                this.internationalizationModelResource = (InternationalizationModelResource)modelSet.getModelChecked("org.eclipse.papyrus.infra.internationalization.resource.InternationalizationModel");
            }
            catch (NotFoundException notFoundException) {
                // empty catch block
            }
        }
        return this.internationalizationModelResource;
    }
}

