/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.services;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.impl.AdapterFactoryImpl;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.services.IService;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;

public class ModelSetServiceAdapter
extends AdapterFactoryImpl
implements IService {
    private static final String TYPE_ID = String.valueOf(ModelSetServiceAdapter.class.getName()) + "TypeId";
    private final ResourceSet modelSet;
    private ServicesRegistry registry;

    public ModelSetServiceAdapter(ResourceSet modelSet) {
        this.modelSet = modelSet;
    }

    public ServicesRegistry getServiceRegistry() {
        return this.registry;
    }

    public static ModelSetServiceAdapter getInstance(ResourceSet resourceSet) {
        AdapterFactory factory;
        ModelSetServiceAdapter result = null;
        if (resourceSet != null && (factory = EcoreUtil.getAdapterFactory((List)resourceSet.getAdapterFactories(), (Object)TYPE_ID)) instanceof ModelSetServiceAdapter) {
            result = (ModelSetServiceAdapter)factory;
        }
        return result;
    }

    public boolean isFactoryForType(Object type) {
        return type.equals(TYPE_ID);
    }

    @Override
    public void init(ServicesRegistry servicesRegistry) throws ServiceException {
        this.registry = servicesRegistry;
    }

    @Override
    public void startService() throws ServiceException {
        AdapterFactory factory = EcoreUtil.getAdapterFactory((List)this.modelSet.getAdapterFactories(), (Object)TYPE_ID);
        if (factory != null) {
            this.modelSet.getAdapterFactories().remove((Object)factory);
        }
        this.modelSet.getAdapterFactories().add((Object)this);
    }

    public void stopService() {
        this.modelSet.getAdapterFactories().remove((Object)this);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void disposeService() throws ServiceException {
        block5: {
            try {
                this.stopService();
            }
            finally {
                if (this.modelSet instanceof ModelSet) {
                    ((ModelSet)this.modelSet).unload();
                    break block5;
                }
                ** for (next : ImmutableList.copyOf((Collection)this.modelSet.getResources()))
            }
lbl-1000:
            // 1 sources

            {
                next.unload();
                next.eAdapters().clear();
                continue;
            }
lbl12:
            // 1 sources

            this.modelSet.getResources().clear();
            this.modelSet.eAdapters().clear();
        }
    }

    public static class Factory
    implements IAdapterFactory {
        private final Class<?>[] adapterTypes = new Class[]{IService.class};

        public Class[] getAdapterList() {
            return this.adapterTypes;
        }

        public Object getAdapter(Object adaptableObject, Class adapterType) {
            ModelSetServiceAdapter result = null;
            if (adapterType == IService.class && adaptableObject instanceof ModelSet) {
                result = new ModelSetServiceAdapter((ResourceSet)((ModelSet)((Object)adaptableObject)));
            }
            return result;
        }
    }
}

