/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.sourcelookup.internal;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Properties;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.maven.artifact.Artifact;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.ArtifactKey;
import org.eclipse.m2e.core.embedder.IMaven;
import org.eclipse.m2e.sourcelookup.internal.MetaInfMavenScanner;

public class MavenArtifactIdentifier {
    private static final ILog LOG = Platform.getLog(MavenArtifactIdentifier.class);
    private static final MetaInfMavenScanner<ArtifactKey> SCANNER = new MetaInfMavenScanner<ArtifactKey>(){

        @Override
        protected ArtifactKey visitFile(Path file) throws IOException {
            Throwable throwable = null;
            Object var3_4 = null;
            try (InputStream is = Files.newInputStream(file, new OpenOption[0]);){
                return this.loadPomProperties(is, file);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }

        @Override
        protected ArtifactKey visitJarEntry(JarFile jar, JarEntry entry) throws IOException {
            Throwable throwable = null;
            Object var4_5 = null;
            try (InputStream is = jar.getInputStream(entry);){
                return this.loadPomProperties(is, Path.of(entry.getName(), new String[0]));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }

        private ArtifactKey loadPomProperties(InputStream is, Path path) throws IOException {
            Properties properties = new Properties();
            properties.load(is);
            ArtifactKey key = MavenArtifactIdentifier.readArtifactKey(properties);
            if (key != null && path.endsWith(Path.of(key.groupId(), key.artifactId(), "pom.properties"))) {
                return key;
            }
            return null;
        }
    };

    private MavenArtifactIdentifier() {
    }

    public static Collection<ArtifactKey> identify(File classesLocation) {
        Path location = classesLocation.toPath();
        Collection<ArtifactKey> classesArtifacts = MavenArtifactIdentifier.scanPomProperties(location);
        if (classesArtifacts.isEmpty()) {
            classesArtifacts = MavenArtifactIdentifier.identifyCentralSearch(location);
        }
        return classesArtifacts;
    }

    private static Collection<ArtifactKey> identifyCentralSearch(Path file) {
        if (!Files.isRegularFile(file, new LinkOption[0])) {
            return Set.of();
        }
        try {
            String sha1;
            Throwable throwable = null;
            Throwable throwable2 = null;
            try (InputStream fis = Files.newInputStream(file, new OpenOption[0]);){
                sha1 = DigestUtils.sha1Hex((InputStream)fis);
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
            URL url = new URL("https://search.maven.org/solrsearch/select?q=1:" + sha1);
            throwable2 = null;
            Object var4_6 = null;
            try (InputStreamReader reader = new InputStreamReader(url.openStream(), StandardCharsets.UTF_8);){
                LinkedHashSet<ArtifactKey> result = new LinkedHashSet<ArtifactKey>();
                JsonObject container = (JsonObject)new Gson().fromJson((Reader)reader, JsonObject.class);
                JsonArray docs = container.get("response").getAsJsonObject().get("docs").getAsJsonArray();
                for (JsonElement element : docs) {
                    JsonObject doc = element.getAsJsonObject();
                    String g = doc.get("g").getAsString();
                    String a = doc.get("a").getAsString();
                    String v = doc.get("v").getAsString();
                    result.add(new ArtifactKey(g, a, v, null));
                }
                Set<ArtifactKey> set = !result.isEmpty() ? Set.copyOf(result) : null;
                return set;
            }
            catch (Throwable throwable4) {
                if (throwable2 == null) {
                    throwable2 = throwable4;
                } else if (throwable2 != throwable4) {
                    throwable2.addSuppressed(throwable4);
                }
                throw throwable2;
            }
        }
        catch (IOException e) {
            LOG.log(Status.error((String)("Failed to identify file by its hash using search.maven.org: " + file)));
            return Set.of();
        }
    }

    private static Collection<ArtifactKey> scanPomProperties(Path classesLocation) {
        return new HashSet<ArtifactKey>(SCANNER.scan(classesLocation, "pom.properties"));
    }

    private static ArtifactKey readArtifactKey(Properties pomProperties) {
        String groupId = pomProperties.getProperty("groupId");
        String artifactId = pomProperties.getProperty("artifactId");
        String version = pomProperties.getProperty("version");
        if (groupId != null && artifactId != null && version != null) {
            return new ArtifactKey(groupId, artifactId, version, null);
        }
        return null;
    }

    public static Path resolveSourceLocation(ArtifactKey artifact, IProgressMonitor monitor) {
        String groupId = artifact.groupId();
        String artifactId = artifact.artifactId();
        String version = artifact.version();
        try {
            ArrayList repositories = new ArrayList();
            IMaven maven = MavenPlugin.getMaven();
            repositories.addAll(maven.getArtifactRepositories());
            repositories.addAll(maven.getPluginArtifactRepositories());
            if (!maven.isUnavailable(groupId, artifactId, version, "jar", "sources", repositories)) {
                Artifact resolve = maven.resolve(groupId, artifactId, version, "jar", "sources", null, monitor);
                return resolve.getFile().toPath().toAbsolutePath();
            }
        }
        catch (CoreException e) {
            LOG.error("Failed to obtain source for artifact " + artifact, (Throwable)e);
        }
        return null;
    }
}

