/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.editor.dialogs;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.ui.internal.components.PomHierarchyTreeWrapper;
import org.eclipse.m2e.core.ui.internal.dialogs.AbstractMavenDialog;
import org.eclipse.m2e.core.ui.internal.editing.PomEdits;
import org.eclipse.m2e.core.ui.internal.editing.PomHelper;
import org.eclipse.m2e.core.ui.internal.util.ParentHierarchyEntry;
import org.eclipse.m2e.editor.composites.DependencyLabelProvider;
import org.eclipse.m2e.editor.composites.ListEditorContentProvider;
import org.eclipse.m2e.editor.dialogs.Messages;
import org.eclipse.m2e.editor.pom.ValueProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ManageDependenciesDialog
extends AbstractMavenDialog {
    private static final Logger LOG = LoggerFactory.getLogger(ManageDependenciesDialog.class);
    private static final String DIALOG_SETTINGS = ManageDependenciesDialog.class.getName();
    private TableViewer dependenciesViewer;
    private final List<ParentHierarchyEntry> projectHierarchy;
    private PomHierarchyTreeWrapper pomHierarchy;
    private IStatus status;
    private final List<Object> originalSelection;
    private final ValueProvider<List<Dependency>> modelVProvider;

    public ManageDependenciesDialog(Shell parent, ValueProvider<List<Dependency>> modelVProvider, List<ParentHierarchyEntry> hierarchy) {
        this(parent, modelVProvider, hierarchy, null);
    }

    public ManageDependenciesDialog(Shell parent, ValueProvider<List<Dependency>> modelVProvider, List<ParentHierarchyEntry> hierarchy, List<Object> selection) {
        super(parent, DIALOG_SETTINGS);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.setTitle(Messages.ManageDependenciesDialog_dialogTitle);
        this.projectHierarchy = hierarchy;
        this.originalSelection = selection;
        this.modelVProvider = modelVProvider;
    }

    protected Control createDialogArea(Composite parent) {
        this.readSettings();
        Composite composite = (Composite)super.createDialogArea(parent);
        Label infoLabel = new Label(composite, 64);
        infoLabel.setText(Messages.ManageDependenciesDialog_dialogInfo);
        Label horizontalBar = new Label(composite, 258);
        SashForm sashForm = new SashForm(composite, 65792);
        Composite dependenciesComposite = new Composite((Composite)sashForm, 0);
        Label selectDependenciesLabel = new Label(dependenciesComposite, 0);
        selectDependenciesLabel.setText(Messages.ManageDependenciesDialog_selectDependenciesLabel);
        final Table dependenciesTable = new Table(dependenciesComposite, 0x800802);
        final TableColumn column = new TableColumn(dependenciesTable, 0);
        dependenciesTable.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                column.setWidth(dependenciesTable.getClientArea().width);
            }
        });
        Composite pomComposite = new Composite((Composite)sashForm, 0);
        Label selectPomLabel = new Label(pomComposite, 0);
        selectPomLabel.setText(Messages.ManageDependenciesDialog_selectPOMLabel);
        this.pomHierarchy = new PomHierarchyTreeWrapper(pomComposite, 2048);
        this.pomHierarchy.setHierarchy(this.getProjectHierarchy());
        GridLayout layout = new GridLayout(1, false);
        composite.setLayout((Layout)layout);
        GridData gridData = new GridData(4, 0, true, false);
        gridData.widthHint = 300;
        infoLabel.setLayoutData((Object)gridData);
        gridData = new GridData(4, 0, true, false);
        horizontalBar.setLayoutData((Object)gridData);
        gridData = new GridData(4, 4, true, true);
        sashForm.setLayoutData((Object)gridData);
        gridData = new GridData(4, 4, true, true);
        dependenciesComposite.setLayoutData((Object)gridData);
        layout = new GridLayout(1, false);
        dependenciesComposite.setLayout((Layout)layout);
        gridData = new GridData(4, 0, true, false);
        selectDependenciesLabel.setLayoutData((Object)gridData);
        gridData = new GridData(4, 4, true, true);
        dependenciesTable.setLayoutData((Object)gridData);
        gridData = new GridData(4, 4, true, true);
        pomComposite.setLayoutData((Object)gridData);
        layout = new GridLayout(1, false);
        pomComposite.setLayout((Layout)layout);
        gridData = new GridData(4, 0, true, false);
        selectPomLabel.setLayoutData((Object)gridData);
        gridData = new GridData(4, 4, true, true);
        this.pomHierarchy.getTreeComposite().setLayoutData((Object)gridData);
        this.dependenciesViewer = new TableViewer(dependenciesTable);
        this.dependenciesViewer.setLabelProvider((IBaseLabelProvider)new DependencyLabelProvider());
        this.dependenciesViewer.setContentProvider(new ListEditorContentProvider());
        List<Dependency> deps = this.modelVProvider.getValue();
        ArrayList<Dependency> nonManaged = new ArrayList<Dependency>();
        if (deps != null) {
            for (Dependency d : deps) {
                if (d.getVersion() == null) continue;
                nonManaged.add(d);
            }
        }
        this.dependenciesViewer.setInput(nonManaged);
        this.dependenciesViewer.addSelectionChangedListener((ISelectionChangedListener)new DependenciesViewerSelectionListener());
        this.pomHierarchy.addSelectionChangedListener((ISelectionChangedListener)new PomViewerSelectionChangedListener());
        if (!this.getProjectHierarchy().isEmpty()) {
            this.pomHierarchy.setSelection((ISelection)new StructuredSelection((Object)this.pomHierarchy.getProject()));
        }
        if (this.originalSelection != null && !this.originalSelection.isEmpty()) {
            this.dependenciesViewer.setSelection((ISelection)new StructuredSelection(this.originalSelection));
        }
        return composite;
    }

    protected void computeResult() {
        ParentHierarchyEntry currentPOM = this.getCurrentPOM();
        ParentHierarchyEntry targetPOM = this.getTargetPOM();
        final IFile current = currentPOM.getResource();
        final IFile target = targetPOM.getResource();
        if (target == null || current == null) {
            return;
        }
        final boolean same = targetPOM.equals(currentPOM);
        final LinkedList<Dependency> modelDeps = this.getDependenciesList();
        Job perform = new Job("Updating POM file(s)"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    if (same) {
                        PomEdits.performOnDOMDocument((PomEdits.OperationTuple[])new PomEdits.OperationTuple[]{new PomEdits.OperationTuple(current, (PomEdits.Operation)new PomEdits.CompoundOperation(new PomEdits.Operation[]{ManageDependenciesDialog.createManageOperation(modelDeps), ManageDependenciesDialog.createRemoveVersionOperation(modelDeps)}))});
                    } else {
                        PomEdits.performOnDOMDocument((PomEdits.OperationTuple[])new PomEdits.OperationTuple[]{new PomEdits.OperationTuple(target, ManageDependenciesDialog.createManageOperation(modelDeps)), new PomEdits.OperationTuple(current, ManageDependenciesDialog.createRemoveVersionOperation(modelDeps))});
                    }
                }
                catch (Exception e) {
                    LOG.error("Error updating managed dependencies", (Throwable)e);
                    return Status.error((String)"Error updating managed dependencies", (Throwable)e);
                }
                return Status.OK_STATUS;
            }
        };
        perform.setUser(false);
        perform.setSystem(true);
        perform.schedule();
    }

    public static PomEdits.Operation createRemoveVersionOperation(List<Dependency> modelDeps) {
        return document -> {
            List deps = PomEdits.findChilds((Element)PomEdits.findChild((Element)document.getDocumentElement(), (String)"dependencies"), (String)"dependency");
            for (Element dep : deps) {
                String grid = PomEdits.getTextValue((Node)PomEdits.findChild((Element)dep, (String)"groupId"));
                String artid = PomEdits.getTextValue((Node)PomEdits.findChild((Element)dep, (String)"artifactId"));
                for (Dependency modelDep : modelDeps) {
                    if (modelDep.getGroupId() == null || !modelDep.getGroupId().equals(grid) || modelDep.getArtifactId() == null || !modelDep.getArtifactId().equals(artid)) continue;
                    PomEdits.removeChild((Element)dep, (Element)PomEdits.findChild((Element)dep, (String)"version"));
                }
            }
        };
    }

    public static PomEdits.Operation createManageOperation(List<Dependency> modelDeps) {
        return document -> {
            ArrayList modelDependencies = new ArrayList(modelDeps);
            Element managedDepsElement = PomEdits.getChild((Element)document.getDocumentElement(), (String[])new String[]{"dependencyManagement", "dependencies"});
            List existing = PomEdits.findChilds((Element)managedDepsElement, (String)"dependency");
            block0: for (Element dep : existing) {
                String artifactId = PomEdits.getTextValue((Node)PomEdits.findChild((Element)dep, (String)"artifactId"));
                String groupId = PomEdits.getTextValue((Node)PomEdits.findChild((Element)dep, (String)"groupId"));
                Iterator mdIter = modelDependencies.iterator();
                while (mdIter.hasNext()) {
                    Dependency md = (Dependency)mdIter.next();
                    if (!artifactId.equals(md.getArtifactId()) || !groupId.equals(md.getGroupId())) continue;
                    mdIter.remove();
                    continue block0;
                }
            }
            for (Dependency modelDependency : modelDependencies) {
                PomHelper.createDependency((Element)managedDepsElement, (String)modelDependency.getGroupId(), (String)modelDependency.getArtifactId(), (String)modelDependency.getVersion());
            }
        };
    }

    protected LinkedList<Dependency> getDependenciesList() {
        IStructuredSelection selection = (IStructuredSelection)this.dependenciesViewer.getSelection();
        LinkedList<Dependency> dependencies = new LinkedList<Dependency>();
        Object[] objectArray = selection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            dependencies.add((Dependency)obj);
            ++n2;
        }
        return dependencies;
    }

    protected List<ParentHierarchyEntry> getProjectHierarchy() {
        return this.projectHierarchy;
    }

    protected ParentHierarchyEntry getTargetPOM() {
        IStructuredSelection selection = (IStructuredSelection)this.pomHierarchy.getSelection();
        return (ParentHierarchyEntry)selection.getFirstElement();
    }

    protected ParentHierarchyEntry getCurrentPOM() {
        return this.pomHierarchy.getProject();
    }

    protected boolean checkDependencies(Model model, LinkedList<Dependency> dependencies) {
        if (this.status != null && this.status.getCode() == 4) {
            return false;
        }
        if (model == null || model.getDependencyManagement() == null || model.getDependencyManagement().getDependencies() == null || model.getDependencyManagement().getDependencies().isEmpty()) {
            return false;
        }
        for (Dependency selectedDep : dependencies) {
            for (Dependency targetDep : model.getDependencyManagement().getDependencies()) {
                if (!selectedDep.getGroupId().equals(targetDep.getGroupId()) || !selectedDep.getArtifactId().equals(targetDep.getArtifactId()) || selectedDep.getVersion().equals(targetDep.getVersion())) continue;
                String modelID = String.valueOf(model.getGroupId()) + ":" + model.getArtifactId() + ":" + model.getVersion();
                if (targetDep.getLocation((Object)"") != null && targetDep.getLocation((Object)"").getSource() != null) {
                    modelID = targetDep.getLocation((Object)"").getSource().getModelId();
                }
                Object[] arguments = new Object[]{String.valueOf(selectedDep.getArtifactId()) + "-" + selectedDep.getVersion(), targetDep.getVersion(), modelID};
                String message = NLS.bind((String)Messages.ManageDependenciesDialog_dependencyExistsWarning, (Object[])arguments);
                this.updateStatus(Status.warning((String)message));
                return true;
            }
        }
        return false;
    }

    protected void checkStatus(ParentHierarchyEntry targetProject, LinkedList<Dependency> selectedDependencies) {
        if (targetProject == null || selectedDependencies.isEmpty()) {
            this.updateStatus(Status.error((String)Messages.ManageDependenciesDialog_emptySelectionError));
            return;
        }
        boolean error = false;
        if (targetProject.getFacade() == null) {
            error = true;
            this.updateStatus(Status.error((String)Messages.ManageDependenciesDialog_projectNotPresentError));
        } else {
            error = this.checkDependencies(targetProject.getProject().getModel(), this.getDependenciesList());
        }
        if (!error) {
            this.clearStatus();
        }
    }

    protected void clearStatus() {
        this.updateStatus(Status.OK_STATUS);
    }

    protected void updateStatus(IStatus status) {
        this.status = status;
        super.updateStatus(status);
    }

    public class ContentProvider
    implements ITreeContentProvider {
        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public boolean hasChildren(Object element) {
            Object[] children = this.getChildren(element);
            return children.length != 0;
        }

        /*
         * WARNING - void declaration
         */
        public Object getParent(Object element) {
            void var3_2;
            MavenProject mavenProject;
            Object object = element;
            if (object instanceof MavenProject && (mavenProject = (MavenProject)object) == (MavenProject)var3_2) {
                void project;
                return project.getParent();
            }
            return null;
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof LinkedList) {
                LinkedList projects = (LinkedList)inputElement;
                if (projects.isEmpty()) {
                    return new Object[0];
                }
                return new Object[]{projects.getLast()};
            }
            return new Object[0];
        }

        /*
         * WARNING - void declaration
         */
        public Object[] getChildren(Object parentElement) {
            void var3_2;
            MavenProject mavenProject;
            Object object = parentElement;
            if (object instanceof MavenProject && (mavenProject = (MavenProject)object) == (MavenProject)var3_2) {
                void parent;
                if (ManageDependenciesDialog.this.getProjectHierarchy().size() == 1) {
                    return new Object[0];
                }
                if (ManageDependenciesDialog.this.getProjectHierarchy().get(0).getProject().equals((Object)parent)) {
                    return new Object[0];
                }
                ListIterator<ParentHierarchyEntry> iter = ManageDependenciesDialog.this.getProjectHierarchy().listIterator();
                while (iter.hasNext()) {
                    ParentHierarchyEntry next = iter.next();
                    if (!next.getProject().equals((Object)parent)) continue;
                    iter.previous();
                    ParentHierarchyEntry previous = iter.previous();
                    return new Object[]{previous};
                }
            }
            return new Object[0];
        }
    }

    public static class DepLabelProvider
    extends LabelProvider
    implements IColorProvider {
        public String getText(Object element) {
            MavenProject project = null;
            if (element instanceof MavenProject var3_4) {
                project = mavenProject;
            } else {
                if (element instanceof Object[] var5_6) {
                    project = (MavenProject)array[0];
                } else {
                    return "";
                }
            }
            StringBuilder buffer = new StringBuilder();
            buffer.append(String.valueOf(project.getGroupId()) + " : " + project.getArtifactId() + " : " + project.getVersion());
            return buffer.toString();
        }

        /*
         * WARNING - void declaration
         */
        public Color getForeground(Object element) {
            void project;
            IMavenProjectFacade search;
            void var3_2;
            MavenProject mavenProject;
            Object object = element;
            if (object instanceof MavenProject && (mavenProject = (MavenProject)object) == (MavenProject)var3_2 && (search = MavenPlugin.getMavenProjectRegistry().getMavenProject(project.getGroupId(), project.getArtifactId(), project.getVersion())) == null) {
                return Display.getDefault().getSystemColor(16);
            }
            return null;
        }

        public Color getBackground(Object element) {
            return null;
        }
    }

    protected class DependenciesViewerSelectionListener
    implements ISelectionChangedListener {
        protected DependenciesViewerSelectionListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            ManageDependenciesDialog.this.checkStatus(ManageDependenciesDialog.this.getTargetPOM(), ManageDependenciesDialog.this.getDependenciesList());
        }
    }

    protected class PomViewerSelectionChangedListener
    implements ISelectionChangedListener {
        protected PomViewerSelectionChangedListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            ManageDependenciesDialog.this.checkStatus(ManageDependenciesDialog.this.getTargetPOM(), ManageDependenciesDialog.this.getDependenciesList());
        }
    }
}

