/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.project;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public interface IProjectConfiguration {
    public Map<String, String> getConfigurationProperties();

    public boolean isResolveWorkspaceProjects();

    public String getSelectedProfiles();

    default public List<String> getActiveProfileList() {
        return IProjectConfiguration.parseProfiles(this.getSelectedProfiles(), true);
    }

    default public List<String> getInactiveProfileList() {
        return IProjectConfiguration.parseProfiles(this.getSelectedProfiles(), false);
    }

    public String getLifecycleMappingId();

    public File getMultiModuleProjectDirectory();

    private static List<String> parseProfiles(String profilesAsText, boolean status) {
        ArrayList<String> profiles;
        if (profilesAsText != null && profilesAsText.trim().length() > 0) {
            String[] profilesArray = profilesAsText.split("[,\\s\\|]");
            profiles = new ArrayList(profilesArray.length);
            String[] stringArray = profilesArray;
            int n = profilesArray.length;
            int n2 = 0;
            while (n2 < n) {
                boolean isActive;
                String profile = stringArray[n2];
                boolean bl = isActive = !profile.startsWith("!");
                if (status == isActive) {
                    profile = isActive ? profile : profile.substring(1);
                    profiles.add(profile);
                }
                ++n2;
            }
        } else {
            profiles = new ArrayList<String>(0);
        }
        return profiles;
    }
}

