/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.project.registry;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.lifecycle.DefaultLifecycles;
import org.apache.maven.lifecycle.MavenExecutionPlan;
import org.apache.maven.lifecycle.internal.LifecycleExecutionPlanCalculator;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.m2e.core.embedder.ArtifactKey;
import org.eclipse.m2e.core.embedder.ArtifactRef;
import org.eclipse.m2e.core.embedder.ArtifactRepositoryRef;
import org.eclipse.m2e.core.embedder.IComponentLookup;
import org.eclipse.m2e.core.embedder.IMavenExecutionContext;
import org.eclipse.m2e.core.internal.IMavenToolbox;
import org.eclipse.m2e.core.internal.Messages;
import org.eclipse.m2e.core.internal.embedder.IMavenPlexusContainer;
import org.eclipse.m2e.core.internal.embedder.MavenExecutionContext;
import org.eclipse.m2e.core.internal.embedder.PlexusContainerManager;
import org.eclipse.m2e.core.internal.project.registry.ProjectRegistryManager;
import org.eclipse.m2e.core.lifecyclemapping.model.IPluginExecutionMetadata;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.IProjectConfiguration;
import org.eclipse.m2e.core.project.MavenProjectUtils;
import org.eclipse.m2e.core.project.ResolverConfiguration;
import org.eclipse.m2e.core.project.configurator.MojoExecutionKey;
import org.eclipse.osgi.util.NLS;

public class MavenProjectFacade
implements IMavenProjectFacade,
Serializable {
    private static final long serialVersionUID = -3648172776786224087L;
    private static final String CTX_EXECUTION_PLANS = String.valueOf(MavenProjectFacade.class.getName()) + "/executionPlans";
    private static final String CTX_SETUP_EXECUTIONS = String.valueOf(MavenProjectFacade.class.getName()) + "/setupExecutions";
    public static final String PROP_LIFECYCLE_MAPPING = String.valueOf(MavenProjectFacade.class.getName()) + "/lifecycleMapping";
    public static final String PROP_CONFIGURATORS = String.valueOf(MavenProjectFacade.class.getName()) + "/configurators";
    private final ProjectRegistryManager manager;
    private final IFile pom;
    private final File pomFile;
    private final IProjectConfiguration resolverConfiguration;
    private final long[] timestamp;
    private final ArtifactKey artifactKey;
    private final List<String> modules;
    private final String packaging;
    private final List<IPath> resourceLocations;
    private final List<IPath> testResourceLocations;
    private final List<IPath> compileSourceLocations;
    private final List<IPath> testCompileSourceLocations;
    private final IPath outputLocation;
    private final IPath testOutputLocation;
    private final String finalName;
    private final Set<ArtifactRepositoryRef> artifactRepositories;
    private final Set<ArtifactRepositoryRef> pluginArtifactRepositories;
    private Set<ArtifactRef> artifacts;
    private String lifecycleMappingId;
    private Map<MojoExecutionKey, List<IPluginExecutionMetadata>> mojoExecutionMapping;
    private transient Map<String, Object> sessionProperties;

    public MavenProjectFacade(ProjectRegistryManager manager, IFile pom, MavenProject mavenProject, IProjectConfiguration resolverConfiguration) {
        this.manager = manager;
        this.pom = pom;
        this.pomFile = ProjectRegistryManager.toJavaIoFile(pom);
        this.resolverConfiguration = new MavenProjectConfiguration(resolverConfiguration, PlexusContainerManager.computeMultiModuleProjectDirectory(this.pomFile));
        this.artifactKey = new ArtifactKey(mavenProject.getArtifact());
        this.packaging = mavenProject.getPackaging();
        this.modules = mavenProject.getModules();
        this.resourceLocations = MavenProjectUtils.getResourceLocations(this.getProject(), mavenProject.getResources());
        this.testResourceLocations = MavenProjectUtils.getResourceLocations(this.getProject(), mavenProject.getTestResources());
        this.compileSourceLocations = MavenProjectUtils.getSourceLocations(this.getProject(), mavenProject.getCompileSourceRoots());
        this.testCompileSourceLocations = MavenProjectUtils.getSourceLocations(this.getProject(), mavenProject.getTestCompileSourceRoots());
        IPath fullPath = this.getProject().getFullPath();
        IPath path = this.getProjectRelativePath(mavenProject.getBuild().getOutputDirectory());
        this.outputLocation = path != null ? fullPath.append(path) : null;
        path = this.getProjectRelativePath(mavenProject.getBuild().getTestOutputDirectory());
        this.testOutputLocation = path != null ? fullPath.append(path) : null;
        this.finalName = mavenProject.getBuild().getFinalName();
        this.artifactRepositories = this.toRepositoryReferences(mavenProject.getRemoteArtifactRepositories());
        this.pluginArtifactRepositories = this.toRepositoryReferences(mavenProject.getPluginArtifactRepositories());
        this.timestamp = new long[ProjectRegistryManager.METADATA_PATH.size() + 1];
        IProject project = this.getProject();
        int i = 0;
        for (IPath metadataPath : ProjectRegistryManager.METADATA_PATH) {
            this.timestamp[i] = MavenProjectFacade.getModificationStamp(project.getFile(metadataPath));
            ++i;
        }
        this.timestamp[this.timestamp.length - 1] = MavenProjectFacade.getModificationStamp(pom);
    }

    private Set<ArtifactRepositoryRef> toRepositoryReferences(List<ArtifactRepository> artifactRepositories) {
        return artifactRepositories.stream().map(r -> {
            String username = r.getAuthentication() != null ? r.getAuthentication().getUsername() : null;
            return new ArtifactRepositoryRef(r.getId(), r.getUrl(), username);
        }).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public MavenProjectFacade(MavenProjectFacade other) {
        this.manager = other.manager;
        this.pom = other.pom;
        this.pomFile = other.pomFile;
        this.resolverConfiguration = other.resolverConfiguration;
        this.artifactKey = other.artifactKey;
        this.packaging = other.packaging;
        this.modules = new ArrayList<String>(other.modules);
        this.resourceLocations = List.copyOf(other.resourceLocations);
        this.testResourceLocations = List.copyOf(other.testResourceLocations);
        this.compileSourceLocations = List.copyOf(other.compileSourceLocations);
        this.testCompileSourceLocations = List.copyOf(other.testCompileSourceLocations);
        this.outputLocation = other.outputLocation;
        this.testOutputLocation = other.testOutputLocation;
        this.finalName = other.finalName;
        this.artifactRepositories = new LinkedHashSet<ArtifactRepositoryRef>(other.artifactRepositories);
        this.pluginArtifactRepositories = new LinkedHashSet<ArtifactRepositoryRef>(other.pluginArtifactRepositories);
        this.timestamp = Arrays.copyOf(other.timestamp, other.timestamp.length);
    }

    @Override
    public List<IPath> getResourceLocations() {
        return this.resourceLocations;
    }

    @Override
    public List<IPath> getTestResourceLocations() {
        return this.testResourceLocations;
    }

    @Override
    public List<IPath> getCompileSourceLocations() {
        return this.compileSourceLocations;
    }

    @Override
    public List<IPath> getTestCompileSourceLocations() {
        return this.testCompileSourceLocations;
    }

    @Override
    public IPath getProjectRelativePath(String resourceLocation) {
        return MavenProjectUtils.getProjectRelativePath(this.getProject(), resourceLocation);
    }

    @Override
    public IPath getOutputLocation() {
        return this.outputLocation;
    }

    @Override
    public IPath getTestOutputLocation() {
        return this.testOutputLocation;
    }

    @Override
    public String getFinalName() {
        return this.finalName;
    }

    @Override
    public IPath getFullPath() {
        return this.getProject().getFullPath();
    }

    @Override
    public MavenProject getMavenProject(IProgressMonitor monitor) throws CoreException {
        return this.manager.getMavenProject(this, monitor);
    }

    @Override
    public MavenProject getMavenProject() {
        return this.manager.getMavenProject(this);
    }

    @Override
    public String getPackaging() {
        return this.packaging;
    }

    @Override
    public IProject getProject() {
        return this.pom.getProject();
    }

    @Override
    public IFile getPom() {
        return this.pom;
    }

    @Override
    public File getPomFile() {
        return this.pomFile;
    }

    public File getBaseDir() {
        if (this.pomFile != null) {
            return this.pomFile.isDirectory() ? this.pomFile : this.pomFile.getParentFile();
        }
        return null;
    }

    @Override
    public IPath getFullPath(File file) {
        return MavenProjectUtils.getFullPath(this.getProject(), file);
    }

    @Override
    public List<String> getMavenProjectModules() {
        return this.modules;
    }

    @Override
    public Set<ArtifactRef> getMavenProjectArtifacts() {
        return this.artifacts;
    }

    void setMavenProjectArtifacts(MavenProject mavenProject) {
        Set collect = mavenProject.getArtifacts().stream().map(a -> new ArtifactRef(new ArtifactKey((Artifact)a), a.getScope())).collect(Collectors.toCollection(LinkedHashSet::new));
        this.artifacts = Collections.unmodifiableSet(collect);
    }

    @Override
    public ResolverConfiguration getResolverConfiguration() {
        return new ResolverConfiguration(this.resolverConfiguration);
    }

    @Override
    public IProjectConfiguration getConfiguration() {
        return this.resolverConfiguration;
    }

    @Override
    public boolean isStale() {
        IProject project = this.getProject();
        int i = 0;
        for (IPath path : ProjectRegistryManager.METADATA_PATH) {
            if (this.timestamp[i++] == MavenProjectFacade.getModificationStamp(project.getFile(path))) continue;
            return true;
        }
        return false;
    }

    private static long getModificationStamp(IFile file) {
        return file.getLocalTimeStamp() + file.getModificationStamp();
    }

    @Override
    public ArtifactKey getArtifactKey() {
        return this.artifactKey;
    }

    @Override
    public synchronized void setSessionProperty(String key, Object value) {
        if (this.sessionProperties == null) {
            this.sessionProperties = new HashMap<String, Object>();
        }
        if (value != null) {
            this.sessionProperties.put(key, value);
        } else {
            this.sessionProperties.remove(key);
        }
    }

    @Override
    public synchronized Object getSessionProperty(String key) {
        return this.sessionProperties != null ? this.sessionProperties.get(key) : null;
    }

    @Override
    public Set<ArtifactRepositoryRef> getArtifactRepositoryRefs() {
        return this.artifactRepositories;
    }

    @Override
    public Set<ArtifactRepositoryRef> getPluginArtifactRepositoryRefs() {
        return this.pluginArtifactRepositories;
    }

    public String toString() {
        return this.getProject() + ": " + this.getArtifactKey();
    }

    @Override
    public String getLifecycleMappingId() {
        return this.lifecycleMappingId;
    }

    public void setLifecycleMappingId(String lifecycleMappingId) {
        this.lifecycleMappingId = lifecycleMappingId;
    }

    @Override
    public Map<MojoExecutionKey, List<IPluginExecutionMetadata>> getMojoExecutionMapping() {
        return this.mojoExecutionMapping;
    }

    public void setMojoExecutionMapping(Map<MojoExecutionKey, List<IPluginExecutionMetadata>> mojoExecutionMapping) {
        this.mojoExecutionMapping = mojoExecutionMapping;
    }

    private Map<String, List<MojoExecution>> getExecutionPlans(IProgressMonitor monitor) throws CoreException {
        MavenProject mavenProject = this.getMavenProject(monitor);
        Map<String, List<MojoExecution>> executionPlans = (Map<String, List<MojoExecution>>)MavenProjectFacade.getContextValue(mavenProject, CTX_EXECUTION_PLANS);
        if (executionPlans == null) {
            executionPlans = this.calculateExecutionPlans(mavenProject, monitor);
            mavenProject.setContextValue(CTX_EXECUTION_PLANS, executionPlans);
        }
        return executionPlans;
    }

    private Map<String, List<MojoExecution>> calculateExecutionPlans(MavenProject mavenProject, IProgressMonitor monitor) {
        LinkedHashMap<String, List<MojoExecution>> executionPlans = new LinkedHashMap<String, List<MojoExecution>>();
        executionPlans.put("clean", this.calculateExecutionPlan(mavenProject, List.of("clean"), false, monitor).getMojoExecutions());
        executionPlans.put("deploy", this.calculateExecutionPlan(mavenProject, List.of("deploy"), false, monitor).getMojoExecutions());
        executionPlans.put("site", this.calculateExecutionPlan(mavenProject, List.of("site"), false, monitor).getMojoExecutions());
        return executionPlans;
    }

    @Override
    public MavenExecutionPlan calculateExecutionPlan(Collection<String> tasks, IProgressMonitor monitor) {
        return this.calculateExecutionPlan(this.getMavenProject(), tasks, false, monitor);
    }

    @Override
    public MavenExecutionPlan setupExecutionPlan(Collection<String> tasks, IProgressMonitor monitor) {
        return this.calculateExecutionPlan(this.getMavenProject(), tasks, true, monitor);
    }

    private MavenExecutionPlan calculateExecutionPlan(MavenProject mavenProject, Collection<String> tasks, boolean setup, IProgressMonitor monitor) {
        try {
            return this.createExecutionContext().execute(mavenProject, (ctx, mon) -> {
                IMavenToolbox toolbox = IMavenToolbox.of(ctx);
                return toolbox.calculateExecutionPlan(tasks, setup);
            }, monitor);
        }
        catch (CoreException e) {
            this.manager.getMarkerManager().addErrorMarkers((IResource)this.pom, "org.eclipse.m2e.core.maven2Problem.pomloading", (Exception)((Object)e));
            return new MavenExecutionPlan(List.of(), new DefaultLifecycles());
        }
    }

    private static <T> T getContextValue(MavenProject mavenProject, String key) {
        return (T)mavenProject.getContextValue(key);
    }

    private Map<MojoExecutionKey, MojoExecution> getSetupMojoExecutions(IProgressMonitor monitor) throws CoreException {
        MavenProject mavenProject = this.getMavenProject(monitor);
        LinkedHashMap executionPlans = (LinkedHashMap)MavenProjectFacade.getContextValue(mavenProject, CTX_SETUP_EXECUTIONS);
        if (executionPlans == null) {
            executionPlans = new LinkedHashMap();
            mavenProject.setContextValue(CTX_SETUP_EXECUTIONS, executionPlans);
        }
        return executionPlans;
    }

    @Override
    public MojoExecution getMojoExecution(MojoExecutionKey mojoExecutionKey, IProgressMonitor monitor) throws CoreException {
        Map<MojoExecutionKey, MojoExecution> setupMojoExecutions = this.getSetupMojoExecutions(monitor);
        MojoExecution execution = setupMojoExecutions.get(mojoExecutionKey);
        if (execution == null) {
            for (MojoExecution mojoExecution : this.getMojoExecutions(monitor)) {
                if (!this.match(mojoExecutionKey, mojoExecution)) continue;
                execution = this.setupMojoExecution(mojoExecution, monitor);
                setupMojoExecutions.put(mojoExecutionKey, execution);
                break;
            }
        }
        return execution;
    }

    private MojoExecution setupMojoExecution(MojoExecution mojoExecution, IProgressMonitor monitor) throws CoreException {
        MavenProject mavenProject = this.getMavenProject(monitor);
        MojoExecution clone = new MojoExecution(mojoExecution.getPlugin(), mojoExecution.getGoal(), mojoExecution.getExecutionId());
        clone.setMojoDescriptor(mojoExecution.getMojoDescriptor());
        if (mojoExecution.getConfiguration() != null) {
            clone.setConfiguration(new Xpp3Dom(mojoExecution.getConfiguration()));
        }
        clone.setLifecyclePhase(mojoExecution.getLifecyclePhase());
        this.createExecutionContext().execute(mavenProject, (ctx, mon) -> {
            LifecycleExecutionPlanCalculator executionPlanCalculator = ctx.getComponentLookup().lookup(LifecycleExecutionPlanCalculator.class);
            try {
                executionPlanCalculator.setupMojoExecution(ctx.getSession(), mavenProject, clone);
            }
            catch (Exception ex) {
                throw new CoreException(Status.error((String)NLS.bind((String)Messages.MavenImpl_error_calc_build_plan, (Object)ex.getMessage()), (Throwable)ex));
            }
            return null;
        }, monitor);
        return clone;
    }

    private boolean match(MojoExecutionKey key, MojoExecution mojoExecution) {
        if (mojoExecution == null) {
            return false;
        }
        return key.groupId().equals(mojoExecution.getGroupId()) && key.artifactId().equals(mojoExecution.getArtifactId()) && key.version().equals(mojoExecution.getVersion()) && key.goal().equals(mojoExecution.getGoal()) && key.executionId().equals(mojoExecution.getExecutionId());
    }

    @Override
    public List<MojoExecution> getMojoExecutions(String groupId, String artifactId, IProgressMonitor monitor, String ... goals) throws CoreException {
        ArrayList<MojoExecution> result = new ArrayList<MojoExecution>();
        Set<String> consideredGoals = Set.of(goals);
        Map<MojoExecutionKey, MojoExecution> setupMojoExecutions = this.getSetupMojoExecutions(monitor);
        for (MojoExecution mojoExecution : this.getMojoExecutions(monitor)) {
            if (!groupId.equals(mojoExecution.getGroupId()) || !artifactId.equals(mojoExecution.getArtifactId()) || !consideredGoals.contains(mojoExecution.getGoal())) continue;
            MojoExecutionKey key = new MojoExecutionKey(mojoExecution);
            MojoExecution execution = setupMojoExecutions.get(key);
            if (execution == null) {
                execution = this.setupMojoExecution(mojoExecution, monitor);
                setupMojoExecutions.put(key, execution);
            }
            result.add(execution);
        }
        return result;
    }

    public List<MojoExecution> getMojoExecutions() {
        try {
            return this.getMojoExecutions(null);
        }
        catch (CoreException ex) {
            return null;
        }
    }

    public List<MojoExecution> getMojoExecutions(IProgressMonitor monitor) throws CoreException {
        Map<String, List<MojoExecution>> executionPlans = this.getExecutionPlans(monitor);
        return executionPlans.values().stream().filter(Objects::nonNull).flatMap(Collection::stream).toList();
    }

    public List<MojoExecution> getExecutionPlan(String lifecycle, IProgressMonitor monitor) throws CoreException {
        return this.getExecutionPlans(monitor).get(lifecycle);
    }

    @Override
    public IMavenExecutionContext createExecutionContext() {
        try {
            File multiModuleProjectDirectory = this.getConfiguration().getMultiModuleProjectDirectory();
            IMavenPlexusContainer container = this.manager.getContainerManager().aquire(multiModuleProjectDirectory);
            MavenProject mavenProject = this.getMavenProject(null);
            if (mavenProject == null) {
                return new MavenExecutionContext(container.getComponentLookup(), this.getBaseDir(), multiModuleProjectDirectory, null);
            }
            return new MavenExecutionContext(PlexusContainerManager.wrap(container.getContainer(), mavenProject.getClassRealm()), this.getBaseDir(), multiModuleProjectDirectory, ctx -> mavenProject);
        }
        catch (Exception ex) {
            throw new RuntimeException("Aquire container failed!", ex);
        }
    }

    @Override
    public IComponentLookup getComponentLookup() {
        return this.manager.getContainerManager().getComponentLookup(this.getConfiguration().getMultiModuleProjectDirectory());
    }

    private static final class MavenProjectConfiguration
    implements IProjectConfiguration,
    Serializable {
        private final File multiModuleProjectDirectory;
        private final String mappingId;
        private final Map<String, String> properties;
        private final boolean resolveWorkspace;
        private final String profiles;

        public MavenProjectConfiguration(IProjectConfiguration baseConfiguration, File multiModuleProjectDirectory) {
            if (baseConfiguration == null) {
                baseConfiguration = new ResolverConfiguration();
            }
            this.multiModuleProjectDirectory = multiModuleProjectDirectory;
            this.mappingId = baseConfiguration.getLifecycleMappingId();
            this.properties = Map.copyOf(baseConfiguration.getConfigurationProperties());
            this.resolveWorkspace = baseConfiguration.isResolveWorkspaceProjects();
            this.profiles = baseConfiguration.getSelectedProfiles();
        }

        @Override
        public Map<String, String> getConfigurationProperties() {
            return this.properties;
        }

        @Override
        public boolean isResolveWorkspaceProjects() {
            return this.resolveWorkspace;
        }

        @Override
        public String getSelectedProfiles() {
            return this.profiles;
        }

        @Override
        public String getLifecycleMappingId() {
            return this.mappingId;
        }

        @Override
        public File getMultiModuleProjectDirectory() {
            return this.multiModuleProjectDirectory;
        }

        public int hashCode() {
            return Objects.hash(this.mappingId, this.multiModuleProjectDirectory, this.profiles, this.properties, this.resolveWorkspace);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MavenProjectConfiguration other = (MavenProjectConfiguration)obj;
            return Objects.equals(this.mappingId, other.mappingId) && Objects.equals(this.multiModuleProjectDirectory, other.multiModuleProjectDirectory) && Objects.equals(this.profiles, other.profiles) && Objects.equals(this.properties, other.properties) && this.resolveWorkspace == other.resolveWorkspace;
        }
    }
}

