/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.project;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.m2e.core.internal.project.DependencyResolutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectProcessingTracker {
    static final int MAX_ITERATIONS = Integer.getInteger("m2e.project.refresh.maxiterations", 5);
    static final Logger log = LoggerFactory.getLogger(ProjectProcessingTracker.class);
    private Set<IFile> processed = new LinkedHashSet<IFile>();
    private Set<IFile> changedWhileRunning = new LinkedHashSet<IFile>();
    private Set<IFile> seed;
    private DependencyResolutionContext context;
    private int iterations;

    public ProjectProcessingTracker(DependencyResolutionContext context) {
        this.context = context;
        this.seed = context.getCurrent();
    }

    public boolean needsImprovement() {
        if (this.changedWhileRunning.isEmpty()) {
            log.debug("Nothing changed in this cycle.");
            return false;
        }
        if (this.seed.isEmpty()) {
            log.debug("Seed is empty.");
            return false;
        }
        ++this.iterations;
        if (this.iterations > MAX_ITERATIONS) {
            log.debug("Configured maximum of {} iterations reached!", (Object)this.iterations);
            return false;
        }
        log.debug("seed =      {}", this.seed);
        log.debug("processed = {}", this.processed);
        log.debug("changed =   {}", this.changedWhileRunning);
        boolean removed = false;
        Iterator<IFile> iterator = this.seed.iterator();
        while (iterator.hasNext()) {
            IFile file = iterator.next();
            if (this.changedWhileRunning.contains(file)) continue;
            log.debug("{} was improved!", (Object)file);
            iterator.remove();
            removed = true;
        }
        if (removed) {
            this.context.forcePomFiles(this.changedWhileRunning);
            this.seed.addAll(this.changedWhileRunning);
            this.changedWhileRunning.clear();
            this.processed.clear();
            return true;
        }
        log.debug("No new project was refreshed -> no improvement found!");
        return false;
    }

    public boolean shouldProcess(IFile pom) {
        if (this.processed.add(pom)) {
            return true;
        }
        this.changedWhileRunning.add(pom);
        return false;
    }
}

