/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.editors.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jst.jsf.common.ui.internal.logging.Logger;
import org.eclipse.jst.pagedesigner.PDPlugin;
import org.eclipse.jst.pagedesigner.actions.range.DesignerToolBarAction;
import org.eclipse.jst.pagedesigner.editors.HTMLEditor;
import org.eclipse.jst.pagedesigner.editors.IDesignViewer;
import org.eclipse.jst.pagedesigner.editors.SimpleGraphicalEditor;
import org.eclipse.jst.pagedesigner.editors.actions.DesignActionBarFactory;
import org.eclipse.jst.pagedesigner.viewer.IHTMLGraphicalViewer;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.part.EditorActionBarContributor;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;

public class DesignPageActionContributor
extends EditorActionBarContributor {
    private static final Logger _log = PDPlugin.getLogger(DesignPageActionContributor.class);
    public static final String PARAGRAPH_ACTION_ID = "paragraph";
    private IEditorPart _editorPart;
    private DesignerToolBarAction uAction = null;
    private DesignerToolBarAction bAction = null;
    private DesignerToolBarAction iAction = null;
    private DesignerToolBarAction smallAction = null;
    private DesignerToolBarAction bigAction = null;

    protected void doRemove(IContributionManager manager, String id) {
        try {
            if (manager.find(id) != null) {
                manager.remove(id);
            }
        }
        catch (Exception e) {
            _log.info("Error:", (Throwable)e);
        }
    }

    public void init(IActionBars bars, IWorkbenchPage page) {
        super.init(bars);
        this.init(bars);
    }

    public void init(IActionBars bars) {
        IToolBarManager toolbar = bars.getToolBarManager();
        this.initToolbar(toolbar);
    }

    private void initToolbar(IToolBarManager toolbar) {
        DesignActionBarFactory factory = DesignActionBarFactory.getInstance();
        this.uAction = factory.getStyleAction("u");
        toolbar.add((IAction)this.uAction);
        this.bAction = factory.getStyleAction("b");
        toolbar.add((IAction)this.bAction);
        this.iAction = factory.getStyleAction("i");
        toolbar.add((IAction)this.iAction);
        this.smallAction = factory.getStyleAction("small");
        toolbar.add((IAction)this.smallAction);
        this.bigAction = factory.getStyleAction("big");
        toolbar.add((IAction)this.bigAction);
    }

    protected void addActionWithId(IMenuManager menuManager, Action action, String id) {
        action.setId(id);
        menuManager.add((IAction)action);
    }

    public void setViewerSpecificContributionsEnabled(boolean enabled) {
        HTMLEditor htmlEditor = null;
        if (this._editorPart instanceof HTMLEditor) {
            htmlEditor = (HTMLEditor)this._editorPart;
        } else if (this._editorPart instanceof SimpleGraphicalEditor) {
            htmlEditor = ((SimpleGraphicalEditor)this._editorPart).getHTMLEditor();
        }
        if (htmlEditor == null) {
            return;
        }
        SimpleGraphicalEditor graphicalEditor = (SimpleGraphicalEditor)htmlEditor.getDesignViewer();
        IWorkbenchPartSite site = htmlEditor.getSite();
        if (site instanceof IEditorSite) {
            IActionBars actionBars = ((IEditorSite)site).getActionBars();
            if (enabled) {
                actionBars.setGlobalActionHandler(ITextEditorActionConstants.UNDO, graphicalEditor.getAction("org.eclipse.ui.edit.undo"));
                actionBars.setGlobalActionHandler(ITextEditorActionConstants.REDO, graphicalEditor.getAction("org.eclipse.ui.edit.redo"));
                actionBars.setGlobalActionHandler(ITextEditorActionConstants.DELETE, graphicalEditor.getAction("org.eclipse.ui.edit.delete"));
                actionBars.setGlobalActionHandler(ITextEditorActionConstants.CUT, graphicalEditor.getAction("org.eclipse.ui.edit.cut"));
                actionBars.setGlobalActionHandler(ITextEditorActionConstants.COPY, graphicalEditor.getAction("org.eclipse.ui.edit.copy"));
                actionBars.setGlobalActionHandler(ITextEditorActionConstants.PASTE, graphicalEditor.getAction("org.eclipse.ui.edit.paste"));
            } else {
                actionBars.setGlobalActionHandler(ITextEditorActionConstants.UNDO, null);
                actionBars.setGlobalActionHandler(ITextEditorActionConstants.REDO, null);
                actionBars.setGlobalActionHandler(ITextEditorActionConstants.DELETE, null);
                actionBars.setGlobalActionHandler(ITextEditorActionConstants.CUT, null);
                actionBars.setGlobalActionHandler(ITextEditorActionConstants.COPY, null);
                actionBars.setGlobalActionHandler(ITextEditorActionConstants.PASTE, null);
            }
        }
    }

    public void setActiveEditor(IEditorPart targetEditor) {
        this._editorPart = targetEditor;
        if (targetEditor instanceof SimpleGraphicalEditor) {
            IHTMLGraphicalViewer graphicalViewer = ((SimpleGraphicalEditor)targetEditor).getGraphicViewer();
            this.setViewerOnActions(graphicalViewer);
        } else if (targetEditor instanceof HTMLEditor) {
            IDesignViewer designViewer = ((HTMLEditor)targetEditor).getDesignViewer();
            if (designViewer != null) {
                IHTMLGraphicalViewer graphicalViewer = designViewer.getGraphicViewer();
                this.setViewerOnActions(graphicalViewer);
            }
        } else {
            this.setViewerOnActions(null);
        }
    }

    private void setViewerOnActions(IHTMLGraphicalViewer viewer) {
        IContributionItem[] items = this.getActionBars().getToolBarManager().getItems();
        if (items != null) {
            int i = 0;
            while (i < items.length) {
                IAction action;
                IContributionItem item = items[i];
                if (item instanceof ActionContributionItem && (action = ((ActionContributionItem)item).getAction()) instanceof DesignerToolBarAction) {
                    ((DesignerToolBarAction)action).setViewer(viewer);
                }
                ++i;
            }
        }
        this.uAction.setViewer(viewer);
        this.bAction.setViewer(viewer);
        this.iAction.setViewer(viewer);
        this.smallAction.setViewer(viewer);
        this.bigAction.setViewer(viewer);
    }

    public void disableRangeModeActions() {
        this.uAction.setEnabled(false);
        this.bAction.setEnabled(false);
        this.iAction.setEnabled(false);
        this.smallAction.setEnabled(false);
        this.bigAction.setEnabled(false);
    }

    public void dispose() {
        this._editorPart = null;
    }
}

