/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facelet.core.internal.registry.taglib;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jem.internal.proxy.core.IBeanProxy;
import org.eclipse.jem.internal.proxy.core.IBeanTypeProxy;
import org.eclipse.jem.internal.proxy.core.IStringBeanProxy;
import org.eclipse.jem.internal.proxy.core.ProxyFactoryRegistry;
import org.eclipse.jst.jsf.core.internal.jem.BeanProxyUtil;
import org.eclipse.jst.jsf.facelet.core.internal.registry.taglib.FaceletTagRecord;
import org.eclipse.jst.jsf.facelet.core.internal.registry.taglib.IFaceletTagRecord;
import org.eclipse.jst.jsf.facelet.core.internal.registry.taglib.faceletTaglib.FaceletTaglibTag;
import org.eclipse.jst.jsf.facelet.core.internal.registry.taglib.faceletTaglib_1_0.FaceletLibraryClassTagLib;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LibraryClassBasedTagRecord
extends FaceletTagRecord {
    private static final long serialVersionUID = 4174629773250721041L;
    private static final String STATIC_MEMBER_NAMESPACE = "Namespace";
    private static final String METHOD_NAME_GET_NAMESPACE = "getNamespace";
    private final IProject _project;
    private final FaceletLibraryClassTagLib _model;
    private final ProxyFactoryRegistry _registry;
    private final AtomicBoolean _isInitialized = new AtomicBoolean(false);
    private String _uri;
    private BeanProxyUtil.BeanProxyWrapper _classTypeWrapper;
    private Map<String, FaceletTaglibTag> _tags;

    public LibraryClassBasedTagRecord(ProxyFactoryRegistry registry, FaceletLibraryClassTagLib model, IProject project, IFaceletTagRecord.TagRecordDescriptor descriptor) {
        super(descriptor);
        this._registry = registry;
        this._model = model;
        this._project = project;
    }

    public void initURI() throws CoreException {
        if (this._isInitialized.get()) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.jst.jsf.core", "Cannot initURI once the library is initialized for: " + this._model.getLibraryClass()));
        }
        IBeanTypeProxy libFactoryTypeProxy = this._registry.getBeanTypeProxyFactory().getBeanTypeProxy(this._model.getLibraryClass());
        if (libFactoryTypeProxy == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.jst.jsf.core", "Couldn't find type proxy for " + this._model.getLibraryClass()));
        }
        this._classTypeWrapper = new BeanProxyUtil.BeanProxyWrapper(this._project, libFactoryTypeProxy);
        try {
            this._classTypeWrapper.init();
        }
        catch (BeanProxyUtil.ProxyException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.jst.jsf.core", "Couldn't load class: " + this._model.getLibraryClass(), (Throwable)e));
        }
        String namespace = this.resolveNS(this._classTypeWrapper);
        System.out.println(namespace);
        if (namespace == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.jst.jsf.core", "Couldn't load uri: " + this._model.getLibraryClass()));
        }
        this._uri = namespace;
    }

    @Override
    public synchronized FaceletTaglibTag getTag(String name) {
        return this._tags.get(name);
    }

    @Override
    public synchronized Collection<? extends FaceletTaglibTag> getTags() {
        return Collections.unmodifiableCollection(this._tags.values());
    }

    @Override
    public String getURI() {
        return this._uri;
    }

    private String resolveNS(BeanProxyUtil.BeanProxyWrapper beanProxy) {
        IBeanProxy resultProxy = null;
        try {
            resultProxy = beanProxy.call(METHOD_NAME_GET_NAMESPACE);
            if (resultProxy instanceof IStringBeanProxy) {
                return ((IStringBeanProxy)resultProxy).stringValue();
            }
        }
        catch (BeanProxyUtil.ProxyException proxyException) {}
        return this.resolveNSAggressively(beanProxy);
    }

    private String resolveNSAggressively(BeanProxyUtil.BeanProxyWrapper beanProxy) {
        try {
            return beanProxy.getStringFieldValue(STATIC_MEMBER_NAMESPACE);
        }
        catch (BeanProxyUtil.ProxyException proxyException) {
            return null;
        }
    }

    @Override
    public synchronized int getNumTags() {
        return this._tags.size();
    }
}

