/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.node;

import java.io.Serializable;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.node.AsynchronousValidator;
import org.eclipse.jpt.common.utility.internal.node.SynchronousValidator;
import org.eclipse.jpt.common.utility.internal.reference.SynchronizedBoolean;
import org.eclipse.jpt.common.utility.node.Node;

public class PluggableValidator
implements Node.Validator {
    private boolean pause;
    private boolean validateOnResume;
    private final Delegate delegate;

    public static Node.Validator buildAsynchronousValidator(SynchronizedBoolean validateFlag) {
        return new PluggableValidator(new AsynchronousValidator(validateFlag));
    }

    public static Node.Validator buildSynchronousValidator(Node node) {
        return new PluggableValidator(new SynchronousValidator(node));
    }

    public PluggableValidator(Delegate delegate) {
        if (delegate == null) {
            throw new NullPointerException();
        }
        this.pause = false;
        this.validateOnResume = false;
        this.delegate = delegate;
    }

    @Override
    public synchronized void validate() {
        if (this.pause) {
            this.validateOnResume = true;
        } else {
            this.delegate.validate();
        }
    }

    @Override
    public synchronized void pause() {
        if (this.pause) {
            throw new IllegalStateException("already paused");
        }
        this.pause = true;
    }

    @Override
    public synchronized void resume() {
        if (!this.pause) {
            throw new IllegalStateException("not paused");
        }
        this.pause = false;
        if (this.validateOnResume) {
            this.validateOnResume = false;
            this.delegate.validate();
        }
    }

    public String toString() {
        return ObjectTools.toString((Object)this, this.delegate);
    }

    public static interface Delegate {
        public void validate();

        public static final class Null
        implements Delegate,
        Serializable {
            public static final Delegate INSTANCE = new Null();
            private static final long serialVersionUID = 1L;

            public static Delegate instance() {
                return INSTANCE;
            }

            private Null() {
            }

            @Override
            public void validate() {
            }

            public String toString() {
                return ObjectTools.singletonToString(this);
            }

            private Object readResolve() {
                return INSTANCE;
            }
        }
    }
}

