/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.internal.figures;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.ScaledGraphics;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.graphiti.internal.services.GraphitiInternal;
import org.eclipse.graphiti.mm.algorithms.AbstractText;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Text;
import org.eclipse.graphiti.mm.pictograms.ConnectionDecorator;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.ui.internal.config.IConfigurationProviderInternal;
import org.eclipse.graphiti.ui.internal.figures.GFFigureUtil;
import org.eclipse.graphiti.ui.internal.parts.IPictogramElementDelegate;
import org.eclipse.swt.graphics.Font;

public class GFText
extends Label
implements RotatableDecoration {
    private Text text;
    private int labelAlignment = 2;
    private String subStringText;
    private Dimension myPrefSize;
    private double rotationAngle = 0.0;
    private IConfigurationProviderInternal configurationProvider;

    public GFText(IPictogramElementDelegate pictogramElementDelegate, Text text) {
        this.text = text;
        this.configurationProvider = pictogramElementDelegate.getConfigurationProvider();
    }

    public int getLabelAlignment() {
        return this.labelAlignment;
    }

    public void paintFigure(Graphics graphics) {
        if (this.text != null && GraphitiInternal.getEmfService().isObjectAlive((EObject)this.text)) {
            double transparency = Graphiti.getGaService().getTransparency((GraphicsAlgorithm)this.text, true);
            int alpha = (int)((1.0 - transparency) * 255.0);
            graphics.setAlpha(alpha);
            if (graphics instanceof ScaledGraphics) {
                graphics.setTextAntialias(1);
            }
            if (this.rotationAngle != 0.0 && this.text.eContainer() instanceof ConnectionDecorator && !((ConnectionDecorator)this.text.eContainer()).isActive()) {
                Rectangle rect = new Rectangle();
                graphics.getClip(rect);
                graphics.pushState();
                Rectangle bounds = this.getBounds();
                graphics.translate(bounds.x, bounds.y);
                graphics.rotate((float)this.rotationAngle);
                rect = new Rectangle(0, 0, 5000, 5000);
                graphics.setClip(rect);
                if (this.text.getStyleRegions().isEmpty()) {
                    graphics.drawText(this.getSubStringText(), this.getTextLocation());
                } else {
                    GFFigureUtil.drawRichText(graphics, this.getSubStringText(), this.getTextLocation().x(), this.getTextLocation().y(), this.configurationProvider, (AbstractText)this.text);
                }
                graphics.popState();
                return;
            }
            double rotation = 0.0;
            rotation = Graphiti.getGaService().getRotation((AbstractText)this.text, true);
            if (rotation != 0.0) {
                if (this.isOpaque()) {
                    graphics.fillRectangle(this.getBounds());
                }
                Rectangle rect = new Rectangle();
                graphics.getClip(rect);
                graphics.pushState();
                Rectangle bounds = this.getBounds();
                int w = bounds.width;
                int h = bounds.height;
                bounds.height = w;
                bounds.width = h;
                graphics.translate(bounds.x, bounds.y + h);
                graphics.rotate(new Float(rotation).floatValue());
                rect = new Rectangle(0, 0, 5000, 5000);
                graphics.setClip(rect);
                if (this.text.getStyleRegions().isEmpty()) {
                    graphics.drawText(this.getSubStringText(), this.getTextLocation());
                } else {
                    GFFigureUtil.drawRichText(graphics, this.getSubStringText(), this.getTextLocation().x(), this.getTextLocation().y(), this.configurationProvider, (AbstractText)this.text);
                }
                bounds.height = h;
                bounds.width = w;
                graphics.popState();
                return;
            }
        }
        if (this.text.getStyleRegions().isEmpty()) {
            super.paintFigure(graphics);
        } else {
            if (this.isOpaque()) {
                super.paintFigure(graphics);
            }
            Rectangle bounds = this.getBounds();
            graphics.translate(bounds.x, bounds.y);
            GFFigureUtil.drawRichText(graphics, this.getSubStringText(), this.getTextLocation().x(), this.getTextLocation().y(), this.configurationProvider, (AbstractText)this.text);
            graphics.translate(-bounds.x, -bounds.y);
        }
    }

    public void setLabelAlignment(int align) {
        super.setLabelAlignment(align);
        this.labelAlignment = align;
    }

    public String getSubStringText() {
        if (this.subStringText != null) {
            return this.subStringText;
        }
        this.subStringText = this.getText();
        int widthShrink = this.getPreferredSizeWithoutChilds().width - this.getSize().width;
        if (widthShrink <= 0) {
            return this.subStringText;
        }
        Dimension effectiveSize = this.getTextSize().getExpanded(-widthShrink, 0);
        Font currentFont = this.getFont();
        int dotsWidth = this.getTextUtilities().getTextExtents((String)this.getTruncationString(), (Font)currentFont).width;
        if (effectiveSize.width < dotsWidth) {
            effectiveSize.width = dotsWidth;
        }
        int subStringLength = this.getTextUtilities().getLargestSubstringConfinedTo(this.getText(), currentFont, effectiveSize.width - dotsWidth);
        this.subStringText = new String(String.valueOf(this.getText().substring(0, subStringLength)) + this.getTruncationString());
        return this.subStringText;
    }

    protected Dimension getPreferredSizeWithoutChilds() {
        if (this.myPrefSize == null) {
            this.myPrefSize = this.calculateLabelSize(this.getTextSize());
            Insets insets = this.getInsets();
            this.myPrefSize.expand(insets.getWidth(), insets.getHeight());
        }
        return this.myPrefSize;
    }

    public void invalidate() {
        this.subStringText = null;
        this.myPrefSize = null;
        super.invalidate();
    }

    public void setReferencePoint(Point p) {
        Point tempRect = Point.SINGLETON.setLocation(p);
        tempRect.negate().translate(this.getLocation());
        this.rotationAngle = Math.toDegrees(Math.atan2(tempRect.y, tempRect.x)) - 180.0;
    }

    public GraphicsAlgorithm getGraphicsAlgorithm() {
        return this.text;
    }
}

