/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.BugException;
import freemarker.core.Environment;
import freemarker.core.MixedContent;
import freemarker.core.ParameterRole;
import freemarker.core.ParseException;
import freemarker.core.TemplateElement;
import freemarker.core.TemplatePostProcessor;
import freemarker.core.TemplatePostProcessorException;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;

class ThreadInterruptionSupportTemplatePostProcessor
extends TemplatePostProcessor {
    ThreadInterruptionSupportTemplatePostProcessor() {
    }

    public void postProcess(Template t) throws TemplatePostProcessorException {
        TemplateElement te = t.getRootTreeNode();
        this.addInterruptionChecks(te);
    }

    private void addInterruptionChecks(TemplateElement te) throws TemplatePostProcessorException {
        if (te == null) {
            return;
        }
        List nestedElements = te.nestedElements;
        TemplateElement nestedBlock = te.nestedBlock;
        if (nestedBlock != null) {
            this.addInterruptionChecks(nestedBlock);
        }
        if (nestedElements != null) {
            Iterator iter = nestedElements.iterator();
            while (iter.hasNext()) {
                this.addInterruptionChecks((TemplateElement)iter.next());
            }
        }
        if (te.isNestedBlockRepeater()) {
            if (te.nestedElements != null) {
                throw new BugException();
            }
            try {
                ThreadInterruptionCheck interruptedChk = new ThreadInterruptionCheck(te);
                if (nestedBlock == null) {
                    te.nestedBlock = interruptedChk;
                } else {
                    MixedContent nestedMixedC;
                    if (nestedBlock instanceof MixedContent) {
                        nestedMixedC = (MixedContent)nestedBlock;
                    } else {
                        nestedMixedC = new MixedContent();
                        nestedMixedC.setLocation(te.getTemplate(), 0, 0, 0, 0);
                        nestedMixedC.parent = te;
                        nestedBlock.parent = nestedMixedC;
                        nestedMixedC.addElement(nestedBlock);
                        te.nestedBlock = nestedMixedC;
                    }
                    nestedMixedC.addElement(0, interruptedChk);
                }
            }
            catch (ParseException e) {
                throw new TemplatePostProcessorException("Unexpected error; see cause", e);
            }
        }
    }

    static class TemplateProcessingThreadInterruptedException
    extends RuntimeException {
        TemplateProcessingThreadInterruptedException() {
            super("Template processing thread \"interrupted\" flag was set.");
        }
    }

    static class ThreadInterruptionCheck
    extends TemplateElement {
        private ThreadInterruptionCheck(TemplateElement te) throws ParseException {
            this.setLocation(te.getTemplate(), 0, 0, 0, 0);
            this.parent = te;
        }

        void accept(Environment env) throws TemplateException, IOException {
            if (Thread.currentThread().isInterrupted()) {
                throw new TemplateProcessingThreadInterruptedException();
            }
        }

        protected String dump(boolean canonical) {
            return canonical ? "" : "<#--" + this.getNodeTypeSymbol() + "--#>";
        }

        String getNodeTypeSymbol() {
            return "##threadInterruptionCheck";
        }

        int getParameterCount() {
            return 0;
        }

        Object getParameterValue(int idx) {
            throw new IndexOutOfBoundsException();
        }

        ParameterRole getParameterRole(int idx) {
            throw new IndexOutOfBoundsException();
        }

        boolean isNestedBlockRepeater() {
            return false;
        }
    }
}

