/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.ui.templates;

import com.google.inject.Inject;
import com.google.inject.MembersInjector;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DefaultPositionUpdater;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.util.TypeReferences;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.scoping.IScopeProvider;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.model.XtextDocumentUtil;
import org.eclipse.xtext.ui.editor.templates.XtextTemplateContext;
import org.eclipse.xtext.util.ReplaceRegion;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;
import org.eclipse.xtext.xbase.imports.RewritableImportSection;
import org.eclipse.xtext.xbase.ui.imports.ReplaceConverter;

public class XbaseTemplateContext
extends XtextTemplateContext {
    @Inject
    private TypeReferences typeReferences;
    @Inject
    private RewritableImportSection.Factory importSectionFactory;
    @Inject
    private ReplaceConverter replaceConverter;
    @Inject
    private XtextDocumentUtil xtextDocumentUtil;
    private List<String> imports = new ArrayList<String>();

    public XbaseTemplateContext(TemplateContextType type, IDocument document, Position position, ContentAssistContext contentAssistContext, IScopeProvider scopeProvider) {
        super(type, document, position, contentAssistContext, scopeProvider);
    }

    public TemplateBuffer evaluateForDisplay(Template template) throws BadLocationException, TemplateException {
        this.imports.clear();
        return super.evaluateForDisplay(template);
    }

    public TemplateBuffer evaluate(Template template) throws BadLocationException, TemplateException {
        IXtextDocument xDocument = this.xtextDocumentUtil.getXtextDocument(this.getDocument());
        this.imports.clear();
        TemplateBuffer resolvedContent = super.evaluate(template);
        Position position = new Position(this.getCompletionOffset(), 0);
        List<ReplaceRegion> rewrite = this.createImports(this.imports, xDocument);
        if (rewrite.size() > 0 && !this.isReadOnly()) {
            String category = "__template_position_import_section" + System.currentTimeMillis();
            DefaultPositionUpdater updater = new DefaultPositionUpdater(category);
            xDocument.addPositionCategory(category);
            xDocument.addPositionUpdater((IPositionUpdater)updater);
            xDocument.addPosition(position);
            try {
                try {
                    this.replaceConverter.convertToTextEdit(rewrite).apply((IDocument)xDocument);
                    this.setCompletionOffset(position.getOffset());
                }
                catch (BadLocationException e) {
                    throw new TemplateException((Throwable)e);
                }
            }
            finally {
                xDocument.removePosition(position);
                xDocument.removePositionUpdater((IPositionUpdater)updater);
                try {
                    xDocument.removePositionCategory(category);
                }
                catch (BadPositionCategoryException e) {
                    throw new TemplateException((Throwable)e);
                }
            }
        }
        return resolvedContent;
    }

    private List<ReplaceRegion> createImports(final List<String> types, IXtextDocument document) {
        return (List)document.priorityReadOnly((IUnitOfWork)new IUnitOfWork<List<ReplaceRegion>, XtextResource>(){

            public List<ReplaceRegion> exec(XtextResource state) throws Exception {
                RewritableImportSection impSection = XbaseTemplateContext.this.importSectionFactory.parse(state);
                for (String fqName : types) {
                    JvmDeclaredType jvmType = XbaseTemplateContext.this.findJvmDeclaredType(fqName, state.getResourceSet());
                    if (jvmType == null) continue;
                    impSection.addImport(jvmType);
                }
                return impSection.rewrite();
            }
        });
    }

    private boolean checkImports(final List<String> types, IXtextDocument document) {
        return (Boolean)document.priorityReadOnly((IUnitOfWork)new IUnitOfWork<Boolean, XtextResource>(){

            public Boolean exec(XtextResource state) throws Exception {
                for (String fqName : types) {
                    JvmDeclaredType jvmType = XbaseTemplateContext.this.findJvmDeclaredType(fqName, state.getResourceSet());
                    if (jvmType != null) continue;
                    return false;
                }
                return true;
            }
        });
    }

    private JvmDeclaredType findJvmDeclaredType(String fqName, ResourceSet resourceSet) {
        JvmType typeByName = this.typeReferences.findDeclaredType(fqName, (Notifier)resourceSet);
        if (typeByName instanceof JvmDeclaredType) {
            return (JvmDeclaredType)typeByName;
        }
        return null;
    }

    public boolean canEvaluate(Template template) {
        boolean canEvaluate = super.canEvaluate(template);
        if (canEvaluate && !this.imports.isEmpty()) {
            IXtextDocument xDocument = this.xtextDocumentUtil.getXtextDocument(this.getDocument());
            return this.checkImports(this.imports, xDocument);
        }
        return canEvaluate;
    }

    public void addImport(String typeName) {
        if (!this.imports.contains(typeName)) {
            this.imports.add(typeName);
        }
    }

    static class Factory {
        @Inject
        private MembersInjector<XbaseTemplateContext> injector;

        Factory() {
        }

        public XbaseTemplateContext create(TemplateContextType type, IDocument document, Position position, ContentAssistContext contentAssistContext, IScopeProvider scopeProvider) {
            XbaseTemplateContext result = new XbaseTemplateContext(type, document, position, contentAssistContext, scopeProvider);
            this.injector.injectMembers((Object)result);
            return result;
        }
    }
}

