/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.refactor.wizard;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.wst.xsd.ui.internal.refactor.actions.RenameAction;
import org.eclipse.wst.xsd.ui.internal.refactor.actions.SelectionDispatchAction;
import org.eclipse.wst.xsd.ui.internal.refactor.wizard.RefactoringWizardMessages;

public abstract class RefactorActionGroup
extends ActionGroup {
    public static final String GROUP_REORGANIZE = "group.reorganize";
    public static final String MENU_ID = "org.eclipse.wst.xsd.ui.refactoring.menu";
    public static final String RENAME = "org.eclipse.wst.xsd.ui.refactoring.actions.Rename";
    protected List fEditorActions;
    private String fGroupName = "group.reorganize";
    private Action fNoActionAvailable = new NoActionAvailable();
    protected RenameAction fRenameAction;
    protected SelectionDispatchAction fRenameTargetNamespace;
    protected ISelection selection;

    protected static void initAction(SelectionDispatchAction action, ISelection selection) {
        Assert.isNotNull((Object)selection);
        Assert.isNotNull((Object)((Object)action));
        action.update(selection);
    }

    public RefactorActionGroup(ISelection selection) {
        this.selection = selection;
    }

    public int addAction(IAction action) {
        if (action != null && action.isEnabled()) {
            this.fEditorActions.add(action);
            return 1;
        }
        return 0;
    }

    private void addRefactorSubmenu(IMenuManager menu) {
        MenuManager refactorSubmenu = new MenuManager(RefactoringWizardMessages.RefactorMenu_label, MENU_ID);
        refactorSubmenu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                RefactorActionGroup.this.refactorMenuShown(manager);
            }
        });
        refactorSubmenu.add((IAction)this.fNoActionAvailable);
        if (menu.find(refactorSubmenu.getId()) == null) {
            if (menu.find(this.fGroupName) == null) {
                menu.add((IContributionItem)refactorSubmenu);
            } else {
                menu.appendToGroup(this.fGroupName, (IContributionItem)refactorSubmenu);
            }
        }
    }

    protected void disposeAction(ISelectionChangedListener action, ISelectionProvider provider) {
        if (action != null) {
            provider.removeSelectionChangedListener(action);
        }
    }

    public void fillActionBars(IActionBars actionBars) {
        super.fillActionBars(actionBars);
        actionBars.setGlobalActionHandler(RENAME, (IAction)this.fRenameAction);
        this.retargetFileMenuActions(actionBars);
    }

    public void fillActions(List enabledActions) {
        if (this.selection != null && this.fEditorActions != null) {
            Action action;
            Iterator iter = this.fEditorActions.iterator();
            while (iter.hasNext()) {
                action = (Action)iter.next();
                if (!(action instanceof SelectionDispatchAction)) continue;
                SelectionDispatchAction selectionAction = (SelectionDispatchAction)action;
                selectionAction.update(this.selection);
            }
            iter = this.fEditorActions.iterator();
            while (iter.hasNext()) {
                action = (Action)iter.next();
                if (action == null) continue;
                enabledActions.add(action);
            }
        }
    }

    public void fillContextMenu(IMenuManager menu) {
        super.fillContextMenu(menu);
        this.addRefactorSubmenu(menu);
    }

    private int fillRefactorMenu(IMenuManager refactorSubmenu) {
        int added = 0;
        refactorSubmenu.add((IContributionItem)new Separator(GROUP_REORGANIZE));
        Iterator iter = this.fEditorActions.iterator();
        while (iter.hasNext()) {
            Action action = (Action)iter.next();
            if (action == null || !action.isEnabled()) continue;
            this.fEditorActions.add(action);
            return 1;
        }
        return added;
    }

    private void refactorMenuHidden(IMenuManager manager) {
        Iterator iter = this.fEditorActions.iterator();
        while (iter.hasNext()) {
            Action action = (Action)iter.next();
            if (!(action instanceof SelectionDispatchAction)) continue;
            SelectionDispatchAction selectionAction = (SelectionDispatchAction)action;
            selectionAction.update(this.selection);
        }
    }

    private void refactorMenuShown(final IMenuManager refactorSubmenu) {
        Menu menu = ((MenuManager)refactorSubmenu).getMenu();
        menu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuHidden(MenuEvent e) {
                RefactorActionGroup.this.refactorMenuHidden(refactorSubmenu);
            }
        });
        Iterator iter = this.fEditorActions.iterator();
        while (iter.hasNext()) {
            Action action = (Action)iter.next();
            if (!(action instanceof SelectionDispatchAction)) continue;
            SelectionDispatchAction selectionAction = (SelectionDispatchAction)action;
            selectionAction.update(this.selection);
        }
        refactorSubmenu.removeAll();
        if (this.fillRefactorMenu(refactorSubmenu) == 0) {
            refactorSubmenu.add((IAction)this.fNoActionAvailable);
        }
    }

    public void retargetFileMenuActions(IActionBars actionBars) {
        actionBars.setGlobalActionHandler(ActionFactory.RENAME.getId(), (IAction)this.fRenameAction);
    }

    private static class NoActionAvailable
    extends Action {
        public NoActionAvailable() {
            this.setEnabled(true);
            this.setText(RefactoringWizardMessages.RefactorActionGroup_no_refactoring_available);
        }
    }
}

