/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.rename;

import java.net.URI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.ltk.core.refactoring.participants.RenameArguments;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.refactoring.descriptors.JavaScriptRefactoringDescriptor;
import org.eclipse.wst.jsdt.core.refactoring.descriptors.RenameJavaScriptElementDescriptor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JDTRefactoringDescriptor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JDTRefactoringDescriptorComment;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JavaRefactoringArguments;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.DynamicValidationRefactoringChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.RenameJavaProjectChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.ScriptableRefactoring;
import org.eclipse.wst.jsdt.internal.corext.refactoring.participants.JavaProcessors;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.JavaRenameProcessor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.RenameModifications;
import org.eclipse.wst.jsdt.internal.corext.refactoring.tagging.IReferenceUpdating;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.corext.util.Resources;

public final class RenameJavaProjectProcessor
extends JavaRenameProcessor
implements IReferenceUpdating {
    private IJavaScriptProject fProject;
    private boolean fUpdateReferences;
    public static final String IDENTIFIER = "org.eclipse.wst.jsdt.ui.renameJavaProjectProcessor";

    public RenameJavaProjectProcessor(IJavaScriptProject project) {
        this.fProject = project;
        if (this.fProject != null) {
            this.setNewElementName(this.fProject.getElementName());
        }
        this.fUpdateReferences = true;
    }

    public String getIdentifier() {
        return IDENTIFIER;
    }

    public boolean isApplicable() throws CoreException {
        return RefactoringAvailabilityTester.isRenameAvailable(this.fProject);
    }

    public String getProcessorName() {
        return RefactoringCoreMessages.RenameJavaProjectRefactoring_rename;
    }

    @Override
    protected String[] getAffectedProjectNatures() throws CoreException {
        return JavaProcessors.computeAffectedNatures((IJavaScriptElement)this.fProject);
    }

    @Override
    public Object[] getElements() {
        return new Object[]{this.fProject};
    }

    @Override
    public Object getNewElement() throws CoreException {
        IPath newPath = this.fProject.getPath().removeLastSegments(1).append(this.getNewElementName());
        return JavaScriptCore.create((IResource)ResourcesPlugin.getWorkspace().getRoot().findMember(newPath));
    }

    @Override
    protected RenameModifications computeRenameModifications() throws CoreException {
        RenameModifications result = new RenameModifications();
        result.rename(this.fProject, new RenameArguments(this.getNewElementName(), this.getUpdateReferences()));
        return result;
    }

    @Override
    protected IFile[] getChangedFiles() throws CoreException {
        IFile projectFile = this.fProject.getProject().getFile(".project");
        if (projectFile != null && projectFile.exists()) {
            return new IFile[]{projectFile};
        }
        return new IFile[0];
    }

    @Override
    public int getSaveMode() {
        return 2;
    }

    @Override
    public boolean canEnableUpdateReferences() {
        return true;
    }

    @Override
    public void setUpdateReferences(boolean update) {
        this.fUpdateReferences = update;
    }

    @Override
    public boolean getUpdateReferences() {
        return this.fUpdateReferences;
    }

    @Override
    public String getCurrentElementName() {
        return this.fProject.getElementName();
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException {
        return new RefactoringStatus();
    }

    @Override
    public RefactoringStatus checkNewElementName(String newName) throws CoreException {
        Assert.isNotNull((Object)newName, (String)"new name");
        RefactoringStatus result = RefactoringStatus.create((IStatus)ResourcesPlugin.getWorkspace().validateName(newName, 4));
        if (result.hasFatalError()) {
            return result;
        }
        if (this.projectNameAlreadyExists(newName)) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.RenameJavaProjectRefactoring_already_exists);
        }
        if (this.projectFolderAlreadyExists(newName)) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.RenameJavaProjectProcessor_folder_already_exists);
        }
        return new RefactoringStatus();
    }

    @Override
    protected RefactoringStatus doCheckFinalConditions(IProgressMonitor pm, CheckConditionsContext context) throws CoreException {
        pm.beginTask("", 1);
        try {
            if (this.isReadOnly()) {
                String message = Messages.format(RefactoringCoreMessages.RenameJavaProjectRefactoring_read_only, this.fProject.getElementName());
                RefactoringStatus refactoringStatus = RefactoringStatus.createErrorStatus((String)message);
                return refactoringStatus;
            }
            RefactoringStatus refactoringStatus = new RefactoringStatus();
            return refactoringStatus;
        }
        finally {
            pm.done();
        }
    }

    private boolean isReadOnly() {
        return Resources.isReadOnly(this.fProject.getResource());
    }

    private boolean projectNameAlreadyExists(String newName) {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(newName).exists();
    }

    private boolean projectFolderAlreadyExists(String newName) throws CoreException {
        boolean isNotInWorkpace;
        boolean bl = isNotInWorkpace = this.fProject.getProject().getDescription().getLocationURI() != null;
        if (isNotInWorkpace) {
            return false;
        }
        URI locationURI = this.fProject.getProject().getLocationURI();
        IFileStore projectStore = EFS.getStore((URI)locationURI);
        IFileStore newProjectStore = projectStore.getParent().getChild(newName);
        return newProjectStore.fetchInfo().exists();
    }

    public Change createChange(IProgressMonitor monitor) throws CoreException {
        try {
            monitor.beginTask("", 1);
            String description = Messages.format(RefactoringCoreMessages.RenameJavaProjectProcessor_descriptor_description_short, this.fProject.getElementName());
            String header = Messages.format(RefactoringCoreMessages.RenameJavaProjectChange_descriptor_description, new String[]{this.fProject.getElementName(), this.getNewElementName()});
            String comment = new JDTRefactoringDescriptorComment(null, this, header).asString();
            RenameJavaScriptElementDescriptor descriptor = new RenameJavaScriptElementDescriptor("org.eclipse.wst.jsdt.ui.rename.java.project");
            descriptor.setProject(null);
            descriptor.setDescription(description);
            descriptor.setComment(comment);
            descriptor.setFlags(7);
            descriptor.setJavaElement((IJavaScriptElement)this.fProject);
            descriptor.setNewName(this.getNewElementName());
            descriptor.setUpdateReferences(this.fUpdateReferences);
            DynamicValidationRefactoringChange dynamicValidationRefactoringChange = new DynamicValidationRefactoringChange((JavaScriptRefactoringDescriptor)descriptor, RefactoringCoreMessages.RenameJavaProjectRefactoring_rename, new Change[]{new RenameJavaProjectChange(this.fProject, this.getNewElementName(), this.fUpdateReferences)});
            return dynamicValidationRefactoringChange;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public RefactoringStatus initialize(RefactoringArguments arguments) {
        String references;
        if (arguments instanceof JavaRefactoringArguments) {
            IJavaScriptElement element;
            JavaRefactoringArguments extended = (JavaRefactoringArguments)arguments;
            String handle = extended.getAttribute("input");
            if (handle != null) {
                element = JDTRefactoringDescriptor.handleToElement(extended.getProject(), handle, false);
                if (element == null || !element.exists() || element.getElementType() != 2) {
                    return ScriptableRefactoring.createInputFatalStatus(element, this.getRefactoring().getName(), "org.eclipse.wst.jsdt.ui.rename.java.project");
                }
            } else {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "input"));
            }
            this.fProject = (IJavaScriptProject)element;
            String name = extended.getAttribute("name");
            if (name == null || "".equals(name)) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "name"));
            }
            this.setNewElementName(name);
            references = extended.getAttribute("references");
            if (references == null) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "references"));
            }
        } else {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InitializableRefactoring_inacceptable_arguments);
        }
        this.fUpdateReferences = Boolean.valueOf(references);
        return new RefactoringStatus();
    }
}

