/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.internal.protocolparser.dynamicimpl;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.wst.jsdt.chromium.internal.protocolparser.JsonProtocolModelParseException;
import org.eclipse.wst.jsdt.chromium.internal.protocolparser.JsonProtocolParseException;
import org.eclipse.wst.jsdt.chromium.internal.protocolparser.JsonType;
import org.eclipse.wst.jsdt.chromium.internal.protocolparser.dynamicimpl.BaseHandlersLibrary;
import org.eclipse.wst.jsdt.chromium.internal.protocolparser.dynamicimpl.DynamicParserImpl;
import org.eclipse.wst.jsdt.chromium.internal.protocolparser.dynamicimpl.FieldCondition;
import org.eclipse.wst.jsdt.chromium.internal.protocolparser.dynamicimpl.FieldLoader;
import org.eclipse.wst.jsdt.chromium.internal.protocolparser.dynamicimpl.JavaCodeGenerator;
import org.eclipse.wst.jsdt.chromium.internal.protocolparser.dynamicimpl.JsonInvocationHandler;
import org.eclipse.wst.jsdt.chromium.internal.protocolparser.dynamicimpl.MethodHandler;
import org.eclipse.wst.jsdt.chromium.internal.protocolparser.dynamicimpl.ObjectData;
import org.eclipse.wst.jsdt.chromium.internal.protocolparser.dynamicimpl.RefToType;
import org.eclipse.wst.jsdt.chromium.internal.protocolparser.dynamicimpl.SubtypeCaster;
import org.json.simple.JSONObject;

class TypeHandler<T> {
    private final Class<T> typeClass;
    private Constructor<? extends T> proxyClassConstructor = null;
    private final int fieldArraySize;
    private final List<DynamicParserImpl.VolatileFieldBinding> volatileFields;
    private final Map<Method, MethodHandler> methodHandlerMap;
    private final List<FieldLoader> fieldLoaders;
    private final EagerFieldParser eagerFieldParser;
    private final AlgebraicCasesData algCasesData;
    private Set<String> closedNameSet = null;
    private final SubtypeAspect subtypeAspect;
    private final boolean requiresJsonObject;
    private final boolean checkLazyParsedFields;

    TypeHandler(Class<T> typeClass, RefToType<?> jsonSuperClass, int fieldArraySize, List<DynamicParserImpl.VolatileFieldBinding> volatileFields, Map<Method, MethodHandler> methodHandlerMap, List<FieldLoader> fieldLoaders, List<FieldCondition> fieldConditions, EagerFieldParser eagerFieldParser, AlgebraicCasesData algCasesData, boolean requiresJsonObject, boolean checkLazyParsedFields) {
        this.typeClass = typeClass;
        this.fieldArraySize = fieldArraySize;
        this.volatileFields = volatileFields;
        this.methodHandlerMap = methodHandlerMap;
        this.fieldLoaders = fieldLoaders;
        this.eagerFieldParser = eagerFieldParser;
        this.algCasesData = algCasesData;
        this.requiresJsonObject = requiresJsonObject;
        this.checkLazyParsedFields = checkLazyParsedFields;
        if (jsonSuperClass == null) {
            if (!fieldConditions.isEmpty()) {
                throw new IllegalArgumentException();
            }
            this.subtypeAspect = new AbsentSubtypeAspect();
        } else {
            this.subtypeAspect = new ExistingSubtypeAspect(jsonSuperClass, fieldConditions);
        }
    }

    public Class<T> getTypeClass() {
        return this.typeClass;
    }

    public ObjectData parse(Object input, ObjectData superObjectData) throws JsonProtocolParseException {
        try {
            this.subtypeAspect.checkSuperObject(superObjectData);
            JSONObject jsonProperties = null;
            if (input instanceof JSONObject) {
                jsonProperties = (JSONObject)input;
            }
            ObjectData objectData = new ObjectData(this, input, this.fieldArraySize, this.volatileFields.size(), superObjectData);
            if (this.requiresJsonObject && jsonProperties == null) {
                throw new JsonProtocolParseException("JSON object input expected");
            }
            for (FieldLoader fieldLoader : this.fieldLoaders) {
                String fieldName = fieldLoader.getFieldName();
                Object value = jsonProperties.get(fieldName);
                boolean hasValue = value == null ? jsonProperties.containsKey(fieldName) : true;
                fieldLoader.parse(hasValue, value, objectData);
            }
            if (this.closedNameSet != null) {
                for (FieldLoader fieldNameObject : jsonProperties.keySet()) {
                    if (this.closedNameSet.contains(fieldNameObject)) continue;
                    throw new JsonProtocolParseException("Unexpected field " + fieldNameObject);
                }
            }
            this.parseObjectSubtype(objectData, (Map<?, ?>)jsonProperties, input);
            if (this.checkLazyParsedFields) {
                this.eagerFieldParser.parseAllFields(objectData);
            }
            this.wrapInProxy(objectData, this.methodHandlerMap);
            return objectData;
        }
        catch (JsonProtocolParseException e) {
            throw new JsonProtocolParseException("Failed to parse type " + this.getTypeClass().getName(), e);
        }
    }

    public T parseRoot(Object input) throws JsonProtocolParseException {
        ObjectData baseData = this.parseRootImpl(input);
        return this.typeClass.cast(baseData.getProxy());
    }

    public ObjectData parseRootImpl(Object input) throws JsonProtocolParseException {
        return this.subtypeAspect.parseFromSuper(input);
    }

    SubtypeSupport getSubtypeSupport() {
        return this.subtypeAspect;
    }

    <S> TypeHandler<S> cast(Class<S> typeClass) {
        if (this.typeClass != typeClass) {
            throw new RuntimeException();
        }
        return this;
    }

    void buildClosedNameSet() {
        if (!this.subtypeAspect.isRoot()) {
            return;
        }
        ArrayList<Set<String>> namesChain = new ArrayList<Set<String>>(3);
        this.buildClosedNameSetRecursive(namesChain);
    }

    private void buildClosedNameSetRecursive(List<Set<String>> namesChain) {
        HashSet<String> thisSet = new HashSet<String>();
        this.eagerFieldParser.addAllFieldNames(thisSet);
        for (FieldLoader fieldLoader : this.fieldLoaders) {
            thisSet.add(fieldLoader.getFieldName());
        }
        if (this.algCasesData == null) {
            JsonType jsonType = this.typeClass.getAnnotation(JsonType.class);
            if (jsonType.allowsOtherProperties()) {
                return;
            }
            for (Set<String> set : namesChain) {
                thisSet.addAll(set);
            }
            this.closedNameSet = thisSet;
        } else {
            namesChain.add(thisSet);
            for (RefToType refToType : this.algCasesData.getSubtypes()) {
                super.buildClosedNameSetRecursive(namesChain);
            }
            namesChain.remove(namesChain.size() - 1);
        }
    }

    String getShortName() {
        String name = this.typeClass.getName();
        int dotPos = name.lastIndexOf(46);
        if (dotPos != -1) {
            name = name.substring(dotPos + 1);
        }
        return "[" + name + "]";
    }

    private void parseObjectSubtype(ObjectData objectData, Map<?, ?> jsonProperties, Object input) throws JsonProtocolParseException {
        if (this.algCasesData == null) {
            return;
        }
        this.algCasesData.parseObjectSubtype(objectData, jsonProperties, input);
    }

    private void wrapInProxy(ObjectData data, Map<Method, MethodHandler> methodHandlerMap) {
        JsonInvocationHandler handler = new JsonInvocationHandler(data, methodHandlerMap);
        T proxy = this.createProxy(handler);
        data.initProxy(proxy);
    }

    private T createProxy(InvocationHandler invocationHandler) {
        if (this.proxyClassConstructor == null) {
            Constructor<?> c;
            Class[] interfaces = new Class[]{this.typeClass};
            Class<?> proxyClass = Proxy.getProxyClass(this.typeClass.getClassLoader(), interfaces);
            try {
                c = proxyClass.getConstructor(InvocationHandler.class);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
            this.proxyClassConstructor = c;
        }
        try {
            return this.proxyClassConstructor.newInstance(invocationHandler);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public void writeStaticClassJava(JavaCodeGenerator.FileScope fileScope) {
        fileScope.startLine("// Type " + this.getTypeClass().getName() + "\n");
        String valueImplClassName = fileScope.getTypeImplShortName(this);
        String typeClassName = this.getTypeClass().getCanonicalName();
        fileScope.startLine("public static class " + valueImplClassName + " extends " + "org.eclipse.wst.jsdt.chromium.internal.protocolparser" + ".implutil.GeneratedCodeLibrary.");
        if (this.requiresJsonObject) {
            fileScope.append("JsonValueBase");
        } else {
            fileScope.append("ObjectValueBase");
        }
        fileScope.append(" implements " + typeClassName + " {\n");
        JavaCodeGenerator.ClassScope classScope = fileScope.newClassScope();
        classScope.indentRight();
        classScope.startLine("public static " + valueImplClassName + " parse(Object input)" + " throws org.eclipse.wst.jsdt.chromium.internal.protocolparser.JsonProtocolParseException" + " {\n");
        classScope.indentRight();
        this.subtypeAspect.writeParseMethodJava(classScope, valueImplClassName, "input");
        classScope.indentLeft();
        classScope.startLine("}");
        classScope.append("\n");
        classScope.startLine(String.valueOf(valueImplClassName) + "(Object input");
        this.subtypeAspect.writeSuperConstructorParamJava(classScope);
        classScope.append(") throws org.eclipse.wst.jsdt.chromium.internal.protocolparser.JsonProtocolParseException {\n");
        JavaCodeGenerator.MethodScope methodScope = classScope.newMethodScope();
        methodScope.indentRight();
        methodScope.startLine("super(input);\n");
        this.subtypeAspect.writeSuperConstructorInitializationJava(methodScope);
        for (FieldLoader fieldLoader : this.fieldLoaders) {
            String valueRef = methodScope.newMethodScopedName("value");
            String hasValueRef = methodScope.newMethodScopedName("hasValue");
            String fieldName = fieldLoader.getFieldName();
            methodScope.append("\n");
            JavaCodeGenerator.Util.writeReadValueAndHasValue(methodScope, fieldName, "underlying", valueRef, hasValueRef);
            fieldLoader.writeFieldLoadJava(methodScope, valueRef, hasValueRef);
        }
        if (this.algCasesData != null) {
            this.algCasesData.writeConstructorCodeJava(methodScope);
        }
        methodScope.indentLeft();
        classScope.startLine("}\n");
        for (DynamicParserImpl.VolatileFieldBinding volatileFieldBinding : this.volatileFields) {
            volatileFieldBinding.writeFieldDeclarationJava(classScope);
        }
        for (FieldLoader fieldLoader : this.fieldLoaders) {
            fieldLoader.writeFieldDeclarationJava(classScope);
        }
        if (this.algCasesData != null) {
            this.algCasesData.writeFiledsJava(classScope);
        }
        this.subtypeAspect.writeSuperFieldJava(classScope);
        for (Map.Entry entry : this.methodHandlerMap.entrySet()) {
            Method m = (Method)entry.getKey();
            MethodHandler methodHandler = (MethodHandler)entry.getValue();
            methodHandler.writeMethodImplementationJava(classScope, m);
        }
        BaseHandlersLibrary.writeBaseMethodsJava(classScope, this);
        this.subtypeAspect.writeHelperMethodsJava(classScope);
        classScope.indentLeft();
        classScope.startLine("}\n");
        fileScope.append("\n");
    }

    public void writeMapFillJava(JavaCodeGenerator.ClassScope scope, String mapReference) {
        scope.startLine("// Type " + this.getTypeClass().getName() + "\n");
        scope.startLine(String.valueOf(mapReference) + ".put(" + this.getTypeClass().getCanonicalName() + ".class, new " + "org.eclipse.wst.jsdt.chromium.internal.protocolparser" + ".implutil.GeneratedCodeLibrary.AbstractType() {\n");
        scope.startLine("  @Override public Object parseJson(org.json.simple.JSONObject json) throws org.eclipse.wst.jsdt.chromium.internal.protocolparser.JsonProtocolParseException {\n");
        scope.startLine("    return " + scope.getTypeImplShortName(this) + ".parse(json);\n");
        scope.startLine("  }\n");
        scope.startLine("  @Override public Object parseAnything(Object object) throws org.eclipse.wst.jsdt.chromium.internal.protocolparser.JsonProtocolParseException {\n");
        scope.startLine("    return " + scope.getTypeImplShortName(this) + ".parse(object);\n");
        scope.startLine("  }\n");
        scope.startLine("});\n");
    }

    private class AbsentSubtypeAspect
    extends SubtypeAspect {
        private AbsentSubtypeAspect() {
        }

        @Override
        void checkSuperObject(ObjectData superObjectData) throws JsonProtocolParseException {
            if (superObjectData != null) {
                throw new JsonProtocolParseException("super object is not expected");
            }
        }

        @Override
        boolean checkConditions(Map<?, ?> jsonProperties) throws JsonProtocolParseException {
            throw new JsonProtocolParseException("Not a subtype: " + TypeHandler.this.typeClass.getName());
        }

        @Override
        ObjectData parseFromSuper(Object input) throws JsonProtocolParseException {
            return TypeHandler.this.parse(input, null);
        }

        @Override
        void checkHasSubtypeCaster() {
        }

        @Override
        void setSubtypeCaster(SubtypeCaster subtypeCaster) throws JsonProtocolModelParseException {
            throw new JsonProtocolModelParseException("Not a subtype: " + TypeHandler.this.typeClass.getName());
        }

        @Override
        boolean isRoot() {
            return true;
        }

        @Override
        void writeGetSuperMethodJava(JavaCodeGenerator.ClassScope scope) {
        }

        @Override
        void writeSuperFieldJava(JavaCodeGenerator.ClassScope scope) {
        }

        @Override
        void writeSuperConstructorParamJava(JavaCodeGenerator.ClassScope scope) {
        }

        @Override
        void writeSuperConstructorInitializationJava(JavaCodeGenerator.MethodScope scope) {
        }

        @Override
        void writeHelperMethodsJava(JavaCodeGenerator.ClassScope classScope) {
        }

        @Override
        void writeParseMethodJava(JavaCodeGenerator.ClassScope scope, String valueTypeName, String inputRef) {
            scope.startLine("return new " + valueTypeName + "(" + inputRef + ");\n");
        }
    }

    static abstract class AlgebraicCasesData {
        AlgebraicCasesData() {
        }

        abstract void parseObjectSubtype(ObjectData var1, Map<?, ?> var2, Object var3) throws JsonProtocolParseException;

        abstract List<RefToType<?>> getSubtypes();

        abstract void writeConstructorCodeJava(JavaCodeGenerator.MethodScope var1);

        abstract void writeFiledsJava(JavaCodeGenerator.ClassScope var1);
    }

    static abstract class EagerFieldParser {
        EagerFieldParser() {
        }

        abstract void parseAllFields(ObjectData var1) throws JsonProtocolParseException;

        abstract void addAllFieldNames(Set<? super String> var1);
    }

    private class ExistingSubtypeAspect
    extends SubtypeAspect {
        private final RefToType<?> jsonSuperClass;
        private final List<FieldCondition> fieldConditions;
        private SubtypeCaster subtypeCaster;

        private ExistingSubtypeAspect(RefToType<?> jsonSuperClass, List<FieldCondition> fieldConditions) {
            this.subtypeCaster = null;
            this.jsonSuperClass = jsonSuperClass;
            this.fieldConditions = fieldConditions;
        }

        @Override
        boolean checkConditions(Map<?, ?> map) throws JsonProtocolParseException {
            Iterator<FieldCondition> iterator = this.fieldConditions.iterator();
            while (iterator.hasNext()) {
                FieldCondition condition;
                String name = (condition = iterator.next()).getPropertyName();
                Object value = map.get(name);
                boolean hasValue = value == null ? map.containsKey(name) : true;
                boolean conditionRes = condition.checkValue(hasValue, value);
                if (conditionRes) continue;
                return false;
            }
            return true;
        }

        @Override
        void checkSuperObject(ObjectData superObjectData) throws JsonProtocolParseException {
            if (this.jsonSuperClass == null) {
                return;
            }
            if (!this.jsonSuperClass.getTypeClass().isAssignableFrom(superObjectData.getTypeHandler().getTypeClass())) {
                throw new JsonProtocolParseException("Unexpected type of super object");
            }
        }

        @Override
        ObjectData parseFromSuper(Object input) throws JsonProtocolParseException {
            ObjectData base = this.jsonSuperClass.get().parseRootImpl(input);
            ObjectData subtypeObject = this.subtypeCaster.getSubtypeObjectData(base);
            if (subtypeObject == null) {
                throw new JsonProtocolParseException("Failed to get subtype object while parsing");
            }
            return subtypeObject;
        }

        @Override
        void checkHasSubtypeCaster() throws JsonProtocolModelParseException {
            if (this.subtypeCaster == null) {
                throw new JsonProtocolModelParseException("Subtype caster should have been set in " + TypeHandler.this.typeClass.getName());
            }
        }

        @Override
        void setSubtypeCaster(SubtypeCaster subtypeCaster) throws JsonProtocolModelParseException {
            if (this.jsonSuperClass == null) {
                throw new JsonProtocolModelParseException(String.valueOf(TypeHandler.this.typeClass.getName()) + " does not have supertype declared" + " (accessed from " + subtypeCaster.getBaseType().getName() + ")");
            }
            if (subtypeCaster.getBaseType() != this.jsonSuperClass.getTypeClass()) {
                throw new JsonProtocolModelParseException("Wrong base type in " + TypeHandler.this.typeClass.getName() + ", expected " + subtypeCaster.getBaseType().getName());
            }
            if (subtypeCaster.getSubtype() != TypeHandler.this.typeClass) {
                throw new JsonProtocolModelParseException("Wrong subtype");
            }
            if (this.subtypeCaster != null) {
                throw new JsonProtocolModelParseException("Subtype caster is already set");
            }
            this.subtypeCaster = subtypeCaster;
        }

        @Override
        boolean isRoot() {
            return false;
        }

        @Override
        void writeGetSuperMethodJava(JavaCodeGenerator.ClassScope scope) {
            scope.startLine("@Override public " + this.jsonSuperClass.get().getTypeClass().getCanonicalName() + " getSuper() {\n");
            scope.startLine("  return superTypeValue;\n");
            scope.startLine("}\n");
        }

        @Override
        void writeSuperFieldJava(JavaCodeGenerator.ClassScope scope) {
            scope.startLine("private final " + this.jsonSuperClass.get().getTypeClass().getCanonicalName() + " superTypeValue;\n");
        }

        @Override
        void writeSuperConstructorParamJava(JavaCodeGenerator.ClassScope scope) {
            scope.append(", " + this.jsonSuperClass.get().getTypeClass().getCanonicalName() + " superValueParam");
        }

        @Override
        void writeSuperConstructorInitializationJava(JavaCodeGenerator.MethodScope scope) {
            scope.startLine("this.superTypeValue = superValueParam;\n");
        }

        @Override
        void writeHelperMethodsJava(JavaCodeGenerator.ClassScope classScope) {
            classScope.startLine("public static boolean checkSubtypeConditions(org.json.simple.JSONObject input) throws org.eclipse.wst.jsdt.chromium.internal.protocolparser.JsonProtocolParseException {\n");
            JavaCodeGenerator.MethodScope methodScope = classScope.newMethodScope();
            methodScope.indentRight();
            for (FieldCondition condition : this.fieldConditions) {
                String name = condition.getPropertyName();
                methodScope.startLine("{\n");
                methodScope.startLine("  Object value = input.get(\"" + name + "\");\n");
                methodScope.startLine("  boolean hasValue;\n");
                methodScope.startLine("  if (value == null) {\n");
                methodScope.startLine("    hasValue = input.containsKey(\"" + name + "\");\n");
                methodScope.startLine("  } else {\n");
                methodScope.startLine("    hasValue = true;\n");
                methodScope.startLine("  }\n");
                condition.writeCheckJava(methodScope, "value", "hasValue", "conditionRes");
                methodScope.startLine("  if (!conditionRes) {\n");
                methodScope.startLine("    return false;\n");
                methodScope.startLine("  }\n");
                methodScope.startLine("}\n");
            }
            methodScope.startLine("return true;\n");
            methodScope.indentLeft();
            methodScope.startLine("}\n");
        }

        @Override
        void writeParseMethodJava(JavaCodeGenerator.ClassScope scope, String valueTypeName, String inputRef) {
            String superTypeName = scope.getTypeImplReference(this.jsonSuperClass.get());
            scope.startLine(String.valueOf(superTypeName) + " superTypeValue = " + superTypeName + ".parse(" + inputRef + ");\n");
            this.subtypeCaster.writeJava(scope, valueTypeName, "superTypeValue", "result");
            scope.startLine("if (result == null) {\n");
            scope.startLine("  throw new org.eclipse.wst.jsdt.chromium.internal.protocolparser.JsonProtocolParseException(\"Failed to get subtype object while parsing\");\n");
            scope.startLine("}\n");
            scope.startLine("return result;\n");
        }
    }

    private static abstract class SubtypeAspect
    extends SubtypeSupport {
        private SubtypeAspect() {
        }

        abstract void checkSuperObject(ObjectData var1) throws JsonProtocolParseException;

        abstract ObjectData parseFromSuper(Object var1) throws JsonProtocolParseException;

        abstract boolean isRoot();

        abstract void writeSuperFieldJava(JavaCodeGenerator.ClassScope var1);

        abstract void writeSuperConstructorParamJava(JavaCodeGenerator.ClassScope var1);

        abstract void writeSuperConstructorInitializationJava(JavaCodeGenerator.MethodScope var1);

        abstract void writeHelperMethodsJava(JavaCodeGenerator.ClassScope var1);

        abstract void writeParseMethodJava(JavaCodeGenerator.ClassScope var1, String var2, String var3);
    }

    static abstract class SubtypeSupport {
        SubtypeSupport() {
        }

        abstract void setSubtypeCaster(SubtypeCaster var1) throws JsonProtocolModelParseException;

        abstract void checkHasSubtypeCaster() throws JsonProtocolModelParseException;

        abstract void writeGetSuperMethodJava(JavaCodeGenerator.ClassScope var1);

        abstract boolean checkConditions(Map<?, ?> var1) throws JsonProtocolParseException;
    }
}

