/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.internal.wip;

import java.util.List;
import org.eclipse.wst.jsdt.chromium.RelayOk;
import org.eclipse.wst.jsdt.chromium.SyncCallback;
import org.eclipse.wst.jsdt.chromium.UpdatableScript;
import org.eclipse.wst.jsdt.chromium.internal.ScriptBase;
import org.eclipse.wst.jsdt.chromium.internal.liveeditprotocol.LiveEditProtocolParserAccess;
import org.eclipse.wst.jsdt.chromium.internal.liveeditprotocol.LiveEditResult;
import org.eclipse.wst.jsdt.chromium.internal.protocolparser.JsonProtocolParseException;
import org.eclipse.wst.jsdt.chromium.internal.wip.WipCommandProcessor;
import org.eclipse.wst.jsdt.chromium.internal.wip.WipContextBuilder;
import org.eclipse.wst.jsdt.chromium.internal.wip.WipScriptManager;
import org.eclipse.wst.jsdt.chromium.internal.wip.protocol.input.debugger.CallFrameValue;
import org.eclipse.wst.jsdt.chromium.internal.wip.protocol.input.debugger.SetScriptSourceData;
import org.eclipse.wst.jsdt.chromium.internal.wip.protocol.output.debugger.SetScriptSourceParams;
import org.eclipse.wst.jsdt.chromium.util.GenericCallback;
import org.eclipse.wst.jsdt.chromium.util.RelaySyncCallback;

class WipScriptImpl
extends ScriptBase<String> {
    private final WipScriptManager scriptManager;

    WipScriptImpl(WipScriptManager scriptManager, ScriptBase.Descriptor<String> descriptor) {
        super(descriptor);
        this.scriptManager = scriptManager;
    }

    public RelayOk setSourceOnRemote(String newSource, UpdatableScript.UpdateCallback callback, SyncCallback syncCallback) {
        return this.sendLiveEditRequest(newSource, false, callback, syncCallback);
    }

    public RelayOk previewSetSource(String newSource, UpdatableScript.UpdateCallback callback, SyncCallback syncCallback) {
        return this.sendLiveEditRequest(newSource, true, callback, syncCallback);
    }

    private RelayOk sendLiveEditRequest(String newSource, final boolean preview, final UpdatableScript.UpdateCallback updateCallback, SyncCallback syncCallback) {
        RelaySyncCallback relay = new RelaySyncCallback(syncCallback);
        final RelaySyncCallback.Guard guard = relay.newGuard();
        SetScriptSourceParams params = new SetScriptSourceParams((String)this.getId(), newSource, preview);
        GenericCallback<SetScriptSourceData> commandCallback = new GenericCallback<SetScriptSourceData>(){

            public void success(SetScriptSourceData value) {
                RelayOk relayOk = WipScriptImpl.this.possiblyUpdateCallFrames(preview, value, updateCallback, guard.getRelay());
                guard.discharge(relayOk);
            }

            public void failure(Exception exception) {
                updateCallback.failure(exception.getMessage(), UpdatableScript.Failure.UNSPECIFIED);
            }
        };
        WipCommandProcessor commandProcessor = this.scriptManager.getTabImpl().getCommandProcessor();
        return commandProcessor.send(params, commandCallback, guard.asSyncCallback());
    }

    private RelayOk possiblyUpdateCallFrames(boolean preview, final SetScriptSourceData data, final UpdatableScript.UpdateCallback updateCallback, RelaySyncCallback relay) {
        List<CallFrameValue> callFrames = null;
        if (!preview) {
            callFrames = data.callFrames();
        }
        if (callFrames == null) {
            this.dispatchResult(data.result(), updateCallback);
            return relay.finish();
        }
        GenericCallback<Void> setFramesCallback = new GenericCallback<Void>(){

            public void success(Void value) {
                WipScriptImpl.this.dispatchResult(data.result(), updateCallback);
            }

            public void failure(Exception exception) {
                throw new RuntimeException(exception);
            }
        };
        WipContextBuilder contextBuilder = this.scriptManager.getTabImpl().getContextBuilder();
        return contextBuilder.updateStackTrace(callFrames, setFramesCallback, relay.getUserSyncCallback());
    }

    private void dispatchResult(SetScriptSourceData.Result result, UpdatableScript.UpdateCallback updateCallback) {
        if (updateCallback != null) {
            LiveEditResult liveEditResult;
            try {
                liveEditResult = LiveEditProtocolParserAccess.get().parseLiveEditResult(result.getUnderlyingObject());
            }
            catch (JsonProtocolParseException e) {
                throw new RuntimeException("Failed to parse LiveEdit response", e);
            }
            UpdatableScript.ChangeDescription wrappedChangeDescription = ScriptBase.UpdateResultParser.wrapChangeDescription((LiveEditResult)liveEditResult);
            updateCallback.success(false, null, wrappedChangeDescription);
        }
    }
}

