/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.description.rules;

import java.lang.reflect.Method;
import org.eclipse.wb.internal.core.model.description.ComponentDescription;
import org.eclipse.wb.internal.core.model.description.MethodDescription;
import org.eclipse.wb.internal.core.model.description.rules.AbstractDesignerRule;
import org.eclipse.wb.internal.core.utils.check.Assert;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.xml.sax.Attributes;

public final class MethodRule
extends AbstractDesignerRule {
    private ComponentDescription componentDescription;
    private MethodDescription methodDescription;

    public void begin(String namespace, String name, Attributes attributes) throws Exception {
        this.componentDescription = (ComponentDescription)this.getDigester().peek();
        this.pushNewMethodDescription();
        this.configureBegin(attributes);
    }

    private void pushNewMethodDescription() {
        Class<?> componentClass = this.componentDescription.getComponentClass();
        this.methodDescription = new MethodDescription(componentClass);
        this.getDigester().push((Object)this.methodDescription);
    }

    private void configureBegin(Attributes attributes) {
        this.methodDescription.setName(MethodRule.getRequiredAttribute("method", attributes, "name"));
        this.setOptionalOrder(attributes);
        this.setExecutableFlag(attributes);
    }

    private void setOptionalOrder(Attributes attributes) {
        String orderSpecification = attributes.getValue("order");
        if (orderSpecification != null) {
            this.methodDescription.setOrderSpecification(orderSpecification);
        }
    }

    private void setExecutableFlag(Attributes attributes) {
        String executableString = attributes.getValue("executable");
        if (executableString != null) {
            boolean executable = !"false".equalsIgnoreCase(executableString);
            this.methodDescription.setExecutable(executable);
        }
    }

    public void end(String namespace, String name) throws Exception {
        this.popMethodDescription();
        this.configureEnd();
        this.componentDescription.addMethod(this.methodDescription);
    }

    private void popMethodDescription() {
        this.getDigester().pop();
    }

    private void configureEnd() {
        this.methodDescription.postProcess();
        this.configureWithReflectionMethod();
    }

    private void configureWithReflectionMethod() {
        Method method = this.getReflectionMethod();
        this.methodDescription.setReturnClass(method.getReturnType());
    }

    private Method getReflectionMethod() {
        Class<?> componentClass = this.methodDescription.getDeclaringClass();
        String signature = this.methodDescription.getSignature();
        Method method = ReflectionUtils.getMethodBySignature(componentClass, (String)signature);
        Assert.isNotNull2((Object)method, (String)"No such method {0}.{1} during parsing {2}", (Object[])new Object[]{componentClass.getName(), signature, this.componentDescription.getCurrentClass().getName()});
        return method;
    }
}

