/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.rete.network.mailbox.timeless;

import java.util.Map;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;
import org.eclipse.viatra.query.runtime.matchers.util.CollectionsFactory;
import org.eclipse.viatra.query.runtime.matchers.util.Direction;
import org.eclipse.viatra.query.runtime.rete.network.Receiver;
import org.eclipse.viatra.query.runtime.rete.network.ReteContainer;
import org.eclipse.viatra.query.runtime.rete.network.communication.CommunicationGroup;
import org.eclipse.viatra.query.runtime.rete.network.communication.MessageSelector;
import org.eclipse.viatra.query.runtime.rete.network.communication.PhasedSelector;
import org.eclipse.viatra.query.runtime.rete.network.communication.Timestamp;
import org.eclipse.viatra.query.runtime.rete.network.mailbox.AdaptableMailbox;
import org.eclipse.viatra.query.runtime.rete.network.mailbox.Mailbox;

public class DefaultMailbox
implements AdaptableMailbox {
    private static int SIZE_TRESHOLD = 127;
    protected Map<Tuple, Integer> queue;
    protected Map<Tuple, Integer> buffer;
    protected final Receiver receiver;
    protected final ReteContainer container;
    protected boolean delivering;
    protected Mailbox adapter;
    protected CommunicationGroup group;

    public DefaultMailbox(Receiver receiver, ReteContainer container) {
        this.receiver = receiver;
        this.container = container;
        this.queue = CollectionsFactory.createMap();
        this.buffer = CollectionsFactory.createMap();
        this.adapter = this;
    }

    protected Map<Tuple, Integer> getActiveQueue() {
        if (this.delivering) {
            return this.buffer;
        }
        return this.queue;
    }

    @Override
    public Mailbox getAdapter() {
        return this.adapter;
    }

    @Override
    public void setAdapter(Mailbox adapter) {
        this.adapter = adapter;
    }

    @Override
    public boolean isEmpty() {
        return this.getActiveQueue().isEmpty();
    }

    @Override
    public void postMessage(Direction direction, Tuple update, Timestamp timestamp) {
        Map<Tuple, Integer> activeQueue = this.getActiveQueue();
        boolean wasEmpty = activeQueue.isEmpty();
        boolean significantChange = false;
        Integer count = activeQueue.get(update);
        if (count == null) {
            count = 0;
            significantChange = true;
        }
        if ((count = direction == Direction.DELETE ? Integer.valueOf(count - 1) : Integer.valueOf(count + 1)) == 0) {
            activeQueue.remove(update);
            significantChange = true;
        } else {
            activeQueue.put(update, count);
        }
        if (significantChange) {
            Mailbox targetMailbox = this.adapter;
            CommunicationGroup targetGroup = this.adapter.getCurrentGroup();
            if (wasEmpty) {
                targetGroup.notifyHasMessage(targetMailbox, PhasedSelector.DEFAULT);
            } else if (activeQueue.isEmpty()) {
                targetGroup.notifyLostAllMessages(targetMailbox, PhasedSelector.DEFAULT);
            }
        }
    }

    @Override
    public void deliverAll(MessageSelector kind) {
        if (kind == PhasedSelector.DEFAULT) {
            this.delivering = true;
            for (Map.Entry<Tuple, Integer> entry : this.queue.entrySet()) {
                Direction direction;
                int count = entry.getValue();
                if (count < 0) {
                    direction = Direction.DELETE;
                    count = -count;
                } else {
                    direction = Direction.INSERT;
                }
                int i = 0;
                while (i < count) {
                    this.receiver.update(direction, entry.getKey(), Timestamp.ZERO);
                    ++i;
                }
            }
            this.delivering = false;
            if (this.queue.size() > SIZE_TRESHOLD) {
                this.queue = this.buffer;
                this.buffer = CollectionsFactory.createMap();
            } else {
                this.queue.clear();
                Map<Tuple, Integer> tmpQueue = this.queue;
                this.queue = this.buffer;
                this.buffer = tmpQueue;
            }
        } else {
            throw new IllegalArgumentException("Unsupported message kind " + kind);
        }
    }

    public String toString() {
        return "D_MBOX (" + this.receiver + ") " + this.getActiveQueue();
    }

    @Override
    public Receiver getReceiver() {
        return this.receiver;
    }

    public void clear() {
        this.queue.clear();
        this.buffer.clear();
    }

    @Override
    public CommunicationGroup getCurrentGroup() {
        return this.group;
    }

    @Override
    public void setCurrentGroup(CommunicationGroup group) {
        this.group = group;
    }
}

