/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.provisional.analysis.lami.ui.views;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.analysis.lami.ui.Activator;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.module.LamiAnalysisReport;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.module.LamiResultTable;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.ui.viewers.LamiTableViewer;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.ui.views.LamiReportViewFactory;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.ui.views.LamiReportViewTabPage;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.ui.views.LamiViewerControl;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.ui.views.Messages;
import org.eclipse.tracecompass.internal.tmf.ui.commands.ExportToTsvAction;
import org.eclipse.tracecompass.tmf.ui.viewers.IImageSave;
import org.eclipse.tracecompass.tmf.ui.viewers.TmfViewer;
import org.eclipse.tracecompass.tmf.ui.views.SaveImageUtil;
import org.eclipse.tracecompass.tmf.ui.views.TmfView;
import org.eclipse.ui.IActionBars;

public final class LamiReportView
extends TmfView {
    private static final Separator SEPARATOR = new Separator();
    public static final String VIEW_ID = "org.eclipse.tracecompass.analysis.lami.views.reportview";
    private final @Nullable LamiAnalysisReport fReport;
    private final List<LamiReportViewTabPage> fTabPages;
    private @Nullable CTabFolder fTabFolder;
    private final Action fExportTsvAction = new ExportToTsvAction(){

        protected void exportToTsv(@Nullable OutputStream stream) {
            TmfViewer viewer = this.getViewer();
            if (viewer instanceof LamiTableViewer) {
                ((LamiTableViewer)viewer).exportToTsv(stream);
            }
        }

        private @Nullable TmfViewer getViewer() {
            LamiReportViewTabPage tabPage = LamiReportView.this.getCurrentSelectedPage();
            if (tabPage == null) {
                return null;
            }
            LamiViewerControl viewerControl = tabPage.getTableViewerControl();
            TmfViewer viewer = viewerControl.getViewer();
            return viewer;
        }

        public boolean isEnabled() {
            return this.getViewer() instanceof LamiTableViewer;
        }

        protected @Nullable Shell getShell() {
            return LamiReportView.this.getViewSite().getShell();
        }
    };
    private final Function<Integer, @Nullable IImageSave> fImageProvider = index -> {
        TmfViewer viewer;
        LamiReportViewTabPage selectedPage = this.getCurrentSelectedPage();
        if (selectedPage == null) {
            return null;
        }
        List<LamiViewerControl> plots = selectedPage.getCustomGraphViewerControls();
        if (index >= 0 && index < plots.size() && (viewer = plots.get((int)index).getViewer()) instanceof IImageSave) {
            return (IImageSave)viewer;
        }
        return null;
    };
    private IAction fClearCustomViewsAction = new Action(){

        public void run() {
            LamiReportViewTabPage tabPage = LamiReportView.this.getCurrentSelectedPage();
            if (tabPage == null) {
                return;
            }
            tabPage.clearAllCustomViewers();
            tabPage.getControl().layout();
        }
    };
    private IAction fNewChartAction = new NewCustomChartAction();

    private List<Supplier<@Nullable IImageSave>> getSuppliers() {
        ArrayList<Supplier<@Nullable IImageSave>> suppliers = new ArrayList<Supplier<IImageSave>>();
        LamiReportViewTabPage selectedPage = this.getCurrentSelectedPage();
        if (selectedPage == null) {
            return Collections.emptyList();
        }
        List<LamiViewerControl> plots = selectedPage.getCustomGraphViewerControls();
        int i = 0;
        while (i < plots.size()) {
            IImageSave iis = this.fImageProvider.apply(i);
            if (iis != null) {
                suppliers.add(() -> iis);
            }
            ++i;
        }
        return suppliers;
    }

    public LamiReportView() {
        super(VIEW_ID);
        this.fReport = LamiReportViewFactory.getCurrentReport();
        this.fTabPages = new ArrayList<LamiReportViewTabPage>();
    }

    public void createPartControl(@Nullable Composite parent) {
        LamiAnalysisReport report = this.fReport;
        if (report == null || parent == null) {
            return;
        }
        this.setPartName(report.getName());
        this.fTabFolder = new CTabFolder(parent, 0);
        this.fTabFolder.setSimple(false);
        for (LamiResultTable table : report.getTables()) {
            String name = table.getTableClass().getTableTitle();
            CTabItem tabItem = new CTabItem(this.fTabFolder, 0);
            tabItem.setText(name);
            SashForm sf = new SashForm((Composite)this.fTabFolder, 0);
            this.fTabPages.add(new LamiReportViewTabPage((Composite)sf, table));
            tabItem.setControl((Control)sf);
        }
        ToggleTableAction toggleTableAction = new ToggleTableAction();
        toggleTableAction.setText(Messages.LamiReportView_ActivateTableAction_ButtonName);
        toggleTableAction.setToolTipText(Messages.LamiReportView_ActivateTableAction_ButtonTooltip);
        toggleTableAction.setImageDescriptor(Activator.getDefault().getImageDescripterFromPath("icons/table.gif"));
        IActionBars actionBars = this.getViewSite().getActionBars();
        IToolBarManager toolbarMgr = actionBars.getToolBarManager();
        toolbarMgr.add((IAction)toggleTableAction);
        this.fNewChartAction.setText(Messages.LamiReportView_NewCustomChart);
        this.fClearCustomViewsAction.setText(Messages.LamiReportView_ClearAllCustomViews);
        IMenuManager menuMgr = actionBars.getMenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(manager -> {
            if (manager != null) {
                this.populateMenu(manager);
            }
        });
        this.populateMenu(menuMgr);
        CTabFolder tf = (CTabFolder)NonNullUtils.checkNotNull((Object)this.fTabFolder);
        if (tf.getItemCount() > 0) {
            tf.setSelection(0);
        }
    }

    private void populateMenu(IMenuManager menuMgr) {
        List<Supplier<IImageSave>> suppliers;
        menuMgr.add(this.fNewChartAction);
        menuMgr.add((IContributionItem)SEPARATOR);
        menuMgr.add(this.fClearCustomViewsAction);
        menuMgr.add((IContributionItem)SEPARATOR);
        if (this.fExportTsvAction.isEnabled()) {
            menuMgr.add((IAction)this.fExportTsvAction);
        }
        boolean isSingleton = (suppliers = this.getSuppliers()).size() == 1;
        LamiReportViewTabPage currentSelectedPage = this.getCurrentSelectedPage();
        if (currentSelectedPage != null) {
            int index = 0;
            while (index < suppliers.size()) {
                String fileName = isSingleton ? currentSelectedPage.getName() : String.format("%s%02d", currentSelectedPage.getName(), index + 1);
                Action action = SaveImageUtil.createSaveAction((String)fileName, suppliers.get(index));
                String suffix = isSingleton ? "" : " " + (index + 1);
                action.setText(String.valueOf(Messages.LamiReportView_ActivateTableAction_ExportChart) + suffix + '\u2026');
                menuMgr.add((IAction)action);
                ++index;
            }
        }
    }

    public void setFocus() {
        if (this.fTabFolder != null) {
            this.fTabFolder.setFocus();
        }
    }

    @Nullable LamiReportViewTabPage getCurrentSelectedPage() {
        CTabFolder tf = this.fTabFolder;
        if (tf == null) {
            return null;
        }
        int idx = tf.getSelectionIndex();
        if (idx != -1) {
            return this.fTabPages.get(idx);
        }
        return null;
    }

    private class NewCustomChartAction
    extends Action {
        private NewCustomChartAction() {
        }

        public void run() {
            LamiReportViewTabPage page = LamiReportView.this.getCurrentSelectedPage();
            if (page == null) {
                return;
            }
            page.createNewCustomChart();
        }
    }

    private class ToggleTableAction
    extends Action {
        private ToggleTableAction() {
        }

        public void run() {
            LamiReportViewTabPage page = LamiReportView.this.getCurrentSelectedPage();
            if (page == null) {
                return;
            }
            page.toggleTableViewer();
        }
    }
}

