/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.graphics;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.graphics.GCOperation;

public final class GCAdapter {
    private final List<GCOperation> gcOperations = new LinkedList<GCOperation>();
    private boolean forceRedraw;
    private Rectangle paintRect;

    public void addGCOperation(GCOperation operation) {
        this.gcOperations.add(operation);
    }

    public GCOperation[] getGCOperations() {
        GCOperation[] result = new GCOperation[this.gcOperations.size()];
        this.gcOperations.toArray(result);
        return result;
    }

    public void clearGCOperations() {
        this.gcOperations.clear();
    }

    public GCOperation[] getTrimmedGCOperations() {
        int counter = 0;
        boolean stop = false;
        GCOperation[] operations = this.getGCOperations();
        int i = operations.length - 1;
        while (i >= 0 && !stop) {
            if (GCAdapter.isDrawOperation(operations[i])) {
                stop = true;
            } else {
                ++counter;
            }
            --i;
        }
        GCOperation[] result = new GCOperation[operations.length - counter];
        System.arraycopy(operations, 0, result, 0, result.length);
        return result;
    }

    public void setForceRedraw(boolean forceRedraw) {
        this.forceRedraw = forceRedraw;
    }

    public boolean getForceRedraw() {
        return this.forceRedraw;
    }

    public void setPaintRect(Rectangle paintRect) {
        this.paintRect = paintRect;
    }

    public Rectangle getPaintRect() {
        return this.paintRect;
    }

    private static boolean isDrawOperation(GCOperation operation) {
        return !(operation instanceof GCOperation.SetProperty);
    }
}

