/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.refactoring.core;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.php.core.ast.nodes.ASTNode;
import org.eclipse.php.core.ast.nodes.Expression;
import org.eclipse.php.core.ast.nodes.IBinding;
import org.eclipse.php.core.ast.nodes.IMethodBinding;
import org.eclipse.php.core.ast.nodes.IVariableBinding;
import org.eclipse.php.core.ast.nodes.Identifier;
import org.eclipse.php.core.ast.nodes.Program;
import org.eclipse.php.core.ast.nodes.Variable;
import org.eclipse.php.core.ast.visitor.AbstractVisitor;
import org.eclipse.php.core.ast.visitor.Visitor;
import org.eclipse.php.internal.core.ast.locator.PHPElementConciliator;
import org.eclipse.php.internal.core.search.IOccurrencesFinder;
import org.eclipse.php.internal.core.search.OccurrencesFinderFactory;

public class LinkedNodeFinder {
    private LinkedNodeFinder() {
    }

    public static IOccurrencesFinder.OccurrenceLocation[] findByNode(Program root, ASTNode node) {
        Expression name;
        ASTNode selectedNode = node;
        if (selectedNode != null && selectedNode.getType() == 60 && (name = ((Variable)selectedNode).getName()) instanceof Identifier) {
            selectedNode = name;
        }
        IOccurrencesFinder.OccurrenceLocation[] locations = null;
        int type = PHPElementConciliator.concile((ASTNode)selectedNode);
        IOccurrencesFinder finder = OccurrencesFinderFactory.getOccurrencesFinder((int)type);
        if (finder != null && finder.initialize(root, selectedNode) == null) {
            locations = finder.getOccurrences();
        }
        return locations;
    }

    public static IOccurrencesFinder.OccurrenceLocation[] findByNode(Program root, ASTNode[] nodes) {
        ArrayList<IOccurrencesFinder.OccurrenceLocation> locationList = new ArrayList<IOccurrencesFinder.OccurrenceLocation>();
        ASTNode[] aSTNodeArray = nodes;
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            ASTNode selectedNode = aSTNodeArray[n2];
            IOccurrencesFinder.OccurrenceLocation[] locations = LinkedNodeFinder.findByNode(root, selectedNode);
            if (locations != null) {
                locationList.addAll(Arrays.asList(locations));
            }
            ++n2;
        }
        return locationList.toArray(new IOccurrencesFinder.OccurrenceLocation[locationList.size()]);
    }

    public static Identifier[] findByBinding(ASTNode root, IVariableBinding binding) {
        ArrayList<Identifier> res = new ArrayList<Identifier>();
        BindingFinder nodeFinder = new BindingFinder((IBinding)binding, res);
        root.accept((Visitor)nodeFinder);
        return res.toArray(new Identifier[res.size()]);
    }

    private static class BindingFinder
    extends AbstractVisitor {
        private IBinding fBinding;
        private ArrayList<Identifier> fResult;

        public BindingFinder(IBinding binding, ArrayList<Identifier> result) {
            this.fBinding = binding;
            this.fResult = result;
        }

        public boolean visit(Identifier node) {
            IBinding binding = node.resolveBinding();
            if (binding == null) {
                return false;
            }
            if (this.fBinding.equals((Object)binding)) {
                this.fResult.add(node);
            } else {
                IMethodBinding curr;
                IMethodBinding methodBinding;
                if (binding.getKind() != this.fBinding.getKind()) {
                    return false;
                }
                if (binding.getKind() == 4 && ((methodBinding = (IMethodBinding)this.fBinding).overrides(curr = (IMethodBinding)binding) || curr.overrides(methodBinding))) {
                    this.fResult.add(node);
                }
            }
            return false;
        }
    }
}

