/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.ui.services;

import java.io.IOException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.resource.sasheditor.SashModel;
import org.eclipse.papyrus.infra.core.services.IService;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.ui.Activator;
import org.eclipse.papyrus.infra.ui.editor.IMultiDiagramEditor;
import org.eclipse.papyrus.infra.ui.internal.commands.TogglePageLayoutStorageHandler;
import org.eclipse.papyrus.infra.ui.internal.preferences.EditorPreferences;
import org.eclipse.papyrus.infra.ui.internal.preferences.YesNo;
import org.eclipse.papyrus.infra.ui.lifecycleevents.DoSaveEvent;
import org.eclipse.papyrus.infra.ui.lifecycleevents.ILifeCycleEventsProvider;
import org.eclipse.papyrus.infra.ui.lifecycleevents.LifeCycleEventsProvider;
import org.eclipse.papyrus.infra.ui.services.EditorLifecycleEventListener;
import org.eclipse.papyrus.infra.ui.services.EditorLifecycleManager;
import org.eclipse.papyrus.infra.ui.services.Messages;
import org.eclipse.swt.widgets.Shell;

public class SaveLayoutBeforeClose
implements IService {
    private ServicesRegistry registry;
    private EditorLifecycleManager lifecycleManager;
    private EditorLifecycleEventListener lifecycleListener;

    public void init(ServicesRegistry servicesRegistry) throws ServiceException {
        this.registry = servicesRegistry;
    }

    public void startService() throws ServiceException {
        this.installSaveOnClose();
    }

    protected void installSaveOnClose() {
        try {
            this.lifecycleManager = (EditorLifecycleManager)this.registry.getService(EditorLifecycleManager.class);
            if (this.lifecycleManager == null) {
                return;
            }
        }
        catch (ServiceException ex) {
            return;
        }
        this.lifecycleListener = new EditorLifecycleEventListener(){

            @Override
            public void postInit(IMultiDiagramEditor editor) {
            }

            @Override
            public void postDisplay(IMultiDiagramEditor editor) {
                SaveLayoutBeforeClose.this.checkSharedLayout(editor);
            }

            @Override
            public void beforeClose(IMultiDiagramEditor editor) {
                SaveLayoutBeforeClose.this.saveBeforeClose(editor);
            }
        };
        this.lifecycleManager.addEditorLifecycleEventsListener(this.lifecycleListener);
    }

    public void saveBeforeClose(IMultiDiagramEditor editor) {
        ModelSet modelSet;
        if (editor.isDirty()) {
            return;
        }
        LifeCycleEventsProvider internalLifecycleEventsProvider = null;
        try {
            modelSet = (ModelSet)this.registry.getService(ModelSet.class);
        }
        catch (ServiceException ex) {
            return;
        }
        try {
            ILifeCycleEventsProvider eventsProvider = (ILifeCycleEventsProvider)this.registry.getService(ILifeCycleEventsProvider.class);
            if (eventsProvider instanceof LifeCycleEventsProvider) {
                internalLifecycleEventsProvider = (LifeCycleEventsProvider)eventsProvider;
            }
        }
        catch (ServiceException eventsProvider) {
            // empty catch block
        }
        SashModel sashModel = (SashModel)modelSet.getModel("org.eclipse.papyrus.infra.core.resource.sasheditor.SashModel");
        try {
            DoSaveEvent event = new DoSaveEvent(this.registry, editor, true);
            if (internalLifecycleEventsProvider != null) {
                internalLifecycleEventsProvider.fireAboutToDoSaveEvent(event);
                internalLifecycleEventsProvider.fireDoSaveEvent(event);
            }
            sashModel.saveModel();
            if (internalLifecycleEventsProvider != null) {
                internalLifecycleEventsProvider.firePostDoSaveEvent(event);
            }
        }
        catch (IOException ex) {
            Activator.log.error((Throwable)ex);
        }
    }

    private void checkSharedLayout(IMultiDiagramEditor editor) {
        try {
            ModelSet modelSet = (ModelSet)this.registry.getService(ModelSet.class);
            SashModel sashModel = (SashModel)modelSet.getModel("org.eclipse.papyrus.infra.core.resource.sasheditor.SashModel");
            if (sashModel.isLegacyMode()) {
                URI privateURI = sashModel.getPrivateResourceURI();
                if (!modelSet.getURIConverter().exists(privateURI, null)) {
                    this.promptToEnablePrivateStorage(editor);
                }
            }
        }
        catch (ServiceException serviceException) {
            // empty catch block
        }
    }

    private void promptToEnablePrivateStorage(IMultiDiagramEditor editor) {
        YesNo preference = EditorPreferences.getInstance().getConvertSharedPageLayoutToPrivate();
        if (preference == YesNo.PROMPT) {
            MessageDialogWithToggle dlg = MessageDialogWithToggle.openYesNoCancelQuestion((Shell)editor.getSite().getShell(), (String)Messages.SaveLayoutBeforeClose_0, (String)Messages.SaveLayoutBeforeClose_1, (String)Messages.SaveLayoutBeforeClose_2, (boolean)false, null, null);
            switch (dlg.getReturnCode()) {
                case 2: {
                    preference = YesNo.YES;
                    break;
                }
                case 3: {
                    preference = YesNo.NO;
                    break;
                }
                default: {
                    preference = YesNo.PROMPT;
                }
            }
            if (dlg.getToggleState()) {
                EditorPreferences.getInstance().setConvertSharedPageLayoutToPrivate(preference);
            }
        }
        switch (preference) {
            case YES: {
                new TogglePageLayoutStorageHandler().togglePrivatePageLayout(editor);
                this.saveBeforeClose(editor);
                break;
            }
            case NO: {
                try {
                    ModelSet modelSet = (ModelSet)editor.getServicesRegistry().getService(ModelSet.class);
                    SashModel sashModel = (SashModel)modelSet.getModel("org.eclipse.papyrus.infra.core.resource.sasheditor.SashModel");
                    modelSet.createResource(sashModel.getPrivateResourceURI());
                    this.saveBeforeClose(editor);
                }
                catch (ServiceException serviceException) {}
                break;
            }
        }
    }

    public void disposeService() throws ServiceException {
        this.registry = null;
        if (this.lifecycleManager != null) {
            this.lifecycleManager.removeEditorLifecycleEventsListener(this.lifecycleListener);
            this.lifecycleListener = null;
            this.lifecycleManager = null;
        }
    }
}

