/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.sync;

import com.google.common.collect.Lists;
import com.google.common.collect.ObjectArrays;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandWrapper;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.command.IdentityCommand;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.papyrus.infra.sync.EMFDispatchManager;
import org.eclipse.papyrus.infra.sync.EStructuralFeatureSyncDispatcher;
import org.eclipse.papyrus.infra.sync.SyncBucket;
import org.eclipse.papyrus.infra.sync.SyncFeature;
import org.eclipse.papyrus.infra.sync.SyncItem;
import org.eclipse.papyrus.infra.sync.SyncRegistry;

public abstract class EStructuralFeatureSyncFeature<M extends EObject, T>
extends SyncFeature<M, T, Notification> {
    final EStructuralFeature[] features;
    private EMFDispatchManager<Dispatcher> dispatchMgr = this.createMultipleDispatchManager();

    public EStructuralFeatureSyncFeature(SyncBucket<M, T, Notification> bucket, EStructuralFeature feature, EStructuralFeature ... more) {
        super(bucket);
        this.features = (EStructuralFeature[])ObjectArrays.concat((Object)feature, (Object[])more);
    }

    protected Command onTargetAdded(SyncItem<M, T> from, EObject source, SyncItem<M, T> to, T target) {
        return null;
    }

    protected Command onTargetRemoved(SyncItem<M, T> to, T target) {
        return null;
    }

    protected EObject getTargetModel(SyncItem<M, T> from, SyncItem<M, T> to, EObject sourceModel) {
        return sourceModel;
    }

    @Override
    public void observe(SyncItem<M, T> item) {
        EStructuralFeature[] eStructuralFeatureArray = this.features;
        int n = this.features.length;
        int n2 = 0;
        while (n2 < n) {
            EStructuralFeature next = eStructuralFeatureArray[n2];
            this.dispatchMgr.add(item, new Dispatcher(item, next));
            ++n2;
        }
    }

    @Override
    public void unobserve(SyncItem<M, T> item) {
        this.dispatchMgr.remove(item);
    }

    @Override
    protected void onClear() {
        this.dispatchMgr.removeAll();
    }

    @Override
    public void synchronize(SyncItem<M, T> from, SyncItem<M, T> to, Notification message) {
        if (message == null) {
            this.synchronizeInit(from, to);
        } else {
            this.synchronizeIncrement(from, to, message);
        }
    }

    protected abstract Iterable<? extends T> getContents(T var1);

    protected boolean match(EObject sourceModel, EObject targetModel) {
        return sourceModel == targetModel;
    }

    private void synchronizeInit(SyncItem<M, T> from, SyncItem<M, T> to) {
        Iterable<T> childrenFrom = this.getContents(from.getBackend());
        ArrayList childrenTo = Lists.newArrayList(this.getContents(to.getBackend()));
        ArrayList<EObject> toAdd = new ArrayList<EObject>();
        Command additionalCommand = null;
        for (T source : childrenFrom) {
            EObject model = this.getModelOf(source);
            boolean found = false;
            Iterator iter = childrenTo.iterator();
            while (iter.hasNext()) {
                Object target = iter.next();
                EObject potential = this.getTargetModel(from, to, this.getModelOf(target));
                if (!this.match(model, potential)) continue;
                found = true;
                iter.remove();
                Command additional = this.onTargetAdded(from, model, to, target);
                if (additional == null) break;
                additionalCommand = additionalCommand == null ? additional : additionalCommand.chain(additional);
                break;
            }
            if (found) continue;
            toAdd.add(model);
        }
        CompoundCommand command = null;
        if (!childrenTo.isEmpty() || !toAdd.isEmpty()) {
            CompoundCommand compound;
            command = compound = new CompoundCommand("Initial Sync Command");
            int i = 0;
            while (i < childrenTo.size()) {
                compound.append(this.getRemoveCommand(from, null, to, childrenTo.get(i)));
                ++i;
            }
            i = 0;
            while (i < toAdd.size()) {
                Command add;
                EObject newSource = (EObject)toAdd.get(i);
                if (this.shouldAdd(from, to, newSource) && (add = this.getAddCommand(from, to, newSource)) != null) {
                    compound.append(add);
                }
                ++i;
            }
        }
        if (additionalCommand != null) {
            Command command2 = command = command == null ? additionalCommand : command.chain(additionalCommand);
        }
        if (command != null) {
            this.execute((Command)command);
        }
    }

    private void synchronizeIncrement(SyncItem<M, T> from, SyncItem<M, T> to, Notification message) {
        Dispatcher dispatcher = this.dispatchMgr.getDispatcher(from, message.getFeature());
        switch (message.getEventType()) {
            case 3: {
                dispatcher.handleAdd(from, to, (EObject)message.getNewValue());
                break;
            }
            case 5: {
                for (Object next : (Iterable)message.getNewValue()) {
                    dispatcher.handleAdd(from, to, (EObject)next);
                }
                break;
            }
            case 4: {
                dispatcher.handleRemove(from, to, (EObject)message.getOldValue());
                break;
            }
            case 6: {
                for (Object next : (Iterable)message.getOldValue()) {
                    dispatcher.handleRemove(from, to, (EObject)next);
                }
                break;
            }
            case 1: {
                if (message.getOldValue() != null) {
                    dispatcher.handleRemove(from, to, (EObject)message.getOldValue());
                }
                if (message.getNewValue() == null) break;
                dispatcher.handleAdd(from, to, (EObject)message.getNewValue());
                break;
            }
            case 2: {
                if (!(message.getOldValue() instanceof EObject)) break;
                dispatcher.handleRemove(from, to, (EObject)message.getOldValue());
            }
        }
    }

    protected boolean shouldAdd(SyncItem<M, T> from, SyncItem<M, T> to, EObject newSource) {
        return true;
    }

    protected Command getAddCommand(final SyncItem<M, T> from, final SyncItem<M, T> to, final EObject newSource) {
        return new CommandWrapper(this.doGetAddCommand(from, to, newSource)){
            private T addedTarget;

            public void execute() {
                super.execute();
                Object newTarget = this.getCommand().getResult().iterator().next();
                this.addedTarget = newTarget;
                Command additional = EStructuralFeatureSyncFeature.this.onTargetAdded(from, newSource, to, this.addedTarget);
                if (additional != null) {
                    additional.execute();
                }
            }

            public void undo() {
                super.undo();
                Command additional = EStructuralFeatureSyncFeature.this.onTargetRemoved(to, this.addedTarget);
                if (additional != null) {
                    additional.execute();
                }
            }

            public void redo() {
                super.redo();
                Command additional = EStructuralFeatureSyncFeature.this.onTargetAdded(from, newSource, to, this.addedTarget);
                if (additional != null) {
                    additional.execute();
                }
            }
        };
    }

    protected Command doGetAddCommand(SyncItem<M, T> from, SyncItem<M, T> to, EObject newSource) {
        throw new UnsupportedOperationException("doGetAddCommand");
    }

    protected Command getRemoveCommand(final SyncItem<M, T> from, final EObject oldSource, final SyncItem<M, T> to, final T oldTarget) {
        return new CommandWrapper(this.doGetRemoveCommand(from, oldSource, to, oldTarget)){

            public void execute() {
                super.execute();
                Command additional = EStructuralFeatureSyncFeature.this.onTargetRemoved(to, oldTarget);
                if (additional != null) {
                    additional.execute();
                }
            }

            public void undo() {
                Command additional;
                super.undo();
                if (oldSource != null && (additional = EStructuralFeatureSyncFeature.this.onTargetAdded(from, oldSource, to, oldTarget)) != null) {
                    additional.execute();
                }
            }

            public void redo() {
                super.redo();
                Command additional = EStructuralFeatureSyncFeature.this.onTargetRemoved(to, oldTarget);
                if (additional != null) {
                    additional.execute();
                }
            }
        };
    }

    protected Command doGetRemoveCommand(SyncItem<M, T> from, EObject oldSource, SyncItem<M, T> to, T oldTarget) {
        throw new UnsupportedOperationException("doGetRemoveCommand");
    }

    protected EObject getModelOf(T backend) {
        EObject notifier = this.getNotifier(backend);
        return notifier == null ? null : this.getModelOfNotifier(notifier);
    }

    protected abstract EObject getNotifier(T var1);

    protected abstract EObject getModelOfNotifier(EObject var1);

    protected Command synchronizingWrapper(SyncRegistry<?, ? super T, Notification> registry, T backend, Command command) {
        class CleanWrapper
        extends Wrapper
        implements AbstractCommand.NonDirtying {
            CleanWrapper(SyncRegistry syncRegistry, Object object) {
                class Wrapper
                extends CommandWrapper {
                    private final /* synthetic */ SyncRegistry val$registry;
                    private final /* synthetic */ Object val$backend;

                    Wrapper(SyncRegistry syncRegistry, Object object) {
                        this.val$registry = syncRegistry;
                        this.val$backend = object;
                    }

                    Wrapper(Command command, SyncRegistry syncRegistry, Object object) {
                        this.val$registry = syncRegistry;
                        this.val$backend = object;
                        super(command);
                    }

                    public void execute() {
                        super.execute();
                        this.val$registry.synchronize(this.val$backend);
                    }

                    public void undo() {
                        this.val$registry.desynchronize(this.val$backend);
                        super.undo();
                    }

                    public void redo() {
                        super.redo();
                        this.val$registry.synchronize(this.val$backend);
                    }
                }
                super(syncRegistry, object);
            }

            protected Command createCommand() {
                return IdentityCommand.INSTANCE;
            }
        }
        return command == null ? new CleanWrapper(registry, backend) : new Wrapper(command, registry, backend);
    }

    private class Dispatcher
    extends EStructuralFeatureSyncDispatcher<M, T> {
        public Dispatcher(SyncItem<M, T> item, EStructuralFeature feature) {
            super(item, feature);
        }

        @Override
        public EObject getNotifier() {
            return EStructuralFeatureSyncFeature.this.getNotifier(this.getItem().getBackend());
        }

        @Override
        public void onClear() {
            EStructuralFeatureSyncFeature.this.getBucket().clear();
        }

        @Override
        public void onChange(Notification notification) {
            EStructuralFeatureSyncFeature.this.onChange(this.getItem(), notification);
        }

        EObject getModelOf(EObject notifier) {
            return EStructuralFeatureSyncFeature.this.getModelOfNotifier(notifier);
        }

        boolean handleAdd(SyncItem<M, T> from, SyncItem<M, T> to, EObject object) {
            Command add;
            boolean result = true;
            EObject model = this.getModelOf(object);
            Iterable children = EStructuralFeatureSyncFeature.this.getContents(to.getBackend());
            Iterator iter = children.iterator();
            while (!result && iter.hasNext()) {
                Object potential = iter.next();
                boolean bl = result = !EStructuralFeatureSyncFeature.this.match(model, EStructuralFeatureSyncFeature.this.getModelOf(potential));
            }
            if (result && EStructuralFeatureSyncFeature.this.shouldAdd(from, to, model) && (add = EStructuralFeatureSyncFeature.this.getAddCommand(from, to, model)) != null) {
                this.react(add);
            }
            return result;
        }

        boolean handleRemove(SyncItem<M, T> from, SyncItem<M, T> to, EObject object) {
            boolean result = false;
            EObject model = this.getModelOf(object);
            Iterable children = EStructuralFeatureSyncFeature.this.getContents(to.getBackend());
            Iterator iter = children.iterator();
            while (!result && iter.hasNext()) {
                Object potential = iter.next();
                result = EStructuralFeatureSyncFeature.this.match(model, EStructuralFeatureSyncFeature.this.getModelOf(potential));
                if (!result) continue;
                this.react(EStructuralFeatureSyncFeature.this.getRemoveCommand(from, model, to, potential));
            }
            return result;
        }
    }
}

