/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.services.controlmode.ui;

import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.papyrus.infra.services.controlmode.ControlModePlugin;
import org.eclipse.papyrus.infra.services.controlmode.messages.Messages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class OptionalMessageDialog
extends MessageDialog {
    private static final String CHECKBOX_TEXT = Messages.getString("OptionalMessageDialog.checkbox.label");
    private static final String STORE_ID = "OptionalMessageDialog.hide.";
    public static final int NOT_SHOWN = 1025;
    private final String fId;
    private final String fCheckBoxText;
    private Button fHideDialogCheckBox;

    public static int open(String id, Shell parent, String title, Image titleImage, String message, int dialogType, String[] buttonLabels, int defaultButtonIndex) {
        return OptionalMessageDialog.open(id, parent, title, titleImage, message, dialogType, buttonLabels, defaultButtonIndex, CHECKBOX_TEXT);
    }

    public static int open(String id, Shell parent, String title, Image titleImage, String message, int dialogType, String[] buttonLabels, int defaultButtonIndex, String checkboxText) {
        if (!OptionalMessageDialog.isDialogEnabled(id)) {
            return 1025;
        }
        OptionalMessageDialog dialog = new OptionalMessageDialog(id, parent, title, titleImage, message, dialogType, buttonLabels, defaultButtonIndex, checkboxText);
        return dialog.open();
    }

    protected OptionalMessageDialog(String id, Shell parent, String title, Image titleImage, String message, int dialogType, String[] buttonLabels, int defaultButtonIndex) {
        this(id, parent, title, titleImage, message, dialogType, buttonLabels, defaultButtonIndex, CHECKBOX_TEXT);
    }

    protected OptionalMessageDialog(String id, Shell parent, String title, Image titleImage, String message, int dialogType, String[] buttonLabels, int defaultButtonIndex, String checkBoxText) {
        super(parent, title, titleImage, message, dialogType, buttonLabels, defaultButtonIndex);
        this.fId = id;
        this.fCheckBoxText = checkBoxText;
    }

    protected Control createCustomArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        this.fHideDialogCheckBox = new Button(composite, 16416);
        this.fHideDialogCheckBox.setText(this.fCheckBoxText);
        this.fHideDialogCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OptionalMessageDialog.setDialogEnabled(OptionalMessageDialog.this.fId, !((Button)e.widget).getSelection());
            }
        });
        OptionalMessageDialog.applyDialogFont((Control)this.fHideDialogCheckBox);
        return this.fHideDialogCheckBox;
    }

    private static IDialogSettings getDialogSettings() {
        IDialogSettings settings = ControlModePlugin.getDefault().getDialogSettings();
        if ((settings = settings.getSection(STORE_ID)) == null) {
            settings = ControlModePlugin.getDefault().getDialogSettings().addNewSection(STORE_ID);
        }
        return settings;
    }

    public static boolean isDialogEnabled(String key) {
        IDialogSettings settings = OptionalMessageDialog.getDialogSettings();
        return !settings.getBoolean(key);
    }

    public static void setDialogEnabled(String key, boolean isEnabled) {
        IDialogSettings settings = OptionalMessageDialog.getDialogSettings();
        settings.put(key, !isEnabled);
    }

    public static void clearAllRememberedStates() {
        IDialogSettings settings = ControlModePlugin.getDefault().getDialogSettings();
        settings.addNewSection(STORE_ID);
    }
}

