/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.properties.ui.modelelement;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.papyrus.infra.properties.contexts.View;
import org.eclipse.papyrus.infra.properties.internal.ui.Activator;
import org.eclipse.papyrus.infra.properties.ui.modelelement.DataSourceChangedEvent;
import org.eclipse.papyrus.infra.properties.ui.modelelement.DataSourceFactory;
import org.eclipse.papyrus.infra.properties.ui.modelelement.IDataSourceListener;
import org.eclipse.papyrus.infra.properties.ui.modelelement.ModelElement;
import org.eclipse.papyrus.infra.tools.util.CoreExecutors;
import org.eclipse.papyrus.infra.tools.util.ReferenceCounted;
import org.eclipse.papyrus.infra.widgets.creation.ReferenceValueFactory;
import org.eclipse.papyrus.infra.widgets.providers.EmptyContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.EncapsulatedContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.IStaticContentProvider;
import org.eclipse.papyrus.infra.widgets.util.INameResolutionHelper;
import org.eclipse.papyrus.infra.widgets.util.IPapyrusConverter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class DataSource
extends ReferenceCounted<DataSource>
implements IChangeListener {
    private final ListenerList<IChangeListener> changeListeners = new ListenerList(1);
    private final ListenerList<IDataSourceListener> dataSourceListeners = new ListenerList(1);
    private View view;
    private IStructuredSelection selection;
    private Map<String, ModelElement> elements = new HashMap<String, ModelElement>();

    protected DataSource(View view, IStructuredSelection selection) {
        super((ExecutorService)CoreExecutors.getUIExecutorService());
        this.view = view;
        this.selection = selection;
    }

    public ModelElement getModelElement(String propertyPath) {
        String key = propertyPath.substring(0, propertyPath.lastIndexOf(":"));
        if (!this.elements.containsKey(key)) {
            ModelElement element = DataSourceFactory.instance.getModelElementFromPropertyPath(this, propertyPath);
            if (element == null) {
                Activator.log.warn("Unable to find a ModelElement for " + propertyPath + ". Elements : " + this.elements);
            }
            this.elements.put(key, element);
        }
        return this.elements.get(key);
    }

    private String getLocalPropertyPath(String propertyPath) {
        return propertyPath.substring(propertyPath.lastIndexOf(":") + 1);
    }

    public IObservable getObservable(String propertyPath) {
        String localPropertyPath = this.getLocalPropertyPath(propertyPath);
        ModelElement element = this.getModelElement(propertyPath);
        if (element == null) {
            return null;
        }
        IObservable observable = element.getObservable(localPropertyPath);
        if (observable != null) {
            observable.addChangeListener((IChangeListener)this);
        }
        return observable;
    }

    public String toString() {
        return String.format("DataSource<%08x>(%s)%s", System.identityHashCode((Object)this), this.view.getName(), this.selection.toList());
    }

    public IStaticContentProvider getContentProvider(String propertyPath) {
        class Delegator
        extends EncapsulatedContentProvider
        implements IDataSourceListener {
            private final /* synthetic */ String val$propertyPath;

            Delegator(String string) {
                this.val$propertyPath = string;
                this.createDelegate();
                DataSource.this.addDataSourceListener(this);
            }

            public void dispose() {
                this.disposeDelegate();
                DataSource.this.removeDataSourceListener(this);
            }

            private void disposeDelegate() {
                if (this.encapsulated != null) {
                    this.encapsulated.dispose();
                    this.encapsulated = null;
                }
                this.clearTemporaryElements();
            }

            private void createDelegate() {
                this.encapsulate((IStructuredContentProvider)DataSource.this.doGetContentProvider(this.val$propertyPath));
            }

            @Override
            public void dataSourceChanged(DataSourceChangedEvent event) {
                this.disposeDelegate();
                this.createDelegate();
            }
        }
        return new Delegator(propertyPath);
    }

    protected IStaticContentProvider doGetContentProvider(String propertyPath) {
        ModelElement element = this.getModelElement(propertyPath);
        if (element == null) {
            return EmptyContentProvider.instance;
        }
        String localPropertyPath = this.getLocalPropertyPath(propertyPath);
        return element.getContentProvider(localPropertyPath);
    }

    public ILabelProvider getLabelProvider(String propertyPath) {
        class Delegator
        extends LabelProvider
        implements IDataSourceListener,
        ILabelProviderListener,
        DelegatingStyledCellLabelProvider.IStyledLabelProvider {
            private ILabelProvider delegate;
            private final CopyOnWriteArrayList<ILabelProviderListener> listeners = new CopyOnWriteArrayList();
            private final /* synthetic */ String val$propertyPath;

            Delegator(String string) {
                this.val$propertyPath = string;
                DataSource.this.addDataSourceListener(this);
            }

            public void dispose() {
                this.disposeDelegate();
                super.dispose();
            }

            private void disposeDelegate() {
                if (this.delegate != null) {
                    this.delegate.removeListener((ILabelProviderListener)this);
                    this.delegate.dispose();
                    this.delegate = null;
                }
            }

            @Override
            public void dataSourceChanged(DataSourceChangedEvent event) {
                this.disposeDelegate();
            }

            public void addListener(ILabelProviderListener listener) {
                this.listeners.addIfAbsent(listener);
            }

            public void removeListener(ILabelProviderListener listener) {
                this.listeners.remove(listener);
            }

            public void labelProviderChanged(LabelProviderChangedEvent event) {
                if (!this.listeners.isEmpty()) {
                    LabelProviderChangedEvent forward = new LabelProviderChangedEvent((IBaseLabelProvider)this, event.getElements());
                    if (Display.getCurrent() != null) {
                        this.fireLabelProviderChanged(forward);
                    } else {
                        CoreExecutors.getUIExecutorService().execute(() -> this.fireLabelProviderChanged(forward));
                    }
                }
            }

            protected void fireLabelProviderChanged(LabelProviderChangedEvent event) {
                for (ILabelProviderListener next : this.listeners) {
                    try {
                        next.labelProviderChanged(event);
                    }
                    catch (Exception e) {
                        Activator.log.error("Uncaught exception in label provider listener.", (Throwable)e);
                    }
                }
            }

            ILabelProvider getDelegate() {
                if (this.delegate == null) {
                    this.delegate = DataSource.this.doGetLabelProvider(this.val$propertyPath);
                    if (this.delegate == null) {
                        this.delegate = new LabelProvider();
                    }
                    this.delegate.addListener((ILabelProviderListener)this);
                }
                return this.delegate;
            }

            public Image getImage(Object element) {
                return this.getDelegate().getImage(element);
            }

            public String getText(Object element) {
                return this.getDelegate().getText(element);
            }

            public boolean isLabelProperty(Object element, String property) {
                return this.getDelegate().isLabelProperty(element, property);
            }

            public StyledString getStyledText(Object element) {
                StyledString styledText = null;
                ILabelProvider delegateProvider = this.getDelegate();
                styledText = delegateProvider instanceof DelegatingStyledCellLabelProvider.IStyledLabelProvider ? ((DelegatingStyledCellLabelProvider.IStyledLabelProvider)delegateProvider).getStyledText(element) : new StyledString(this.getText(element));
                return styledText;
            }
        }
        return new Delegator(propertyPath);
    }

    protected ILabelProvider doGetLabelProvider(String propertyPath) {
        ModelElement element = this.getModelElement(propertyPath);
        if (element == null) {
            return null;
        }
        String localPropertyPath = this.getLocalPropertyPath(propertyPath);
        return element.getLabelProvider(localPropertyPath);
    }

    public void addChangeListener(IChangeListener listener) {
        this.changeListeners.add((Object)listener);
    }

    public void removeChangeListener(IChangeListener listener) {
        this.changeListeners.remove((Object)listener);
    }

    public void addDataSourceListener(IDataSourceListener listener) {
        this.dataSourceListeners.add((Object)listener);
    }

    public void removeDataSourceListener(IDataSourceListener listener) {
        this.dataSourceListeners.remove((Object)listener);
    }

    public synchronized void handleChange(ChangeEvent event) {
        Object[] listeners = this.changeListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            try {
                ((IChangeListener)listeners[i]).handleChange(event);
            }
            catch (Exception e) {
                Activator.log.error("Uncaught exception in observable change listener.", (Throwable)e);
            }
            ++i;
        }
    }

    protected void fireDataSourceChanged() {
        Object[] listeners = this.dataSourceListeners.getListeners();
        if (listeners.length > 0) {
            DataSourceChangedEvent event = new DataSourceChangedEvent(this);
            int i = 0;
            while (i < listeners.length) {
                try {
                    ((IDataSourceListener)listeners[i]).dataSourceChanged(event);
                }
                catch (Exception e) {
                    Activator.log.error("Uncaught exception in data-source listener.", (Throwable)e);
                }
                ++i;
            }
        }
    }

    public View getView() {
        return this.view;
    }

    public IStructuredSelection getSelection() {
        return this.selection;
    }

    public void setSelection(IStructuredSelection selection) {
        if (!selection.equals(this.selection)) {
            this.selection = selection;
            this.fireDataSourceChanged();
        }
    }

    public boolean isOrdered(String propertyPath) {
        ModelElement element = this.getModelElement(propertyPath);
        if (element == null) {
            return false;
        }
        return element.isOrdered(this.getLocalPropertyPath(propertyPath));
    }

    public boolean isUnique(String propertyPath) {
        ModelElement element = this.getModelElement(propertyPath);
        if (element == null) {
            return false;
        }
        return element.isUnique(this.getLocalPropertyPath(propertyPath));
    }

    public boolean isMandatory(String propertyPath) {
        ModelElement element = this.getModelElement(propertyPath);
        if (element == null) {
            return false;
        }
        return element.isMandatory(this.getLocalPropertyPath(propertyPath));
    }

    public boolean isEditable(String propertyPath) {
        ModelElement element = this.getModelElement(propertyPath);
        if (element == null) {
            return false;
        }
        return element.isEditable(this.getLocalPropertyPath(propertyPath));
    }

    public boolean forceRefresh(String propertyPath) {
        ModelElement element = this.getModelElement(propertyPath);
        if (element == null) {
            return false;
        }
        return element.forceRefresh(this.getLocalPropertyPath(propertyPath));
    }

    public ReferenceValueFactory getValueFactory(String propertyPath) {
        ModelElement element = this.getModelElement(propertyPath);
        if (element == null) {
            return null;
        }
        return element.getValueFactory(this.getLocalPropertyPath(propertyPath));
    }

    public Object getDefaultValue(String propertyPath) {
        ModelElement element = this.getModelElement(propertyPath);
        if (element == null) {
            return null;
        }
        return element.getDefaultValue(this.getLocalPropertyPath(propertyPath));
    }

    public boolean getDirectCreation(String propertyPath) {
        ModelElement element = this.getModelElement(propertyPath);
        if (element == null) {
            return true;
        }
        return element.getDirectCreation(this.getLocalPropertyPath(propertyPath));
    }

    public void dispose() {
        for (ModelElement element : this.elements.values()) {
            if (element == null) continue;
            element.dispose();
        }
        this.elements.clear();
    }

    public IValidator getValidator(String propertyPath) {
        ModelElement element = this.getModelElement(propertyPath);
        if (element == null) {
            return null;
        }
        return element.getValidator(this.getLocalPropertyPath(propertyPath));
    }

    public INameResolutionHelper getNameResolutionHelper(String propertyPath) {
        ModelElement element = this.getModelElement(propertyPath);
        if (element == null) {
            return null;
        }
        return element.getNameResolutionHelper(this.getLocalPropertyPath(propertyPath));
    }

    public IPapyrusConverter getPapyrusConverter(String propertyPath) {
        ModelElement element = this.getModelElement(propertyPath);
        if (element == null) {
            return null;
        }
        return element.getPapyrusConverter(this.getLocalPropertyPath(propertyPath));
    }
}

