/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.export.utils;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.sashwindows.di.service.ILocalPageService;
import org.eclipse.papyrus.infra.core.sashwindows.di.service.IPageManager;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForResourceSet;
import org.eclipse.papyrus.infra.gmfdiag.export.Activator;
import org.eclipse.papyrus.infra.gmfdiag.export.engine.ExportDiagramLocalPageService;
import org.eclipse.papyrus.infra.services.semantic.service.SemanticService;

public class ExportUtils {
    private ExportUtils() {
    }

    public static List<Diagram> getExportableDiagrams(ModelSet modelSet) throws ServiceException {
        return ExportUtils.exportableDiagrams(modelSet).collect(Collectors.toList());
    }

    private static Stream<Diagram> exportableDiagrams(ModelSet modelSet) throws ServiceException {
        IPageManager pageManager = (IPageManager)ServiceUtilsForResourceSet.getInstance().getService(IPageManager.class, (Object)modelSet);
        SemanticService semanticService = (SemanticService)ServiceUtilsForResourceSet.getInstance().getService(SemanticService.class, (Object)modelSet);
        return Stream.of(semanticService.getSemanticRoots()).map(ExportDiagramLocalPageService::new).flatMap(service -> pageManager.allLocalPages((ILocalPageService)service).stream()).filter(Diagram.class::isInstance).map(Diagram.class::cast).distinct();
    }

    public static boolean hasExportableDiagrams(ModelSet modelSet) {
        try {
            return ExportUtils.exportableDiagrams(modelSet).findAny().isPresent();
        }
        catch (ServiceException e) {
            Activator.log.error((Throwable)e);
            return false;
        }
    }
}

