/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.layer;

import org.eclipse.nebula.widgets.nattable.layer.AbstractLayerTransform;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.LabelStack;

public class ZoomLayer
extends AbstractLayerTransform {
    private float zoomFactor = 1.0f;

    public ZoomLayer(ILayer underlyingILayer) {
        super(underlyingILayer);
    }

    public float getZoomFactor() {
        return this.zoomFactor;
    }

    public void setZoomFactor(float zoomFactor) {
        this.zoomFactor = zoomFactor;
    }

    @Override
    public int getWidth() {
        return (int)(this.zoomFactor * (float)super.getWidth());
    }

    @Override
    public int getPreferredWidth() {
        return (int)(this.zoomFactor * (float)super.getPreferredWidth());
    }

    @Override
    public int getColumnWidthByPosition(int columnPosition) {
        return (int)(this.zoomFactor * (float)super.getColumnWidthByPosition(columnPosition));
    }

    @Override
    public int getColumnPositionByX(int x) {
        return super.getColumnPositionByX((int)((float)x / this.zoomFactor));
    }

    @Override
    public int getStartXOfColumnPosition(int columnPosition) {
        return (int)(this.zoomFactor * (float)super.getStartXOfColumnPosition(columnPosition));
    }

    @Override
    public int getHeight() {
        return (int)(this.zoomFactor * (float)super.getHeight());
    }

    @Override
    public int getPreferredHeight() {
        return (int)(this.zoomFactor * (float)super.getPreferredHeight());
    }

    @Override
    public int getRowHeightByPosition(int rowPosition) {
        return (int)(this.zoomFactor * (float)super.getRowHeightByPosition(rowPosition));
    }

    @Override
    public int getRowPositionByY(int y) {
        return super.getRowPositionByY((int)((float)y / this.zoomFactor));
    }

    @Override
    public int getStartYOfRowPosition(int rowPosition) {
        return (int)(this.zoomFactor * (float)super.getStartYOfRowPosition(rowPosition));
    }

    @Override
    public LabelStack getRegionLabelsByXY(int x, int y) {
        return super.getRegionLabelsByXY((int)((float)x / this.zoomFactor), (int)((float)y / this.zoomFactor));
    }
}

