/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.qvt.oml.debug.core;

import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.m2m.qvt.oml.debug.core.IQVTODebugTarget;
import org.eclipse.m2m.qvt.oml.debug.core.QVTOLocalValue;
import org.eclipse.m2m.qvt.oml.debug.core.QVTOVariable;
import org.eclipse.m2m.qvt.oml.debug.core.vm.VMFrameExecutionContext;
import org.eclipse.m2m.qvt.oml.debug.core.vm.VMVariable;
import org.eclipse.m2m.qvt.oml.debug.core.vm.VariableFinder;

public class QVTOLocalVariable
extends QVTOVariable {
    private final long myFrameID;
    private final VMFrameExecutionContext myExecContext;

    QVTOLocalVariable(IQVTODebugTarget debugTarget, VMVariable vmVar, long frameID, VMFrameExecutionContext execContext) {
        super(debugTarget, vmVar, frameID);
        this.myFrameID = frameID;
        this.myExecContext = execContext;
    }

    @Override
    public IValue getValue() throws DebugException {
        if (this.fValue == null) {
            QVTOLocalValue.LocalValue lv = new QVTOLocalValue.LocalValue();
            lv.valueObject = this.vmVar.valueObject;
            lv.valueType = this.vmVar.valueObject instanceof EObject ? ((EObject)this.vmVar.valueObject).eClass() : null;
            this.fValue = new QVTOLocalValue(this.getQVTODebugTarget(), this.myFrameID, VariableFinder.getVariablePath(VariableFinder.parseURI(this.vmVar.variableURI)), lv, this.myExecContext);
        }
        return this.fValue;
    }
}

