/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.pde.connector;

import java.io.File;
import java.util.List;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.IMaven;
import org.eclipse.m2e.core.internal.markers.MavenProblemInfo;
import org.eclipse.m2e.core.internal.markers.SourceLocation;
import org.eclipse.m2e.core.internal.markers.SourceLocationHelper;
import org.eclipse.m2e.core.lifecyclemapping.model.IPluginExecutionMetadata;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.configurator.AbstractBuildParticipant;
import org.eclipse.m2e.core.project.configurator.AbstractProjectConfigurator;
import org.eclipse.m2e.core.project.configurator.ILifecycleMappingConfiguration;
import org.eclipse.m2e.core.project.configurator.MojoExecutionBuildParticipant;
import org.eclipse.m2e.core.project.configurator.MojoExecutionKey;
import org.eclipse.m2e.core.project.configurator.ProjectConfigurationRequest;
import org.eclipse.m2e.jdt.IClasspathDescriptor;
import org.eclipse.m2e.jdt.IJavaProjectConfigurator;
import org.eclipse.m2e.pde.connector.PDEProjectHelper;

public class PDEMavenBundlePluginConfigurator
extends AbstractProjectConfigurator
implements IJavaProjectConfigurator {
    private static final String FELIX_PARAM_MANIFESTLOCATION = "manifestLocation";
    private static final String FELIX_PARAM_SUPPORTINCREMENTALBUILD = "supportIncrementalBuild";
    private static final String FELIX_MANIFEST_GOAL = "manifest";
    private static final String BND_PARAM_MANIFESTLOCATION = "manifestPath";
    private static final List<String> BND_MANIFEST_GOALS = List.of("bnd-process", "bnd-process-tests", "jar", "test-jar");

    public void configure(ProjectConfigurationRequest request, IProgressMonitor monitor) throws CoreException {
        List executions = this.getMojoExecutions(request, monitor);
        boolean hasManifestExecution = false;
        for (MojoExecution execution : executions) {
            Plugin plugin = execution.getPlugin();
            if (this.isFelix(plugin)) {
                if (!this.isFelixManifestGoal(execution)) continue;
                IMaven maven = MavenPlugin.getMaven();
                Boolean supportIncremental = (Boolean)maven.getMojoParameterValue(request.mavenProject(), execution, FELIX_PARAM_SUPPORTINCREMENTALBUILD, Boolean.class, monitor);
                if (supportIncremental == null || !supportIncremental.booleanValue()) {
                    this.createWarningMarker(request, execution, "configuration", "Incremental updates are currently disabled, set supportIncrementalBuild=true to support automatic manifest updates for this project.");
                }
                hasManifestExecution = true;
                continue;
            }
            if (!this.isBND(plugin) || !this.isBNDBundleGoal(execution)) continue;
            hasManifestExecution = true;
        }
        if (!hasManifestExecution && !executions.isEmpty()) {
            MojoExecution execution;
            execution = (MojoExecution)executions.get(0);
            this.createWarningMarker(request, execution, "executions", "There is currently no execution that generates a manifest, consider adding an execution for one of the following goal: " + (this.isFelix(execution.getPlugin()) ? FELIX_MANIFEST_GOAL : BND_MANIFEST_GOALS) + ".");
        }
        IMavenProjectFacade facade = request.mavenProjectFacade();
        IPath metainfPath = this.getMetainfPath(facade, executions, monitor);
        PDEProjectHelper.addPDENature(facade.getProject(), metainfPath, monitor);
    }

    private void createWarningMarker(ProjectConfigurationRequest request, MojoExecution execution, String attribute, String message) {
        SourceLocation location = SourceLocationHelper.findLocation((Plugin)execution.getPlugin(), (String)attribute);
        String[] gav = location.getResourceId().split(":");
        IMavenProjectFacade facade = this.projectManager.getMavenProject(gav[0], gav[1], gav[2]);
        if (facade == null) {
            location = SourceLocationHelper.findLocation((MavenProject)request.mavenProject(), (MojoExecutionKey)new MojoExecutionKey(execution));
            facade = request.mavenProjectFacade();
        }
        MavenProblemInfo problem = new MavenProblemInfo(message, 1, location);
        this.markerManager.addErrorMarker((IResource)facade.getPom(), "org.eclipse.m2e.core.maven2Problem.lifecycleMapping", problem);
    }

    private boolean isFelixManifestGoal(MojoExecution execution) {
        return FELIX_MANIFEST_GOAL.equals(execution.getGoal());
    }

    private boolean isBNDBundleGoal(MojoExecution execution) {
        return BND_MANIFEST_GOALS.contains(execution.getGoal());
    }

    public void configureClasspath(IMavenProjectFacade facade, IClasspathDescriptor classpath, IProgressMonitor monitor) throws CoreException {
    }

    public void configureRawClasspath(ProjectConfigurationRequest request, IClasspathDescriptor classpath, IProgressMonitor monitor) throws CoreException {
    }

    private IPath getMetainfPath(IMavenProjectFacade facade, List<MojoExecution> executions, IProgressMonitor monitor) throws CoreException {
        IMaven maven = MavenPlugin.getMaven();
        for (MojoExecution execution : executions) {
            String manifestParameter;
            Plugin plugin = execution.getPlugin();
            MavenProject project = facade.getMavenProject(monitor);
            File location = (File)maven.getMojoParameterValue(project, execution, manifestParameter = this.isBND(plugin) ? BND_PARAM_MANIFESTLOCATION : FELIX_PARAM_MANIFESTLOCATION, File.class, monitor);
            if (location == null) continue;
            return facade.getProjectRelativePath(location.getAbsolutePath());
        }
        return null;
    }

    private boolean isBND(Plugin plugin) {
        return plugin != null && "bnd-maven-plugin".equals(plugin.getArtifactId());
    }

    private boolean isFelix(Plugin plugin) {
        return plugin != null && "org.apache.felix".equals(plugin.getGroupId()) && "maven-bundle-plugin".equals(plugin.getArtifactId());
    }

    public boolean hasConfigurationChanged(IMavenProjectFacade newFacade, ILifecycleMappingConfiguration oldProjectConfiguration, MojoExecutionKey key, IProgressMonitor monitor) {
        return false;
    }

    public AbstractBuildParticipant getBuildParticipant(IMavenProjectFacade projectFacade, MojoExecution execution, IPluginExecutionMetadata executionMetadata) {
        if (this.isFelix(execution.getPlugin()) && this.isFelixManifestGoal(execution) || this.isBND(execution.getPlugin()) && this.isBNDBundleGoal(execution)) {
            return new MojoExecutionBuildParticipant(execution, true, true);
        }
        return super.getBuildParticipant(projectFacade, execution, executionMetadata);
    }
}

