/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.mavenarchiver.internal;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.stream.IntStream;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.lifecycle.MavenExecutionPlan;
import org.apache.maven.model.Organization;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.Mojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.util.ReflectionUtils;
import org.codehaus.plexus.util.WriterFactory;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomUtils;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.ArtifactKey;
import org.eclipse.m2e.core.embedder.IMavenExecutionContext;
import org.eclipse.m2e.core.internal.M2EUtils;
import org.eclipse.m2e.core.lifecyclemapping.model.IPluginExecutionMetadata;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.MavenProjectChangedEvent;
import org.eclipse.m2e.core.project.configurator.AbstractBuildParticipant;
import org.eclipse.m2e.core.project.configurator.AbstractProjectConfigurator;
import org.eclipse.m2e.core.project.configurator.MojoExecutionKey;
import org.eclipse.m2e.core.project.configurator.ProjectConfigurationRequest;

public abstract class AbstractMavenArchiverConfigurator
extends AbstractProjectConfigurator {
    private static final String POM_XML = "pom.xml";
    private static final String GET_MANIFEST = "getManifest";
    private static final String MANIFEST_ENTRIES_NODE = "manifestEntries";
    private static final String ARCHIVE_NODE = "archive";
    private static final String CREATED_BY_ENTRY = "Created-By";
    private static final String MAVEN_ARCHIVER_CLASS = "org.apache.maven.archiver.MavenArchiver";
    private static final String M2E = "Maven Integration for Eclipse";
    private static final String GENERATED_BY_M2E = "Generated by Maven Integration for Eclipse";
    private static final boolean JDT_SUPPORTS_MODULES;

    static {
        boolean isModuleSupportAvailable = false;
        try {
            Class.forName("org.eclipse.jdt.core.IModuleDescription");
            isModuleSupportAvailable = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        JDT_SUPPORTS_MODULES = isModuleSupportAvailable;
    }

    public void configure(ProjectConfigurationRequest request, IProgressMonitor monitor) throws CoreException {
    }

    protected abstract MojoExecutionKey getExecutionKey();

    public AbstractBuildParticipant getBuildParticipant(final IMavenProjectFacade projectFacade, MojoExecution execution, IPluginExecutionMetadata executionMetadata) {
        MojoExecutionKey key = this.getExecutionKey();
        if (execution.getArtifactId().equals(key.artifactId()) && execution.getGoal().equals(key.goal())) {
            return new AbstractBuildParticipant(){

                public Set<IProject> build(int kind, IProgressMonitor monitor) throws Exception {
                    IResourceDelta delta = this.getDelta(projectFacade.getProject());
                    boolean forceManifest = false;
                    if (delta != null) {
                        ManifestDeltaVisitor visitor = new ManifestDeltaVisitor();
                        delta.accept((IResourceDeltaVisitor)visitor);
                        forceManifest = visitor.foundManifest;
                    }
                    boolean forcePom = this.getBuildContext().hasDelta(AbstractMavenArchiverConfigurator.POM_XML);
                    AbstractMavenArchiverConfigurator.this.mavenProjectChanged(projectFacade, null, forceManifest || forcePom, monitor);
                    if (!forcePom) {
                        boolean bl = forcePom = !AbstractMavenArchiverConfigurator.this.getOutputPomXML(projectFacade).exists();
                    }
                    if (forcePom) {
                        AbstractMavenArchiverConfigurator.this.writePom(projectFacade, monitor);
                    }
                    return Collections.emptySet();
                }
            };
        }
        return null;
    }

    public void mavenProjectChanged(MavenProjectChangedEvent event, IProgressMonitor monitor) throws CoreException {
        IMavenProjectFacade oldFacade = event.getOldMavenProject();
        IMavenProjectFacade newFacade = event.getMavenProject();
        if (oldFacade == null && newFacade == null) {
            return;
        }
        this.mavenProjectChanged(newFacade, oldFacade, false, monitor);
    }

    protected void mavenProjectChanged(IMavenProjectFacade newFacade, IMavenProjectFacade oldFacade, boolean forceGeneration, IProgressMonitor monitor) throws CoreException {
        IContainer outputdir = this.getBuildOutputDir(newFacade);
        IFile manifest = outputdir.getFile((IPath)Path.forPosix((String)"META-INF/MANIFEST.MF"));
        if (forceGeneration || this.needsNewManifest(manifest, oldFacade, newFacade)) {
            this.generateManifest(newFacade, manifest, monitor);
            this.refresh(outputdir, monitor);
        }
    }

    protected abstract IPath getOutputDir(IMavenProjectFacade var1);

    private void refresh(IContainer outputdir, IProgressMonitor monitor) throws CoreException {
        if (outputdir.exists()) {
            try {
                outputdir.refreshLocal(2, monitor);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected boolean needsNewManifest(IFile manifest, IMavenProjectFacade oldFacade, IMavenProjectFacade newFacade) {
        if (!manifest.exists()) {
            return true;
        }
        if (oldFacade == null || oldFacade.getMavenProject() == null) {
            return false;
        }
        MavenProject newProject = newFacade.getMavenProject();
        MavenProject oldProject = oldFacade.getMavenProject();
        if (this.dependenciesChanged(oldProject.getArtifacts(), newProject.getArtifacts())) {
            return true;
        }
        Xpp3Dom oldArchiveConfig = this.getArchiveConfiguration(oldProject);
        Xpp3Dom newArchiveConfig = this.getArchiveConfiguration(newProject);
        if (!Objects.equals(newArchiveConfig, oldArchiveConfig)) {
            return true;
        }
        if (!newProject.getName().equals(oldProject.getName())) {
            return true;
        }
        Optional<String> oldOrgaName = Optional.ofNullable(oldProject.getOrganization()).map(Organization::getName);
        Optional<String> newOrgaName = Optional.ofNullable(newProject.getOrganization()).map(Organization::getName);
        return !newOrgaName.equals(oldOrgaName);
    }

    private boolean dependenciesChanged(Collection<Artifact> artifacts, Collection<Artifact> others) {
        if (artifacts == others || artifacts == null || others == null) {
            return false;
        }
        if (artifacts.size() != others.size()) {
            return true;
        }
        Iterator<Artifact> otherIterator = others.iterator();
        return artifacts.stream().anyMatch(a -> !this.areEqual((Artifact)a, (Artifact)otherIterator.next()));
    }

    private boolean areEqual(Artifact dep, Artifact other) {
        if (dep == other) {
            return true;
        }
        if (dep == null || other == null) {
            return false;
        }
        return dep.toString().equals(other.toString()) && dep.isOptional() == other.isOptional();
    }

    private Xpp3Dom getArchiveConfiguration(MavenProject mavenProject) {
        Plugin plugin = mavenProject.getPlugin(this.getPluginKey());
        if (plugin == null) {
            return null;
        }
        Xpp3Dom pluginConfig = (Xpp3Dom)plugin.getConfiguration();
        if (pluginConfig == null) {
            return null;
        }
        return pluginConfig.getChild(ARCHIVE_NODE);
    }

    public void generateManifest(IMavenProjectFacade mavenFacade, IFile manifest, IProgressMonitor monitor) throws CoreException {
        MavenProject mavenProject = mavenFacade.getMavenProject();
        Set originalArtifacts = mavenProject.getArtifacts();
        boolean parentHierarchyLoaded = this.loadParentHierarchy(mavenFacade, monitor);
        try {
            try {
                this.markerManager.deleteMarkers((IResource)mavenFacade.getPom(), "org.eclipse.m2e.core.maven2Problem.mavenarchiver.error");
                IMavenExecutionContext context = mavenFacade.createExecutionContext();
                context.getExecutionRequest().setOffline(MavenPlugin.getMavenConfiguration().isOffline());
                context.execute((innerContext, innerMonitor) -> {
                    ClassLoader originalTCL = Thread.currentThread().getContextClassLoader();
                    try {
                        MavenExecutionPlan executionPlan;
                        MojoExecution mojoExecution;
                        ClassRealm projectRealm = mavenProject.getClassRealm();
                        if (projectRealm != null && projectRealm != originalTCL) {
                            Thread.currentThread().setContextClassLoader((ClassLoader)projectRealm);
                        }
                        if ((mojoExecution = this.getExecution(executionPlan = this.maven.calculateExecutionPlan(mavenProject, List.of("package"), true, monitor), this.getExecutionKey())) == null) {
                            return null;
                        }
                        try {
                            IFolder destinationFolder = (IFolder)manifest.getParent();
                            M2EUtils.createFolder((IFolder)destinationFolder, (boolean)true, (IProgressMonitor)monitor);
                            mavenProject.setArtifacts(this.fixArtifactFileNames(mavenFacade));
                            this.reflectManifestGeneration(mavenFacade, mojoExecution, innerContext.getSession(), new File(manifest.getLocation().toOSString()));
                        }
                        catch (Exception e) {
                            throw new CoreException(Status.error((String)"Something goes wrong!", (Throwable)e));
                        }
                    }
                    finally {
                        Thread.currentThread().setContextClassLoader(originalTCL);
                    }
                    return null;
                }, monitor);
            }
            catch (Exception ex) {
                this.markerManager.addErrorMarkers((IResource)mavenFacade.getPom(), "org.eclipse.m2e.core.maven2Problem.mavenarchiver.error", ex);
                mavenProject.setArtifacts(originalArtifacts);
                if (parentHierarchyLoaded) {
                    mavenProject.setParent(null);
                }
            }
        }
        finally {
            mavenProject.setArtifacts(originalArtifacts);
            if (parentHierarchyLoaded) {
                mavenProject.setParent(null);
            }
        }
    }

    private void reflectManifestGeneration(IMavenProjectFacade facade, MojoExecution mojoExecution, MavenSession session, File manifestFile) throws CoreException, ReflectiveOperationException, IOException {
        ClassLoader loader = null;
        Mojo mojo = null;
        Xpp3Dom originalConfig = mojoExecution.getConfiguration();
        Xpp3Dom customConfig = Xpp3DomUtils.mergeXpp3Dom((Xpp3Dom)new Xpp3Dom("configuration"), (Xpp3Dom)originalConfig);
        MavenProject mavenProject = facade.getMavenProject();
        IProject project = facade.getProject();
        this.customizeManifest(customConfig);
        mojoExecution.setConfiguration(customConfig);
        mojo = (Mojo)this.maven.getConfiguredMojo(session, mojoExecution, Mojo.class);
        Class<?> mojoClass = mojo.getClass();
        loader = mojoClass.getClassLoader();
        try {
            Object archiver = this.getArchiverInstance(mojoClass, mojo, project);
            if (archiver != null) {
                Field archiveConfigurationField = this.findField(this.getArchiveConfigurationFieldName(), mojoClass);
                Object archiveConfiguration = AbstractMavenArchiverConfigurator.getValue(mojo, archiveConfigurationField);
                Object mavenArchiver = this.getMavenArchiver(archiver, manifestFile, loader);
                Object manifest = this.getManifest(session, mavenProject, archiveConfiguration, mavenArchiver);
                Object userManifest = this.getProvidedManifest(manifest.getClass(), archiveConfiguration);
                this.mergeManifests(manifest, userManifest);
                this.writeManifest(manifestFile, manifest);
            }
        }
        finally {
            mojoExecution.setConfiguration(originalConfig);
            this.maven.releaseMojo((Object)mojo, mojoExecution);
        }
    }

    private void writeManifest(File manifestFile, Object manifest) throws UnsupportedEncodingException, FileNotFoundException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Method write = this.getWriteMethod(manifest);
        if (write != null) {
            Throwable throwable = null;
            Object var5_6 = null;
            try (PrintWriter printWriter = new PrintWriter(WriterFactory.newWriter((File)manifestFile, (String)"UTF-8"));){
                write.invoke(manifest, printWriter);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    private Object getManifest(MavenSession session, MavenProject mavenProject, Object archiveConfiguration, Object mavenArchiver) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Object manifest = null;
        Class<?> archiveConfigClass = archiveConfiguration.getClass();
        try {
            Method getManifest = mavenArchiver.getClass().getMethod(GET_MANIFEST, MavenSession.class, MavenProject.class, archiveConfigClass);
            manifest = getManifest.invoke(mavenArchiver, session, mavenProject, archiveConfiguration);
        }
        catch (NoSuchMethodException nsme) {
            Method getManifest = mavenArchiver.getClass().getMethod(GET_MANIFEST, MavenProject.class, archiveConfigClass);
            manifest = getManifest.invoke(mavenArchiver, mavenProject, archiveConfiguration);
        }
        return manifest;
    }

    private Object getArchiverInstance(Class<? extends Mojo> mojoClass, Mojo mojo, IProject project) throws IllegalAccessException {
        Field archiverField = this.findField(this.getArchiverFieldName(), mojoClass);
        if (archiverField == null) {
            Field archiversField = this.findField("archivers", mojoClass);
            if (archiversField != null) {
                Map archivers = (Map)AbstractMavenArchiverConfigurator.getValue(mojo, archiversField);
                String key = this.isModular(project) ? "mjar" : "jar";
                return archivers.get(key);
            }
        } else {
            return AbstractMavenArchiverConfigurator.getValue(mojo, archiverField);
        }
        return null;
    }

    private static <T> T getValue(Object obj, Field field) throws IllegalAccessException {
        field.setAccessible(true);
        return (T)field.get(obj);
    }

    private boolean isModular(IProject project) {
        try {
            if (JDT_SUPPORTS_MODULES && project.hasNature("org.eclipse.jdt.core.javanature")) {
                IJavaProject jp = JavaCore.create((IProject)project);
                return jp.getModuleDescription() != null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private Method getWriteMethod(Object manifest) {
        Method[] methodArray = manifest.getClass().getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?>[] params;
            Method m = methodArray[n2];
            if ("write".equals(m.getName()) && (params = m.getParameterTypes()).length == 1 && Writer.class.isAssignableFrom(params[0])) {
                return m;
            }
            ++n2;
        }
        return null;
    }

    private boolean loadParentHierarchy(IMavenProjectFacade facade, IProgressMonitor monitor) throws CoreException {
        MavenProject mavenProject = facade.getMavenProject();
        try {
            if (mavenProject.getModel().getParent() == null || mavenProject.getParent() != null) {
                return false;
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        return (Boolean)facade.createExecutionContext().execute(mavenProject, (context, monitor2) -> {
            boolean loadedParent = false;
            MavenProject current = mavenProject;
            while (current != null && current.getModel().getParent() != null) {
                if (monitor.isCanceled()) break;
                String parentPath = current.getModel().getParent().getRelativePath();
                MavenProject parentProject = this.maven.readProject(new File(current.getBasedir(), parentPath), monitor);
                if (parentProject != null) {
                    current.setParent(parentProject);
                    loadedParent = true;
                }
                current = parentProject;
            }
            return loadedParent;
        }, monitor);
    }

    private Object getProvidedManifest(Class<?> manifestClass, Object archiveConfiguration) throws SecurityException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        File manifestFile;
        block12: {
            Method getManifestFile = archiveConfiguration.getClass().getMethod("getManifestFile", new Class[0]);
            manifestFile = (File)getManifestFile.invoke(archiveConfiguration, new Object[0]);
            if (manifestFile != null && manifestFile.exists() && manifestFile.canRead()) break block12;
            return null;
        }
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (FileReader reader = new FileReader(manifestFile);){
                return manifestClass.getConstructor(Reader.class).newInstance(reader);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | NoSuchMethodException exception) {
            return null;
        }
    }

    private void mergeManifests(Object manifest, Object sourceManifest) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (sourceManifest == null) {
            return;
        }
        if (manifest instanceof Manifest var3_4 && ( instanceOfPatternExpressionValue = sourceManifest) instanceof Manifest var4_6) {
            this.merge((Manifest)mani, (Manifest)sourceMani, false);
        } else {
            Method merge = manifest.getClass().getMethod("merge", sourceManifest.getClass());
            merge.invoke(manifest, sourceManifest);
        }
    }

    private void merge(Manifest target, Manifest other, boolean overwriteMain) {
        if (other != null) {
            Attributes mainAttributes = target.getMainAttributes();
            if (overwriteMain) {
                mainAttributes.clear();
                mainAttributes.putAll((Map<?, ?>)other.getMainAttributes());
            } else {
                mainAttributes.putAll((Map<?, ?>)other.getMainAttributes());
            }
            other.getEntries().forEach((key, otherSection) -> {
                Attributes ourSection = target.getAttributes((String)key);
                if (ourSection == null) {
                    if (otherSection != null) {
                        target.getEntries().put((String)key, (Attributes)otherSection.clone());
                    }
                } else {
                    ourSection.putAll((Map<?, ?>)otherSection);
                }
            });
        }
    }

    protected abstract String getArchiverFieldName();

    protected String getArchiveConfigurationFieldName() {
        return ARCHIVE_NODE;
    }

    private Set<Artifact> fixArtifactFileNames(IMavenProjectFacade facade) throws IOException, CoreException {
        Set artifacts = facade.getMavenProject().getArtifacts();
        if (artifacts == null) {
            return null;
        }
        LinkedHashSet<Artifact> newArtifacts = new LinkedHashSet<Artifact>(artifacts.size());
        ArtifactRepository localRepo = MavenPlugin.getMaven().getLocalRepository();
        for (Artifact a : artifacts) {
            Artifact artifact;
            if (a.getFile().isDirectory() || POM_XML.equals(a.getFile().getName())) {
                artifact = new DefaultArtifact(a.getGroupId(), a.getArtifactId(), a.getVersion(), a.getScope(), a.getType(), a.getClassifier(), a.getArtifactHandler());
                artifact.setFile(this.fakeFile(localRepo, a));
            } else {
                artifact = a;
            }
            newArtifacts.add(artifact);
        }
        return newArtifacts;
    }

    private void customizeManifest(Xpp3Dom customConfig) {
        Xpp3Dom createdByNode;
        Xpp3Dom manifestEntriesNode;
        if (customConfig == null) {
            return;
        }
        Xpp3Dom archiveNode = customConfig.getChild(ARCHIVE_NODE);
        if (archiveNode == null) {
            archiveNode = new Xpp3Dom(ARCHIVE_NODE);
            customConfig.addChild(archiveNode);
        }
        if ((manifestEntriesNode = archiveNode.getChild(MANIFEST_ENTRIES_NODE)) == null) {
            manifestEntriesNode = new Xpp3Dom(MANIFEST_ENTRIES_NODE);
            archiveNode.addChild(manifestEntriesNode);
        }
        if ((createdByNode = manifestEntriesNode.getChild(CREATED_BY_ENTRY)) == null) {
            createdByNode = new Xpp3Dom(CREATED_BY_ENTRY);
            createdByNode.setValue(M2E);
            manifestEntriesNode.addChild(createdByNode);
        }
    }

    private Field findField(String name, Class<?> clazz) {
        return ReflectionUtils.getFieldByNameIncludingSuperclasses((String)name, clazz);
    }

    private Object getMavenArchiver(Object archiver, File manifestFile, ClassLoader loader) throws ReflectiveOperationException {
        Class<?> mavenArchiverClass = Class.forName(MAVEN_ARCHIVER_CLASS, false, loader);
        Object mavenArchiver = mavenArchiverClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        Method setArchiver = AbstractMavenArchiverConfigurator.findMethodForArgumentTypes(mavenArchiverClass, "setArchiver", archiver.getClass());
        setArchiver.invoke(mavenArchiver, archiver);
        Method setOutputFile = mavenArchiverClass.getMethod("setOutputFile", File.class);
        setOutputFile.invoke(mavenArchiver, manifestFile);
        return mavenArchiver;
    }

    private static Method findMethodForArgumentTypes(Class<?> clazz, String methodName, Class<?> ... parameterTypes) throws NoSuchMethodException, SecurityException {
        return Arrays.stream(clazz.getMethods()).filter(m -> methodName.equals(m.getName()) && m.getParameterCount() == parameterTypes.length).filter(m -> IntStream.range(0, parameterTypes.length).mapToObj(i -> m.getParameterTypes()[i].isAssignableFrom(parameterTypes[i])).allMatch(b -> b)).findAny().orElseThrow(() -> new NoSuchMethodException("Method " + methodName + "() not found"));
    }

    private String getPluginKey() {
        MojoExecutionKey execution = this.getExecutionKey();
        return String.valueOf(execution.groupId()) + ":" + execution.artifactId();
    }

    private MojoExecution getExecution(MavenExecutionPlan executionPlan, MojoExecutionKey key) {
        for (MojoExecution execution : executionPlan.getMojoExecutions()) {
            if (!key.artifactId().equals(execution.getArtifactId()) || !key.groupId().equals(execution.getGroupId()) || !key.goal().equals(execution.getGoal())) continue;
            return execution;
        }
        return null;
    }

    private File fakeFile(ArtifactRepository localRepo, Artifact artifact) throws IOException {
        java.nio.file.Path fakeRepo = Files.createTempDirectory("fakerepo", new FileAttribute[0]);
        java.nio.file.Path fakeFile = fakeRepo.resolve(localRepo.pathOf(artifact));
        Files.createDirectories(fakeFile.getParent(), new FileAttribute[0]);
        if (!Files.exists(fakeFile, new LinkOption[0])) {
            Files.createFile(fakeFile, new FileAttribute[0]);
        }
        return fakeFile.toFile();
    }

    private void writePom(IMavenProjectFacade facade, IProgressMonitor monitor) throws CoreException {
        Object var10_14;
        Throwable throwable;
        IProject project = facade.getProject();
        ArtifactKey mavenProject = facade.getArtifactKey();
        IFile pom = this.getOutputPomXML(facade);
        IFolder output = (IFolder)pom.getParent();
        M2EUtils.createFolder((IFolder)output, (boolean)true, (IProgressMonitor)monitor);
        Properties properties = new Properties();
        properties.put("groupId", mavenProject.groupId());
        properties.put("artifactId", mavenProject.artifactId());
        properties.put("version", mavenProject.version());
        properties.put("m2e.projectName", project.getName());
        properties.put("m2e.projectLocation", project.getLocation().toOSString());
        IFile pomProperties = output.getFile("pom.properties");
        try {
            throwable = null;
            var10_14 = null;
            try (OutputStream out = Files.newOutputStream(AbstractMavenArchiverConfigurator.getLocationPath((IResource)pomProperties), new OpenOption[0]);){
                properties.store(out, GENERATED_BY_M2E);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        pomProperties.refreshLocal(0, monitor);
        try {
            throwable = null;
            var10_14 = null;
            try (InputStream is = facade.getPom().getContents();){
                Files.copy(is, AbstractMavenArchiverConfigurator.getLocationPath((IResource)pom), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        pom.refreshLocal(0, monitor);
    }

    private static java.nio.file.Path getLocationPath(IResource pom) {
        return java.nio.file.Path.of(pom.getLocationURI());
    }

    private IContainer getBuildOutputDir(IMavenProjectFacade facade) {
        IWorkspaceRoot root = facade.getProject().getWorkspace().getRoot();
        IPath outputDir = this.getOutputDir(facade);
        return outputDir.segmentCount() == 1 ? root.getProject(outputDir.segment(0)) : root.getFolder(outputDir);
    }

    private IFile getOutputPomXML(IMavenProjectFacade facade) {
        ArtifactKey project = facade.getArtifactKey();
        return this.getBuildOutputDir(facade).getFile((IPath)Path.forPosix((String)("META-INF/maven/" + project.groupId() + "/" + project.artifactId() + "/" + POM_XML)));
    }

    private class ManifestDeltaVisitor
    implements IResourceDeltaVisitor {
        private static final String MANIFEST = "MANIFEST.MF";
        boolean foundManifest;

        private ManifestDeltaVisitor() {
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            if (delta.getResource() instanceof IFile && MANIFEST.equals(delta.getResource().getName())) {
                this.foundManifest = true;
            }
            return !this.foundManifest;
        }
    }
}

