/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutionException;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.text.IDocument;
import org.eclipse.lsp4e.ContentTypeToLanguageServerDefinition;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.LanguageServerWrapper;
import org.eclipse.lsp4e.LanguageServersRegistry;
import org.eclipse.lsp4e.server.StreamConnectionProvider;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.services.LanguageServer;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.part.FileEditorInput;

public class LanguageServiceAccessor {
    private static final Set<LanguageServerWrapper> startedServers = new CopyOnWriteArraySet<LanguageServerWrapper>();
    private static final Map<StreamConnectionProvider, LanguageServersRegistry.LanguageServerDefinition> providersToLSDefinitions = new HashMap<StreamConnectionProvider, LanguageServersRegistry.LanguageServerDefinition>();

    private LanguageServiceAccessor() {
    }

    public static void clearStartedServers() {
        startedServers.removeIf(server -> {
            server.stop();
            return true;
        });
    }

    public static @NonNull List<CompletableFuture<LanguageServer>> getInitializedLanguageServers(@NonNull IFile file, @Nullable Predicate<ServerCapabilities> request) throws IOException {
        return LanguageServiceAccessor.getLSWrappers(file, request).stream().map(LanguageServerWrapper::getInitializedServer).collect(Collectors.toList());
    }

    public static void disableLanguageServerContentType(@NonNull ContentTypeToLanguageServerDefinition contentTypeToLSDefinition) {
        IContentType contentType;
        Optional<LanguageServerWrapper> result = startedServers.stream().filter(server -> server.serverDefinition.equals(contentTypeToLSDefinition.getValue())).findFirst();
        if (result.isPresent() && (contentType = (IContentType)contentTypeToLSDefinition.getKey()) != null) {
            result.get().disconnectContentType(contentType);
        }
    }

    public static boolean isStillRunning(LanguageServer server) {
        return startedServers.stream().anyMatch(wrapper -> wrapper.isWrapperFor(server) && wrapper.isActive());
    }

    public static void enableLanguageServerContentType(@NonNull ContentTypeToLanguageServerDefinition contentTypeToLSDefinition, @NonNull IEditorReference[] editors) {
        IContentType contentType = (IContentType)contentTypeToLSDefinition.getKey();
        if (contentType == null) {
            return;
        }
        LanguageServersRegistry.LanguageServerDefinition lsDefinition = (LanguageServersRegistry.LanguageServerDefinition)contentTypeToLSDefinition.getValue();
        if (lsDefinition == null) {
            return;
        }
        IEditorReference[] iEditorReferenceArray = editors;
        int n = editors.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference editor = iEditorReferenceArray[n2];
            try {
                IFile editorFile;
                IContentDescription contentDesc;
                if (editor.getEditorInput() instanceof FileEditorInput && (contentDesc = (editorFile = ((FileEditorInput)editor.getEditorInput()).getFile()).getContentDescription()) != null && contentType.equals(contentDesc.getContentType()) && contentTypeToLSDefinition.isEnabled()) {
                    LanguageServiceAccessor.getInitializedLanguageServer(editorFile, lsDefinition, (ServerCapabilities capabilities) -> true);
                }
            }
            catch (Exception e) {
                LanguageServerPlugin.logError(e);
            }
            ++n2;
        }
    }

    @Deprecated
    public static LanguageServer getLanguageServer(@NonNull IFile file, @NonNull LanguageServersRegistry.LanguageServerDefinition lsDefinition, Predicate<ServerCapabilities> capabilitiesPredicate) throws IOException {
        LanguageServerWrapper wrapper = LanguageServiceAccessor.getLSWrapper(file.getProject(), lsDefinition, file.getFullPath());
        if (LanguageServiceAccessor.capabilitiesComply(wrapper, capabilitiesPredicate)) {
            wrapper.connect(file, null);
            return wrapper.getServer();
        }
        return null;
    }

    public static CompletableFuture<LanguageServer> getInitializedLanguageServer(@NonNull IFile file, @NonNull LanguageServersRegistry.LanguageServerDefinition lsDefinition, Predicate<ServerCapabilities> capabilitiesPredicate) throws IOException {
        LanguageServerWrapper wrapper = LanguageServiceAccessor.getLSWrapper(file.getProject(), lsDefinition, file.getFullPath());
        if (LanguageServiceAccessor.capabilitiesComply(wrapper, capabilitiesPredicate)) {
            return wrapper.getInitializedServer();
        }
        return null;
    }

    public static CompletableFuture<LanguageServer> getInitializedLanguageServer(@NonNull IDocument document, @NonNull LanguageServersRegistry.LanguageServerDefinition lsDefinition, Predicate<ServerCapabilities> capabilitiesPredicate) throws IOException {
        IPath initialPath = LSPEclipseUtils.toPath(document);
        LanguageServerWrapper wrapper = LanguageServiceAccessor.getLSWrapperForConnection(document, lsDefinition, initialPath);
        if (LanguageServiceAccessor.capabilitiesComply(wrapper, capabilitiesPredicate)) {
            return wrapper.getInitializedServer();
        }
        return null;
    }

    private static boolean capabilitiesComply(LanguageServerWrapper wrapper, Predicate<ServerCapabilities> capabilitiesPredicate) {
        return capabilitiesPredicate == null || wrapper.getServerCapabilities() == null || capabilitiesPredicate.test(wrapper.getServerCapabilities());
    }

    public static @NonNull Collection<LanguageServerWrapper> getLSWrappers(@NonNull IFile file, @Nullable Predicate<ServerCapabilities> request) throws IOException {
        IProject project = file.getProject();
        if (project == null) {
            return Collections.emptyList();
        }
        LinkedHashSet<LanguageServerWrapper> res = new LinkedHashSet<LanguageServerWrapper>(LanguageServiceAccessor.getMatchingStartedWrappers(file, request));
        List<IContentType> directContentTypes = LSPEclipseUtils.getFileContentTypes(file);
        ArrayDeque<IContentType> contentTypesToProcess = new ArrayDeque<IContentType>(directContentTypes);
        HashSet<IContentType> processedContentTypes = new HashSet<IContentType>(directContentTypes.size());
        LanguageServersRegistry lsRegistry = LanguageServersRegistry.getInstance();
        while (!contentTypesToProcess.isEmpty()) {
            IContentType contentType = contentTypesToProcess.poll();
            if (contentType == null || processedContentTypes.contains(contentType)) continue;
            for (ContentTypeToLanguageServerDefinition mapping : lsRegistry.findProviderFor(contentType)) {
                LanguageServerWrapper wrapper;
                LanguageServersRegistry.LanguageServerDefinition serverDefinition;
                if (!mapping.isEnabled() || (serverDefinition = (LanguageServersRegistry.LanguageServerDefinition)mapping.getValue()) == null || res.contains(wrapper = LanguageServiceAccessor.getLSWrapper(project, serverDefinition, file.getFullPath())) || !LanguageServiceAccessor.capabilitiesComply(wrapper, request)) continue;
                res.add(wrapper);
            }
            if (contentType.getBaseType() != null) {
                contentTypesToProcess.add(contentType.getBaseType());
            }
            processedContentTypes.add(contentType);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static @NonNull Collection<LanguageServerWrapper> getLSWrappers(@NonNull IDocument document) {
        URI uri = LSPEclipseUtils.toUri(document);
        if (uri == null) {
            return Collections.emptyList();
        }
        LanguageServersRegistry lsRegistry = LanguageServersRegistry.getInstance();
        Predicate<LanguageServerWrapper> selectServersForDocument = wrapper -> {
            try {
                return wrapper.isConnectedTo(uri) || lsRegistry.matches(document, wrapper.serverDefinition) && wrapper.canOperate(document);
            }
            catch (Exception ex) {
                LanguageServerPlugin.logError(ex);
                return false;
            }
        };
        @NonNull LinkedHashSet res = startedServers.stream().filter(selectServersForDocument).collect(Collectors.toCollection(LinkedHashSet::new));
        List<IContentType> directContentTypes = LSPEclipseUtils.getDocumentContentTypes(document);
        ArrayDeque<IContentType> contentTypesToProcess = new ArrayDeque<IContentType>(directContentTypes);
        HashSet<IContentType> processedContentTypes = new HashSet<IContentType>(directContentTypes.size());
        Path path = new Path(uri.getPath());
        IFile file = LSPEclipseUtils.getFile(document);
        while (!contentTypesToProcess.isEmpty()) {
            IContentType contentType = contentTypesToProcess.poll();
            if (contentType == null || processedContentTypes.contains(contentType)) continue;
            for (ContentTypeToLanguageServerDefinition mapping : lsRegistry.findProviderFor(contentType)) {
                LanguageServersRegistry.LanguageServerDefinition serverDefinition;
                if (!mapping.isEnabled() || (serverDefinition = (LanguageServersRegistry.LanguageServerDefinition)mapping.getValue()) == null) continue;
                Predicate<LanguageServerWrapper> selectServersWithEqualDefinition = wrapper -> wrapper.serverDefinition.equals(serverDefinition);
                if (res.stream().anyMatch(selectServersWithEqualDefinition)) continue;
                Set<LanguageServerWrapper> set = startedServers;
                synchronized (set) {
                    startedServers.stream().filter(selectServersForDocument).forEach(res::add);
                    if (res.stream().anyMatch(selectServersWithEqualDefinition)) {
                        continue;
                    }
                    IProject fileProject = file != null ? file.getProject() : null;
                    LanguageServerWrapper wrapper2 = fileProject != null ? new LanguageServerWrapper(fileProject, serverDefinition) : new LanguageServerWrapper(serverDefinition, (IPath)path);
                    startedServers.add(wrapper2);
                    res.add(wrapper2);
                }
            }
            if (contentType.getBaseType() != null) {
                contentTypesToProcess.add(contentType.getBaseType());
            }
            processedContentTypes.add(contentType);
        }
        return res;
    }

    public static LanguageServerWrapper getLSWrapper(@NonNull IProject project, @NonNull LanguageServersRegistry.LanguageServerDefinition serverDefinition) throws IOException {
        return LanguageServiceAccessor.getLSWrapper(project, serverDefinition, null);
    }

    @Deprecated
    public static LanguageServerWrapper getLSWrapperForConnection(@NonNull IProject project, @NonNull LanguageServersRegistry.LanguageServerDefinition serverDefinition) throws IOException {
        return LanguageServiceAccessor.getLSWrapper(project, serverDefinition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static LanguageServerWrapper getLSWrapper(@Nullable IProject project, @NonNull LanguageServersRegistry.LanguageServerDefinition serverDefinition, @Nullable IPath initialPath) throws IOException {
        Predicate<LanguageServerWrapper> serverSelector = wrapper -> project != null && wrapper.canOperate(project) && wrapper.serverDefinition.equals(serverDefinition);
        Optional<LanguageServerWrapper> matchingServer = startedServers.stream().filter(serverSelector).findFirst();
        if (matchingServer.isPresent()) {
            return matchingServer.get();
        }
        Set<LanguageServerWrapper> set = startedServers;
        synchronized (set) {
            matchingServer = startedServers.stream().filter(serverSelector).findFirst();
            if (matchingServer.isPresent()) {
                return matchingServer.get();
            }
            LanguageServerWrapper wrapper2 = project != null ? new LanguageServerWrapper(project, serverDefinition) : new LanguageServerWrapper(serverDefinition, initialPath);
            wrapper2.start();
            startedServers.add(wrapper2);
            return wrapper2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static LanguageServerWrapper getLSWrapperForConnection(@NonNull IDocument document, @NonNull LanguageServersRegistry.LanguageServerDefinition serverDefinition, @Nullable IPath initialPath) throws IOException {
        Predicate<LanguageServerWrapper> serverSelector = wrapper -> wrapper.canOperate(document) && wrapper.serverDefinition.equals(serverDefinition);
        Optional<LanguageServerWrapper> matchingServer = startedServers.stream().filter(serverSelector).findFirst();
        if (matchingServer.isPresent()) {
            return matchingServer.get();
        }
        Set<LanguageServerWrapper> set = startedServers;
        synchronized (set) {
            matchingServer = startedServers.stream().filter(serverSelector).findFirst();
            if (matchingServer.isPresent()) {
                return matchingServer.get();
            }
            LanguageServerWrapper wrapper2 = new LanguageServerWrapper(serverDefinition, initialPath);
            wrapper2.start();
            startedServers.add(wrapper2);
            return wrapper2;
        }
    }

    private static Collection<LanguageServerWrapper> getMatchingStartedWrappers(@NonNull IFile file, @Nullable Predicate<ServerCapabilities> request) {
        LanguageServersRegistry lsRegistry = LanguageServersRegistry.getInstance();
        IProject project = file.getProject();
        URI fileURI = file.getLocationURI();
        return startedServers.stream().filter(wrapper -> wrapper.isActive() && wrapper.isConnectedTo(fileURI) || lsRegistry.matches(file, wrapper.serverDefinition) && project != null && wrapper.canOperate(project)).filter(wrapper -> request == null || wrapper.getServerCapabilities() == null || request.test(wrapper.getServerCapabilities())).collect(Collectors.toList());
    }

    public static @NonNull List<@NonNull LanguageServer> getActiveLanguageServers(Predicate<ServerCapabilities> request) {
        return LanguageServiceAccessor.getLanguageServers(null, request, true);
    }

    public static @NonNull List<@NonNull LanguageServer> getLanguageServers(@NonNull IProject project, Predicate<ServerCapabilities> request) {
        return LanguageServiceAccessor.getLanguageServers(project, request, false);
    }

    public static @NonNull List<@NonNull LanguageServer> getLanguageServers(@Nullable IProject project, Predicate<ServerCapabilities> request, boolean onlyActiveLS) {
        ArrayList<@NonNull LanguageServer> serverInfos = new ArrayList<LanguageServer>();
        for (LanguageServerWrapper wrapper : startedServers) {
            LanguageServer server;
            if (onlyActiveLS && !wrapper.isActive() || project != null && !wrapper.canOperate(project) || (server = wrapper.getServer()) == null || !LanguageServiceAccessor.capabilitiesComply(wrapper, request)) continue;
            serverInfos.add(server);
        }
        return serverInfos;
    }

    protected static LanguageServersRegistry.LanguageServerDefinition getLSDefinition(@NonNull StreamConnectionProvider provider) {
        return providersToLSDefinitions.get(provider);
    }

    public static @NonNull List<@NonNull LSPDocumentInfo> getLSPDocumentInfosFor(@NonNull IDocument document, @NonNull Predicate<ServerCapabilities> capabilityRequest) {
        URI fileUri = LSPEclipseUtils.toUri(document);
        ArrayList<LSPDocumentInfo> res = new ArrayList<LSPDocumentInfo>();
        try {
            LanguageServiceAccessor.getLSWrappers(document).stream().filter(wrapper -> wrapper.getServerCapabilities() == null || capabilityRequest.test(wrapper.getServerCapabilities())).forEach(wrapper -> {
                try {
                    wrapper.connect(document);
                }
                catch (IOException e) {
                    LanguageServerPlugin.logError(e);
                }
                res.add(new LSPDocumentInfo(fileUri, document, (LanguageServerWrapper)wrapper));
            });
        }
        catch (Exception e) {
            LanguageServerPlugin.logError(e);
        }
        return res;
    }

    public static @NonNull CompletableFuture<List<@NonNull LanguageServer>> getLanguageServers(@NonNull IDocument document, Predicate<ServerCapabilities> filter) {
        URI uri = LSPEclipseUtils.toUri(document);
        if (uri == null) {
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
        List<@NonNull E> res = Collections.synchronizedList(new ArrayList());
        try {
            return CompletableFuture.allOf((CompletableFuture[])LanguageServiceAccessor.getLSWrappers(document).stream().map(wrapper -> ((CompletableFuture)wrapper.getInitializedServer().thenComposeAsync(server -> {
                if (server != null && (filter == null || filter.test(wrapper.getServerCapabilities()))) {
                    try {
                        return wrapper.connect(document);
                    }
                    catch (IOException ex) {
                        LanguageServerPlugin.logError(ex);
                    }
                }
                return CompletableFuture.completedFuture(null);
            })).thenAccept(server -> {
                if (server != null) {
                    res.add(server);
                }
            })).toArray(CompletableFuture[]::new)).thenApply(theVoid -> res);
        }
        catch (Exception e) {
            LanguageServerPlugin.logError(e);
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
    }

    public static boolean checkCapability(LanguageServer languageServer, Predicate<ServerCapabilities> condition) {
        return startedServers.stream().filter(wrapper -> wrapper.isActive() && wrapper.getServer() == languageServer).anyMatch(wrapper -> condition.test(wrapper.getServerCapabilities()));
    }

    public static Optional<LanguageServersRegistry.LanguageServerDefinition> resolveServerDefinition(LanguageServer languageServer) {
        return startedServers.stream().filter(wrapper -> languageServer.equals(wrapper.getServer())).findFirst().map(wrapper -> wrapper.serverDefinition);
    }

    public static class LSPDocumentInfo {
        private final @NonNull URI fileUri;
        private final @NonNull IDocument document;
        private final @NonNull LanguageServerWrapper wrapper;

        private LSPDocumentInfo(@NonNull URI fileUri, @NonNull IDocument document, @NonNull LanguageServerWrapper wrapper) {
            this.fileUri = fileUri;
            this.document = document;
            this.wrapper = wrapper;
        }

        public @NonNull IDocument getDocument() {
            return this.document;
        }

        public @NonNull URI getFileUri() {
            return this.fileUri;
        }

        @Deprecated
        public LanguageServer getLanguageClient() {
            try {
                return this.wrapper.getInitializedServer().get();
            }
            catch (ExecutionException e) {
                LanguageServerPlugin.logError(e);
                return this.wrapper.getServer();
            }
            catch (InterruptedException e) {
                LanguageServerPlugin.logError(e);
                Thread.currentThread().interrupt();
                return this.wrapper.getServer();
            }
        }

        public int getVersion() {
            return this.wrapper.getVersion(this.fileUri);
        }

        public CompletableFuture<LanguageServer> getInitializedLanguageClient() {
            return this.wrapper.getInitializedServer();
        }

        public @Nullable ServerCapabilities getCapabilites() {
            return this.wrapper.getServerCapabilities();
        }

        public boolean isActive() {
            return this.wrapper.isActive();
        }
    }

    @FunctionalInterface
    private static interface ServerSupplier {
        public LanguageServerWrapper get() throws IOException;
    }
}

