/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.common.util;

import java.util.List;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jst.jsf.common.JSFCommonPlugin;
import org.eclipse.jst.jsf.common.internal.types.TypeInfoCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TypeUtil {
    static IType resolveType(IType owningType, String typeSignature) {
        if (typeSignature.charAt(0) == 'L' || Signature.getTypeSignatureKind((String)typeSignature) == 2 || Signature.getTypeSignatureKind((String)typeSignature) == 4 && Signature.getElementType((String)typeSignature).charAt(0) == 'L') {
            try {
                return owningType.getJavaProject().findType(TypeUtil.getFullyQualifiedName(typeSignature));
            }
            catch (JavaModelException javaModelException) {
                return null;
            }
        }
        return TypeUtil.resolveTypeRelative(owningType, typeSignature);
    }

    private static IType resolveTypeRelative(IType owningType, String typeSignature) {
        String fullName = TypeUtil.getFullyQualifiedName(typeSignature);
        IType resolvedType = null;
        try {
            String[][] resolved = owningType.resolveType(fullName);
            resolvedType = resolved != null && resolved.length > 0 ? owningType.getJavaProject().findType(resolved[0][0], resolved[0][1]) : TypeUtil.resolveInParents(owningType, fullName);
        }
        catch (JavaModelException javaModelException) {}
        return resolvedType;
    }

    public static String getSignature(IType type) {
        String fullyQualifiedName = type.getFullyQualifiedName();
        return Signature.createTypeSignature((String)fullyQualifiedName, (boolean)true);
    }

    public static String getFullyQualifiedName(String typeSignature) {
        String packageName = Signature.getSignatureQualifier((String)typeSignature);
        String typeName = Signature.getSignatureSimpleName((String)typeSignature);
        return "".equals(packageName) ? typeName : String.valueOf(packageName) + "." + typeName;
    }

    private static IType resolveInParents(IType childType, String fullyQualifiedName) throws JavaModelException {
        IType resolvedType = null;
        TypeInfoCache typeInfoCache = TypeInfoCache.getInstance();
        IType[] superTypes = typeInfoCache.getCachedSupertypes(childType);
        if (superTypes == null) {
            superTypes = typeInfoCache.cacheSupertypesFor(childType);
        }
        int i = 0;
        while (i < superTypes.length) {
            IType type = superTypes[i];
            String[][] resolved = type.resolveType(fullyQualifiedName);
            if (resolved != null && resolved.length > 0) {
                resolvedType = childType.getJavaProject().findType(resolved[0][0], resolved[0][1]);
                break;
            }
            ++i;
        }
        return resolvedType;
    }

    public static IType resolveType(IJavaProject javaProject, String fullyResolvedTypeSignature) {
        String fullyQualifiedName = TypeUtil.getFullyQualifiedName(fullyResolvedTypeSignature);
        fullyQualifiedName = Signature.getTypeErasure((String)fullyQualifiedName);
        try {
            return javaProject.findType(fullyQualifiedName);
        }
        catch (JavaModelException e) {
            JSFCommonPlugin.log(e);
            return null;
        }
    }

    public static String matchTypeParameterToArgument(IType type, String typeParamSignature, List<String> typeArguments) {
        if (Signature.getTypeSignatureKind((String)typeParamSignature) != 3) {
            throw new IllegalArgumentException();
        }
        try {
            ITypeParameter[] typeParams = type.getTypeParameters();
            int pos = 0;
            while (pos < typeParams.length) {
                if (typeParams[pos].getElementName().equals(Signature.getSignatureSimpleName((String)typeParamSignature)) && pos < typeArguments.size()) {
                    return typeArguments.get(pos);
                }
                ++pos;
            }
        }
        catch (JavaModelException e) {
            JSFCommonPlugin.log(e);
        }
        return null;
    }

    public static boolean isEnumMember(IType type, String fieldName) {
        block6: {
            try {
                if (type == null || !TypeUtil.isEnumType(type)) {
                    throw new IllegalArgumentException("type must be non-null and isEnum()==true");
                }
                if (fieldName == null) {
                    throw new IllegalArgumentException("fieldName must be non-null");
                }
                if (!"Ljava.lang.Enum;".equals(Signature.createTypeSignature((String)type.getFullyQualifiedName(), (boolean)true))) break block6;
                return true;
            }
            catch (JavaModelException javaModelException) {}
        }
        IField field = type.getField(fieldName);
        if (field.exists() && field.isEnumConstant()) {
            return true;
        }
        return false;
    }

    public static boolean isEnumsCompareCompatible(String typeSig1, String typeSig2) {
        if (typeSig1 == null || typeSig2 == null) {
            throw new IllegalArgumentException("args must not be null");
        }
        if (Signature.getTypeSignatureKind((String)typeSig1) != 1 || Signature.getTypeSignatureKind((String)typeSig2) != 1) {
            throw new IllegalArgumentException("args must be resolved class types");
        }
        if ("Ljava.lang.Enum;".equals(typeSig1) || "Ljava.lang.Enum;".equals(typeSig2)) {
            return true;
        }
        return typeSig1.equals(typeSig2);
    }

    public static boolean canNeverBeEqual(String typeSig1, String typeSig2) {
        if (typeSig1 == null || typeSig2 == null) {
            throw new IllegalArgumentException("args must not be null");
        }
        if (Signature.getTypeSignatureKind((String)typeSig1) != 1 || Signature.getTypeSignatureKind((String)typeSig2) != 1) {
            throw new IllegalArgumentException("args must be resolved class types");
        }
        if ("Ljava.lang.Enum;".equals(typeSig1) || "Ljava.lang.Enum;".equals(typeSig2)) {
            return false;
        }
        return !typeSig1.equals(typeSig2);
    }

    static boolean isEnumType(IType type) {
        if (type == null) {
            return false;
        }
        if ("Ljava.lang.Enum;".equals(Signature.createTypeSignature((String)type.getFullyQualifiedName(), (boolean)true))) {
            return true;
        }
        try {
            return type.isEnum();
        }
        catch (JavaModelException jme) {
            JSFCommonPlugin.log(jme, "Problem resolving isEnum");
            return false;
        }
    }

    private TypeUtil() {
    }
}

