/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.resource.java.source;

import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jpt.common.core.internal.utility.jdt.ElementAnnotationAdapter;
import org.eclipse.jpt.common.core.resource.java.JavaResourceModel;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.jpa.core.internal.resource.java.source.SourceNamedColumnAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.BaseColumnAnnotation;

public abstract class SourceBaseColumnAnnotation
extends SourceNamedColumnAnnotation
implements BaseColumnAnnotation {
    protected DeclarationAnnotationElementAdapter<String> tableDeclarationAdapter = this.buildTableDeclarationAdapter();
    protected AnnotationElementAdapter<String> tableAdapter = this.buildTableAdapter();
    protected String table;
    protected TextRange tableTextRange;
    protected DeclarationAnnotationElementAdapter<Boolean> uniqueDeclarationAdapter = this.buildUniqueDeclarationAdapter();
    protected AnnotationElementAdapter<Boolean> uniqueAdapter = this.buildUniqueAdapter();
    protected Boolean unique;
    protected TextRange uniqueTextRange;
    protected DeclarationAnnotationElementAdapter<Boolean> nullableDeclarationAdapter = this.buildNullableDeclarationAdapter();
    protected AnnotationElementAdapter<Boolean> nullableAdapter = this.buildNullableAdapter();
    protected Boolean nullable;
    protected TextRange nullableTextRange;
    protected DeclarationAnnotationElementAdapter<Boolean> insertableDeclarationAdapter = this.buildInsertableDeclarationAdapter();
    protected AnnotationElementAdapter<Boolean> insertableAdapter = this.buildInsertableAdapter();
    protected Boolean insertable;
    protected TextRange insertableTextRange;
    protected DeclarationAnnotationElementAdapter<Boolean> updatableDeclarationAdapter = this.buildUpdatableDeclarationAdapter();
    protected AnnotationElementAdapter<Boolean> updatableAdapter = this.buildUpdatableAdapter();
    protected Boolean updatable;
    protected TextRange updatableTextRange;

    protected SourceBaseColumnAnnotation(JavaResourceModel parent, AnnotatedElement element, DeclarationAnnotationAdapter daa) {
        this(parent, element, daa, (AnnotationAdapter)new ElementAnnotationAdapter(element, daa));
    }

    protected SourceBaseColumnAnnotation(JavaResourceModel parent, AnnotatedElement element, DeclarationAnnotationAdapter daa, AnnotationAdapter annotationAdapter) {
        super(parent, element, daa, annotationAdapter);
    }

    @Override
    public void initialize(Annotation astAnnotation) {
        super.initialize(astAnnotation);
        this.table = this.buildTable(astAnnotation);
        this.tableTextRange = this.buildTableTextRange(astAnnotation);
        this.unique = this.buildUnique(astAnnotation);
        this.uniqueTextRange = this.buildUniqueTextRange(astAnnotation);
        this.nullable = this.buildNullable(astAnnotation);
        this.nullableTextRange = this.buildNullableTextRange(astAnnotation);
        this.insertable = this.buildInsertable(astAnnotation);
        this.insertableTextRange = this.buildInsertableTextRange(astAnnotation);
        this.updatable = this.buildUpdatable(astAnnotation);
        this.updatableTextRange = this.buildUpdatableTextRange(astAnnotation);
    }

    @Override
    public void synchronizeWith(Annotation astAnnotation) {
        super.synchronizeWith(astAnnotation);
        this.syncTable(this.buildTable(astAnnotation));
        this.tableTextRange = this.buildTableTextRange(astAnnotation);
        this.syncUnique(this.buildUnique(astAnnotation));
        this.uniqueTextRange = this.buildUniqueTextRange(astAnnotation);
        this.syncNullable(this.buildNullable(astAnnotation));
        this.nullableTextRange = this.buildNullableTextRange(astAnnotation);
        this.syncInsertable(this.buildInsertable(astAnnotation));
        this.insertableTextRange = this.buildInsertableTextRange(astAnnotation);
        this.syncUpdatable(this.buildUpdatable(astAnnotation));
        this.updatableTextRange = this.buildUpdatableTextRange(astAnnotation);
    }

    @Override
    public String getTable() {
        return this.table;
    }

    @Override
    public void setTable(String table) {
        if (ObjectTools.notEquals((Object)this.table, (Object)table)) {
            this.table = table;
            this.tableAdapter.setValue((Object)table);
        }
    }

    private void syncTable(String astTable) {
        String old = this.table;
        this.table = astTable;
        this.firePropertyChanged("table", old, astTable);
    }

    private String buildTable(Annotation astAnnotation) {
        return (String)this.tableAdapter.getValue(astAnnotation);
    }

    @Override
    public TextRange getTableTextRange() {
        return this.tableTextRange;
    }

    private TextRange buildTableTextRange(Annotation astAnnotation) {
        return this.getElementTextRange(this.tableDeclarationAdapter, astAnnotation);
    }

    @Override
    public boolean tableTouches(int pos) {
        return this.textRangeTouches(this.tableTextRange, pos);
    }

    private DeclarationAnnotationElementAdapter<String> buildTableDeclarationAdapter() {
        return this.buildStringElementAdapter(this.getTableElementName());
    }

    private AnnotationElementAdapter<String> buildTableAdapter() {
        return this.buildStringElementAdapter(this.tableDeclarationAdapter);
    }

    protected abstract String getTableElementName();

    @Override
    public Boolean getUnique() {
        return this.unique;
    }

    @Override
    public void setUnique(Boolean unique) {
        if (ObjectTools.notEquals((Object)this.unique, (Object)unique)) {
            this.unique = unique;
            this.uniqueAdapter.setValue((Object)unique);
        }
    }

    private void syncUnique(Boolean astUnique) {
        Boolean old = this.unique;
        this.unique = astUnique;
        this.firePropertyChanged("unique", old, astUnique);
    }

    private Boolean buildUnique(Annotation astAnnotation) {
        return (Boolean)this.uniqueAdapter.getValue(astAnnotation);
    }

    @Override
    public TextRange getUniqueTextRange() {
        return this.uniqueTextRange;
    }

    private TextRange buildUniqueTextRange(Annotation astAnnotation) {
        return this.getElementTextRange(this.uniqueDeclarationAdapter, astAnnotation);
    }

    private DeclarationAnnotationElementAdapter<Boolean> buildUniqueDeclarationAdapter() {
        return this.buildBooleanElementAdapter(this.getUniqueElementName());
    }

    private AnnotationElementAdapter<Boolean> buildUniqueAdapter() {
        return this.buildBooleanElementAdapter(this.uniqueDeclarationAdapter);
    }

    protected abstract String getUniqueElementName();

    @Override
    public Boolean getNullable() {
        return this.nullable;
    }

    @Override
    public void setNullable(Boolean nullable) {
        if (ObjectTools.notEquals((Object)this.nullable, (Object)nullable)) {
            this.nullable = nullable;
            this.nullableAdapter.setValue((Object)nullable);
        }
    }

    private void syncNullable(Boolean astNullable) {
        Boolean old = this.nullable;
        this.nullable = astNullable;
        this.firePropertyChanged("nullable", old, astNullable);
    }

    private Boolean buildNullable(Annotation astAnnotation) {
        return (Boolean)this.nullableAdapter.getValue(astAnnotation);
    }

    @Override
    public TextRange getNullableTextRange() {
        return this.nullableTextRange;
    }

    private TextRange buildNullableTextRange(Annotation astAnnotation) {
        return this.getElementTextRange(this.nullableDeclarationAdapter, astAnnotation);
    }

    private DeclarationAnnotationElementAdapter<Boolean> buildNullableDeclarationAdapter() {
        return this.buildBooleanElementAdapter(this.getNullableElementName());
    }

    private AnnotationElementAdapter<Boolean> buildNullableAdapter() {
        return this.buildBooleanElementAdapter(this.nullableDeclarationAdapter);
    }

    protected abstract String getNullableElementName();

    @Override
    public Boolean getInsertable() {
        return this.insertable;
    }

    @Override
    public void setInsertable(Boolean insertable) {
        if (ObjectTools.notEquals((Object)this.insertable, (Object)insertable)) {
            this.insertable = insertable;
            this.insertableAdapter.setValue((Object)insertable);
        }
    }

    private void syncInsertable(Boolean astInsertable) {
        Boolean old = this.insertable;
        this.insertable = astInsertable;
        this.firePropertyChanged("insertable", old, astInsertable);
    }

    private Boolean buildInsertable(Annotation astAnnotation) {
        return (Boolean)this.insertableAdapter.getValue(astAnnotation);
    }

    @Override
    public TextRange getInsertableTextRange() {
        return this.insertableTextRange;
    }

    private TextRange buildInsertableTextRange(Annotation astAnnotation) {
        return this.getElementTextRange(this.insertableDeclarationAdapter, astAnnotation);
    }

    private DeclarationAnnotationElementAdapter<Boolean> buildInsertableDeclarationAdapter() {
        return this.buildBooleanElementAdapter(this.getInsertableElementName());
    }

    private AnnotationElementAdapter<Boolean> buildInsertableAdapter() {
        return this.buildBooleanElementAdapter(this.insertableDeclarationAdapter);
    }

    protected abstract String getInsertableElementName();

    @Override
    public Boolean getUpdatable() {
        return this.updatable;
    }

    @Override
    public void setUpdatable(Boolean updatable) {
        if (ObjectTools.notEquals((Object)this.updatable, (Object)updatable)) {
            this.updatable = updatable;
            this.updatableAdapter.setValue((Object)updatable);
        }
    }

    private void syncUpdatable(Boolean astUpdatable) {
        Boolean old = this.updatable;
        this.updatable = astUpdatable;
        this.firePropertyChanged("updatable", old, astUpdatable);
    }

    private Boolean buildUpdatable(Annotation astAnnotation) {
        return (Boolean)this.updatableAdapter.getValue(astAnnotation);
    }

    @Override
    public TextRange getUpdatableTextRange() {
        return this.updatableTextRange;
    }

    private TextRange buildUpdatableTextRange(Annotation astAnnotation) {
        return this.getElementTextRange(this.updatableDeclarationAdapter, astAnnotation);
    }

    private DeclarationAnnotationElementAdapter<Boolean> buildUpdatableDeclarationAdapter() {
        return this.buildBooleanElementAdapter(this.getUpdatableElementName());
    }

    private AnnotationElementAdapter<Boolean> buildUpdatableAdapter() {
        return this.buildBooleanElementAdapter(this.updatableDeclarationAdapter);
    }

    protected abstract String getUpdatableElementName();

    @Override
    public boolean isUnset() {
        return super.isUnset() && this.table == null && this.unique == null && this.nullable == null && this.insertable == null && this.updatable == null;
    }
}

