/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.ui.internal.wizards.classesgen;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.wizards.TypedElementSelectionValidator;
import org.eclipse.jdt.internal.ui.wizards.TypedViewerFilter;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstall2;
import org.eclipse.jdt.ui.JavaElementComparator;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.StandardJavaElementContentProvider;
import org.eclipse.jdt.ui.wizards.NewTypeWizardPage;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jpt.common.ui.internal.WorkbenchTools;
import org.eclipse.jpt.common.ui.internal.swt.widgets.TableTools;
import org.eclipse.jpt.common.ui.internal.widgets.TableLayoutComposite;
import org.eclipse.jpt.common.utility.internal.ArrayTools;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.jaxb.core.JaxbPreferences;
import org.eclipse.jpt.jaxb.core.JaxbProject;
import org.eclipse.jpt.jaxb.core.JaxbProjectManager;
import org.eclipse.jpt.jaxb.core.JaxbWorkspace;
import org.eclipse.jpt.jaxb.core.internal.gen.ClassesGenerator;
import org.eclipse.jpt.jaxb.core.platform.JaxbPlatformConfig;
import org.eclipse.jpt.jaxb.core.platform.JaxbPlatformGroupConfig;
import org.eclipse.jpt.jaxb.core.platform.JaxbPlatformManager;
import org.eclipse.jpt.jaxb.ui.JaxbWorkbench;
import org.eclipse.jpt.jaxb.ui.JptJaxbUiMessages;
import org.eclipse.jpt.jaxb.ui.internal.plugin.JptJaxbUiPlugin;
import org.eclipse.jpt.jaxb.ui.internal.wizards.classesgen.ClassesGeneratorWizard;
import org.eclipse.jpt.jaxb.ui.internal.wizards.classesgen.SelectFileOrXMLCatalogIdPanel;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.osgi.framework.Bundle;

public class ClassesGeneratorWizardPage
extends NewTypeWizardPage {
    public static final String JPT_ECLIPSELINK_UI_PLUGIN_ID = "org.eclipse.jpt.jpa.eclipselink.ui";
    public static final String XML_FILTER = "*.xml";
    public static final String[] bindingdFilesFilterExtensions = new String[]{".xjb", ".xml", ".xbd"};
    public static final String ECLIPSELINK_PLATFORM_GROUP_ID = "eclipselink";
    public static final String HELP_CONTEXT_ID = "org.eclipse.jpt.jaxb.ui.configure_jaxb_class_generation_dialog";
    final ResourceManager resourceManager;
    private SettingsGroup settingsGroup;
    private String targetFolder;
    private String targetPackage;
    private Button usesMoxyCheckBox;
    private boolean usesMoxy;

    public ClassesGeneratorWizardPage(ResourceManager resourceManager) {
        super(true, "Classes Generator");
        this.resourceManager = resourceManager;
        this.setDescription(JptJaxbUiMessages.CLASSES_GENERATOR_WIZARD_PAGE_DESC);
    }

    public void createControl(Composite parent) {
        this.setPageComplete(false);
        this.setControl(this.buildTopLevelControl(parent));
    }

    protected String getTargetFolder() {
        return this.targetFolder;
    }

    protected String getTargetPackage() {
        return this.targetPackage;
    }

    protected String getCatalog() {
        return this.settingsGroup.getCatalog();
    }

    protected String[] getBindingsFileNames() {
        return this.settingsGroup.getBindingsFileNames();
    }

    protected boolean usesMoxy() {
        return this.usesMoxy;
    }

    private void setUsesMoxy(boolean usesMoxy) {
        this.usesMoxy = usesMoxy;
    }

    protected IStatus packageChanged() {
        IStatus status = super.packageChanged();
        IPackageFragment packageFragment = this.getPackageFragment();
        if (!status.matches(4)) {
            IProject project;
            String newPackageName = packageFragment.getElementName();
            if (!this.isPackageInitialInitialization(newPackageName) && !newPackageName.equals(JaxbPreferences.getClassGenPackage((IProject)(project = this.getJavaProject().getProject())))) {
                JaxbPreferences.setClassGenPackage((IProject)project, (String)newPackageName);
            }
            this.targetPackage = packageFragment.getElementName();
        }
        return status;
    }

    protected IStatus containerChanged() {
        IStatus status = super.containerChanged();
        String srcFolder = this.getPackageFragmentRootText();
        if (!status.matches(4)) {
            this.targetFolder = srcFolder.substring(srcFolder.indexOf("/") + 1);
        }
        return status;
    }

    protected void handleFieldChanged(String fieldName) {
        super.handleFieldChanged(fieldName);
        if (this.fContainerStatus.matches(4)) {
            this.updateStatus(this.fContainerStatus);
        } else if (!this.fPackageStatus.matches(0)) {
            this.updateStatus(this.fPackageStatus);
        } else {
            this.updateStatus(Status.OK_STATUS);
        }
        this.validateProjectClasspath();
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            String packagePref;
            this.initContainerPage((IJavaElement)((ClassesGeneratorWizard)this.getWizard()).getJavaProject());
            if (this.projectPlatformIsJaxb()) {
                this.setUsesMoxy(this.projectJaxbPlatformIsEclipseLink());
                this.usesMoxyCheckBox.setVisible(false);
            } else {
                this.setUsesMoxy(this.jptEclipseLinkBundleExists() && this.moxyIsOnClasspath());
                this.usesMoxyCheckBox.setVisible(this.jptEclipseLinkBundleExists() && !this.moxyIsOnClasspath());
            }
            this.validateProjectClasspath();
            if (this.getPackageText().equals("") && !StringTools.isBlank((String)(packagePref = JaxbPreferences.getClassGenPackage((IProject)this.getJavaProject().getProject())))) {
                this.setPackageName(this.getPackageFragmentRoot(), packagePref);
            }
            String schemaName = ((ClassesGeneratorWizard)this.getWizard()).getLocalSchemaUri().lastSegment();
            this.setTitle(NLS.bind((String)JptJaxbUiMessages.CLASSES_GENERATOR_WIZARD_PAGE_TITLE, (Object)schemaName));
        }
    }

    protected IPackageFragmentRoot chooseContainer() {
        Class[] acceptedClasses = new Class[]{IPackageFragmentRoot.class, IJavaProject.class};
        TypedElementSelectionValidator validator = new TypedElementSelectionValidator(acceptedClasses, false){

            public boolean isSelectedValid(Object element) {
                try {
                    if (element instanceof IJavaProject) {
                        IJavaProject jproject = (IJavaProject)element;
                        IPath path = jproject.getProject().getFullPath();
                        return jproject.findPackageFragmentRoot(path) != null;
                    }
                    if (element instanceof IPackageFragmentRoot) {
                        return ((IPackageFragmentRoot)element).getKind() == 1;
                    }
                    return true;
                }
                catch (JavaModelException e) {
                    JptJaxbUiPlugin.instance().logError(e);
                    return false;
                }
            }
        };
        acceptedClasses = new Class[]{IJavaModel.class, IPackageFragmentRoot.class, IJavaProject.class};
        TypedViewerFilter filter = new TypedViewerFilter(acceptedClasses){

            public boolean select(Viewer viewer, Object parent, Object element) {
                if (element instanceof IPackageFragmentRoot) {
                    try {
                        return ((IPackageFragmentRoot)element).getKind() == 1;
                    }
                    catch (JavaModelException e) {
                        JptJaxbUiPlugin.instance().logError(e);
                        return false;
                    }
                }
                return super.select(viewer, parent, element);
            }
        };
        StandardJavaElementContentProvider provider = new StandardJavaElementContentProvider();
        JavaElementLabelProvider labelProvider = new JavaElementLabelProvider(18);
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)labelProvider, (ITreeContentProvider)provider);
        dialog.setValidator((ISelectionStatusValidator)validator);
        dialog.setComparator((ViewerComparator)new JavaElementComparator());
        dialog.setTitle(JptJaxbUiMessages.CLASSES_GENERATOR_WIZARD_PAGE_SOURCE_FOLDER_SELECTION_DIALOG_TITLE);
        dialog.setMessage(JptJaxbUiMessages.CLASSES_GENERATOR_WIZARD_PAGE_CHOOSE_SOURCE_FOLDER_DIALOG_DESC);
        dialog.addFilter((ViewerFilter)filter);
        dialog.setInput((Object)this.getJavaProject());
        dialog.setInitialSelection((Object)this.getPackageFragmentRoot());
        dialog.setHelpAvailable(false);
        if (dialog.open() == 0) {
            Object element = dialog.getFirstResult();
            if (element instanceof IJavaProject) {
                IJavaProject jproject = (IJavaProject)element;
                return jproject.getPackageFragmentRoot((IResource)jproject.getProject());
            }
            if (element instanceof IPackageFragmentRoot) {
                return (IPackageFragmentRoot)element;
            }
            return null;
        }
        return null;
    }

    private Control buildTopLevelControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        WorkbenchTools.setHelp((Control)composite, (String)HELP_CONTEXT_ID);
        this.settingsGroup = new SettingsGroup(composite);
        this.usesMoxyCheckBox = this.buildUsesMoxyCheckBox(composite);
        Dialog.applyDialogFont((Control)parent);
        return composite;
    }

    private Button buildUsesMoxyCheckBox(Composite parent) {
        Button checkBox = new Button(parent, 32);
        GridData gridData = new GridData();
        gridData.horizontalIndent = 5;
        gridData.verticalIndent = 5;
        checkBox.setLayoutData((Object)gridData);
        checkBox.setText(JptJaxbUiMessages.CLASSES_GENERATOR_WIZARD_PAGE_USES_MOXY_IMPLEMENTATION);
        checkBox.setSelection(this.usesMoxy());
        checkBox.addSelectionListener(this.buildUsesMoxySelectionListener());
        return checkBox;
    }

    private SelectionListener buildUsesMoxySelectionListener() {
        return new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
                this.widgetSelected(event);
            }

            public void widgetSelected(SelectionEvent event) {
                ClassesGeneratorWizardPage.this.setUsesMoxy(ClassesGeneratorWizardPage.this.usesMoxyCheckBox.getSelection());
                ClassesGeneratorWizardPage.this.validateProjectClasspath();
            }
        };
    }

    private boolean jptEclipseLinkBundleExists() {
        return this.getJptEclipseLinkBundle() != null;
    }

    private Bundle getJptEclipseLinkBundle() {
        return Platform.getBundle((String)JPT_ECLIPSELINK_UI_PLUGIN_ID);
    }

    private void validateProjectClasspath() {
        this.setMessage(null);
        if (!this.genericJaxbIsOnClasspath()) {
            this.displayWarning(JptJaxbUiMessages.CLASSES_GENERATOR_WIZARD_PAGE_JAXB_LIBRARIES_NOT_AVAILABLE);
        } else if (this.usesMoxy() && !this.eclipseLinkMoxyIsOnClasspath()) {
            this.displayWarning(JptJaxbUiMessages.CLASSES_GENERATOR_WIZARD_PAGE_MOXY_LIBRARIES_NOT_AVAILABLE);
        }
    }

    private boolean genericJaxbIsOnClasspath() {
        if (this.genericJaxbNonJdkIsOnClasspath()) {
            return true;
        }
        if (this.projectJre15OrLower()) {
            return false;
        }
        if (this.genericJaxbJdkIsOnClasspath()) {
            return true;
        }
        return this.toolsJarExists();
    }

    private boolean projectJre15OrLower() {
        String versionString;
        Float javaVersionNumber;
        String javaVersion;
        IVMInstall vm;
        block3: {
            try {
                vm = this.getVMInstall();
                if (vm != null) break block3;
                return false;
            }
            catch (CoreException coreException) {
                return false;
            }
        }
        return vm instanceof IVMInstall2 && (javaVersion = ((IVMInstall2)vm).getJavaVersion()) != null && (double)(javaVersionNumber = Float.valueOf(versionString = javaVersion.substring(0, javaVersion.lastIndexOf(46)))).floatValue() <= 1.5;
    }

    private boolean genericJaxbJdkIsOnClasspath() {
        return ClassesGenerator.genericJaxbJdkIsOnClasspath((IJavaProject)this.getJavaProject());
    }

    private boolean genericJaxbNonJdkIsOnClasspath() {
        return ClassesGenerator.genericJaxbNonJdkIsOnClasspath((IJavaProject)this.getJavaProject());
    }

    private boolean toolsJarExists() {
        return ClassesGenerator.toolsJarExists((IJavaProject)this.getJavaProject());
    }

    private IVMInstall getVMInstall() throws CoreException {
        return ClassesGenerator.getVMInstall((IJavaProject)this.getJavaProject());
    }

    private boolean moxyIsOnClasspath() {
        try {
            IType genClass = this.getJavaProject().findType("org.eclipse.persistence.jaxb.xjc.MOXyXJC");
            return genClass != null;
        }
        catch (JavaModelException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean eclipseLinkMoxyIsOnClasspath() {
        return this.moxyIsOnClasspath() && this.genericJaxbNonJdkIsOnClasspath();
    }

    private boolean projectPlatformIsJaxb() {
        return this.getJaxbProject() != null;
    }

    private JaxbPlatformConfig getJaxbPlatformConfig(String jaxbPlatformID) {
        JaxbPlatformManager jaxbPlatformManager = this.getJaxbPlatformManager();
        return jaxbPlatformManager == null ? null : jaxbPlatformManager.getJaxbPlatformConfig(jaxbPlatformID);
    }

    private JaxbPlatformManager getJaxbPlatformManager() {
        JaxbWorkspace jaxbWorkspace = this.getJaxbWorkspace();
        return jaxbWorkspace == null ? null : jaxbWorkspace.getJaxbPlatformManager();
    }

    private JaxbProject getJaxbProject() {
        JaxbProjectManager jaxbProjectManager = this.getJaxbProjectManager();
        return jaxbProjectManager == null ? null : jaxbProjectManager.getJaxbProject(this.getJavaProject().getProject());
    }

    private JaxbProjectManager getJaxbProjectManager() {
        JaxbWorkspace jaxbWorkspace = this.getJaxbWorkspace();
        return jaxbWorkspace == null ? null : jaxbWorkspace.getJaxbProjectManager();
    }

    private JaxbWorkspace getJaxbWorkspace() {
        JaxbWorkbench jaxbWorkbench = this.getJaxbWorkbench();
        return jaxbWorkbench == null ? null : jaxbWorkbench.getJaxbWorkspace();
    }

    private JaxbWorkbench getJaxbWorkbench() {
        return (JaxbWorkbench)WorkbenchTools.getAdapter(JaxbWorkbench.class);
    }

    private boolean projectJaxbPlatformIsEclipseLink() {
        JaxbPlatformGroupConfig jaxbPlatformGroupConfig;
        String jaxbPlatformID = JaxbPreferences.getJaxbPlatformID((IProject)this.getJavaProject().getProject());
        JaxbPlatformConfig jaxbPlatformConfig = this.getJaxbPlatformConfig(jaxbPlatformID);
        JaxbPlatformGroupConfig jaxbPlatformGroupConfig2 = jaxbPlatformGroupConfig = jaxbPlatformConfig == null ? null : jaxbPlatformConfig.getGroupConfig();
        return jaxbPlatformGroupConfig != null && jaxbPlatformGroupConfig.getId().equals(ECLIPSELINK_PLATFORM_GROUP_ID);
    }

    private boolean isPackageInitialInitialization(String newPackageName) {
        return this.targetPackage == null && newPackageName.equals("");
    }

    private void setPackageName(IPackageFragmentRoot packageFragmentRoot, String packageName) {
        if (packageName == null || packageName.length() == 0 || packageFragmentRoot == null) {
            return;
        }
        IPackageFragment packageFragment = packageFragmentRoot.getPackageFragment(packageName);
        this.setPackageFragment(packageFragment, true);
        JaxbPreferences.setClassGenPackage((IProject)this.getJavaProject().getProject(), (String)packageName);
    }

    private void displayWarning(String message) {
        this.setMessage(message, 2);
    }

    private class PromptBindingsFilesDialog
    extends TrayDialog {
        private SelectFileOrXMLCatalogIdPanel locationPanel;
        private String location;

        public PromptBindingsFilesDialog(Shell shell) {
            super(shell);
        }

        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
            newShell.setText(JptJaxbUiMessages.CLASSES_GENERATOR_WIZARD_PAGE_CHOOSE_A_BINDINGS_FILE);
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            this.locationPanel = new SelectFileOrXMLCatalogIdPanel(composite, (IStructuredSelection)StructuredSelection.EMPTY, ClassesGeneratorWizardPage.this.resourceManager);
            this.locationPanel.setFilterExtensions(bindingdFilesFilterExtensions);
            this.locationPanel.update();
            this.locationPanel.setVisibleHelper(true);
            return composite;
        }

        protected boolean isResizable() {
            return true;
        }

        protected void okPressed() {
            IFile file = this.locationPanel.getFile();
            if (file != null) {
                this.location = file.getProjectRelativePath().toOSString();
            }
            super.okPressed();
        }

        public String getLocation() {
            return this.location;
        }
    }

    private class SettingsGroup {
        private final Text catalogText;
        private final ArrayList<String> bindingsFileNames;

        private SettingsGroup(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout(4, false);
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            composite.setLayout((Layout)layout);
            composite.setLayoutData((Object)new GridData(768));
            ClassesGeneratorWizardPage.this.createContainerControls(composite, 4);
            ClassesGeneratorWizardPage.this.createPackageControls(composite, 4);
            Label label = new Label(composite, 258);
            GridData gridData = new GridData(4, 1, true, false, 4, 1);
            gridData.verticalIndent = 5;
            label.setLayoutData((Object)gridData);
            Label catalogLabel = new Label(composite, 0);
            catalogLabel.setText(JptJaxbUiMessages.CLASSES_GENERATOR_WIZARD_PAGE_CATALOG);
            gridData = new GridData();
            gridData.verticalIndent = 5;
            catalogLabel.setLayoutData((Object)gridData);
            this.catalogText = this.buildCatalogText(composite);
            this.buildBrowseButton(composite);
            this.bindingsFileNames = new ArrayList();
            Label bindingsFileLabel = new Label(composite, 0);
            bindingsFileLabel.setText(JptJaxbUiMessages.CLASSES_GENERATOR_WIZARD_PAGE_BINDINGS_FILES);
            bindingsFileLabel.setLayoutData((Object)new GridData());
            this.buildBindingsFileTable(composite);
        }

        protected String getCatalog() {
            return this.catalogText.getText();
        }

        protected String[] getBindingsFileNames() {
            return (String[])ArrayTools.array(this.bindingsFileNames.iterator(), (Object[])new String[0]);
        }

        private Text buildCatalogText(Composite parent) {
            Text text = new Text(parent, 2048);
            GridData gridData = new GridData(768);
            gridData.horizontalSpan = 2;
            gridData.verticalIndent = 5;
            text.setLayoutData((Object)gridData);
            return text;
        }

        private void buildBrowseButton(Composite parent) {
            Composite buttonComposite = new Composite(parent, 0);
            GridLayout buttonLayout = new GridLayout(1, false);
            buttonComposite.setLayout((Layout)buttonLayout);
            GridData gridData = new GridData();
            gridData.horizontalAlignment = 4;
            gridData.verticalAlignment = 1;
            buttonComposite.setLayoutData((Object)gridData);
            Button browseButton = new Button(buttonComposite, 8);
            browseButton.setText(JptJaxbUiMessages.CLASSES_GENERATOR_WIZARD_PAGE_BROWSE_BUTTON);
            gridData = new GridData();
            gridData.horizontalAlignment = 4;
            gridData.verticalIndent = 5;
            gridData.grabExcessHorizontalSpace = true;
            browseButton.setLayoutData((Object)gridData);
            browseButton.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    String filePath = SettingsGroup.this.promptXmlFile();
                    if (!StringTools.isBlank((String)filePath)) {
                        SettingsGroup.this.catalogText.setText(SettingsGroup.this.makeRelativeToProjectPath(filePath));
                    }
                }
            });
        }

        private TableViewer buildBindingsFileTable(Composite parent) {
            TableViewer tableViewer = this.buildTableViewer(parent, this.bindingsFileNames);
            this.buildAddRemoveButtons(parent, tableViewer, this.bindingsFileNames);
            return tableViewer;
        }

        private TableViewer buildTableViewer(Composite parent, ArrayList<String> tableDataModel) {
            TableLayoutComposite tableLayout = new TableLayoutComposite(parent, 0);
            this.addColumnsData(tableLayout);
            Table table = new Table((Composite)tableLayout, 68356);
            table.setLinesVisible(false);
            TableColumn column = new TableColumn(table, 0, 0);
            column.setResizable(true);
            GridData gridData = new GridData(1808);
            gridData.horizontalSpan = 2;
            gridData.heightHint = TableTools.calculateHeightHint((Table)table, (int)3);
            tableLayout.setLayoutData((Object)gridData);
            TableViewer tableViewer = new TableViewer(table);
            tableViewer.setUseHashlookup(true);
            tableViewer.setLabelProvider(this.buildLabelProvider());
            tableViewer.setContentProvider(this.buildContentProvider());
            tableViewer.setInput(tableDataModel);
            return tableViewer;
        }

        private void buildAddRemoveButtons(Composite parent, final TableViewer tableViewer, final ArrayList<String> tableDataModel) {
            Composite buttonComposite = new Composite(parent, 0);
            GridLayout buttonLayout = new GridLayout(1, false);
            buttonComposite.setLayout((Layout)buttonLayout);
            GridData gridData = new GridData();
            gridData.horizontalAlignment = 4;
            gridData.verticalAlignment = 1;
            buttonComposite.setLayoutData((Object)gridData);
            Button addButton = new Button(buttonComposite, 8);
            addButton.setText(JptJaxbUiMessages.CLASSES_GENERATOR_WIZARD_PAGE_ADD_BUTTON);
            gridData = new GridData();
            gridData.horizontalAlignment = 4;
            gridData.grabExcessHorizontalSpace = true;
            addButton.setLayoutData((Object)gridData);
            addButton.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    String filePath = SettingsGroup.this.addBindingsFileDialog();
                    if (!StringTools.isBlank((String)filePath)) {
                        SettingsGroup.this.addBindingsFile(filePath, tableDataModel);
                        tableViewer.refresh();
                    }
                }
            });
            Button removeButton = new Button(buttonComposite, 8);
            removeButton.setText(JptJaxbUiMessages.CLASSES_GENERATOR_WIZARD_PAGE_REMOVE_BUTTON);
            gridData = new GridData();
            gridData.horizontalAlignment = 4;
            gridData.grabExcessHorizontalSpace = true;
            removeButton.setLayoutData((Object)gridData);
            removeButton.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    StructuredSelection selection = (StructuredSelection)tableViewer.getSelection();
                    if (selection.isEmpty()) {
                        return;
                    }
                    String bindingsFileName = (String)selection.getFirstElement();
                    SettingsGroup.this.removeBindingsFile(bindingsFileName);
                    tableViewer.refresh();
                }
            });
            addButton.setFocus();
        }

        private String addBindingsFileDialog() {
            PromptBindingsFilesDialog dialog = new PromptBindingsFilesDialog(ClassesGeneratorWizardPage.this.getShell());
            if (dialog.open() == 1) {
                return null;
            }
            String location = dialog.getLocation();
            return location;
        }

        private String makeRelativeToProjectPath(String filePath) {
            Path path = new Path(filePath);
            IPath relativePath = path.makeRelativeTo(ClassesGeneratorWizardPage.this.getJavaProject().getProject().getLocation());
            return relativePath.toOSString();
        }

        private void addBindingsFile(String relativePath, ArrayList<String> tableDataModel) {
            if (!tableDataModel.contains(relativePath)) {
                tableDataModel.add(relativePath);
            }
        }

        private void removeBindingsFile(String bindingsName) {
            this.bindingsFileNames.remove(bindingsName);
        }

        private IBaseLabelProvider buildLabelProvider() {
            return new TableLabelProvider();
        }

        private IContentProvider buildContentProvider() {
            return new TableContentProvider();
        }

        private String promptXmlFile() {
            String projectPath = ClassesGeneratorWizardPage.this.getJavaProject().getProject().getLocation().toString();
            FileDialog dialog = new FileDialog(ClassesGeneratorWizardPage.this.getShell());
            dialog.setText(JptJaxbUiMessages.CLASSES_GENERATOR_WIZARD_PAGE_CHOOSE_A_CATALOG);
            dialog.setFilterPath(projectPath);
            dialog.setFilterExtensions(new String[]{ClassesGeneratorWizardPage.XML_FILTER});
            return dialog.open();
        }

        private void addColumnsData(TableLayoutComposite layout) {
            layout.addColumnData((ColumnLayoutData)new ColumnWeightData(50, true));
        }
    }

    private class TableContentProvider
    implements IStructuredContentProvider {
        TableContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            return ((Collection)inputElement).toArray();
        }
    }

    private class TableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private TableLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            return (String)element;
        }
    }
}

