/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.dot.internal.language.arrowtype;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum PrimitiveShape implements Enumerator
{
    BOX(0, "box", "box"),
    CROW(1, "crow", "crow"),
    CURVE(2, "curve", "curve"),
    ICURVE(3, "icurve", "icurve"),
    DIAMOND(4, "diamond", "diamond"),
    DOT(5, "dot", "dot"),
    INV(6, "inv", "inv"),
    NONE(7, "none", "none"),
    NORMAL(8, "normal", "normal"),
    TEE(9, "tee", "tee"),
    VEE(10, "vee", "vee");

    public static final int BOX_VALUE = 0;
    public static final int CROW_VALUE = 1;
    public static final int CURVE_VALUE = 2;
    public static final int ICURVE_VALUE = 3;
    public static final int DIAMOND_VALUE = 4;
    public static final int DOT_VALUE = 5;
    public static final int INV_VALUE = 6;
    public static final int NONE_VALUE = 7;
    public static final int NORMAL_VALUE = 8;
    public static final int TEE_VALUE = 9;
    public static final int VEE_VALUE = 10;
    private static final PrimitiveShape[] VALUES_ARRAY;
    public static final List<PrimitiveShape> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new PrimitiveShape[]{BOX, CROW, CURVE, ICURVE, DIAMOND, DOT, INV, NONE, NORMAL, TEE, VEE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static PrimitiveShape get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            PrimitiveShape result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static PrimitiveShape getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            PrimitiveShape result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static PrimitiveShape get(int value) {
        switch (value) {
            case 0: {
                return BOX;
            }
            case 1: {
                return CROW;
            }
            case 2: {
                return CURVE;
            }
            case 3: {
                return ICURVE;
            }
            case 4: {
                return DIAMOND;
            }
            case 5: {
                return DOT;
            }
            case 6: {
                return INV;
            }
            case 7: {
                return NONE;
            }
            case 8: {
                return NORMAL;
            }
            case 9: {
                return TEE;
            }
            case 10: {
                return VEE;
            }
        }
        return null;
    }

    private PrimitiveShape(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

