/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.ui.urlhandling;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.epp.internal.mpc.core.service.DefaultMarketplaceService;
import org.eclipse.epp.internal.mpc.ui.urlhandling.MarketplaceUrlUtil;
import org.eclipse.epp.internal.mpc.ui.urlhandling.UrlHandlerStrategy;
import org.eclipse.epp.mpc.ui.CatalogDescriptor;

public abstract class AbstractMpcProtocolUrlHandler
implements UrlHandlerStrategy {
    protected static final String PARSED_URI = "parsed_uri";
    protected static final String MARKETPLACE_URL = "marketplace_url";
    protected static final String MPC_CATALOG = "mpc_catalog";
    protected static final String ACTION = "action";
    protected static final String PATH_PARAMETERS = "path_parameters";

    @Override
    public boolean handles(String url) {
        return url != null && url.startsWith("eclipse+mpc:");
    }

    protected Map<String, Object> doParse(String url) {
        URI parsedUri = MarketplaceUrlUtil.parseUri(url);
        if (parsedUri == null || !"eclipse+mpc".equals(parsedUri.getScheme())) {
            return null;
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.putAll(MarketplaceUrlUtil.parseQuery(parsedUri));
        result.put(PARSED_URI, parsedUri);
        String authority = parsedUri.getAuthority();
        String marketplaceLookupUrl = authority == null ? DefaultMarketplaceService.DEFAULT_SERVICE_LOCATION : "http://" + authority;
        CatalogDescriptor catalogDescriptor = MarketplaceUrlUtil.findCatalogDescriptor(marketplaceLookupUrl, true);
        result.put(MPC_CATALOG, catalogDescriptor);
        result.put(MARKETPLACE_URL, catalogDescriptor.getUrl());
        String action = null;
        Path path = new Path(parsedUri.getPath());
        if (path.segmentCount() > 0) {
            action = path.segment(0).toLowerCase();
        }
        result.put(ACTION, action);
        IPath pathParameters = null;
        if (path.segmentCount() > 1) {
            pathParameters = path.removeFirstSegments(1);
        }
        result.put(PATH_PARAMETERS, pathParameters);
        return result;
    }
}

