/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.mwe2.language;

import com.google.common.collect.ImmutableSet;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Set;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.common.services.DefaultTerminalConverters;
import org.eclipse.xtext.conversion.IValueConverter;
import org.eclipse.xtext.conversion.ValueConverter;
import org.eclipse.xtext.conversion.ValueConverterException;
import org.eclipse.xtext.conversion.impl.AbstractNullSafeConverter;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.util.Strings;

public class Mwe2ValueConverters
extends DefaultTerminalConverters {
    @ValueConverter(rule="ImportedFQN")
    public IValueConverter<String> ImportedFQN() {
        return new FQNConverter();
    }

    @ValueConverter(rule="FQN")
    public IValueConverter<String> FQN() {
        return new FQNConverter();
    }

    @ValueConverter(rule="DoubleValue")
    public IValueConverter<Double> DoubleValue() {
        return new AbstractNullSafeConverter<Double>(){

            protected Double internalToValue(String string, INode node) {
                try {
                    return Double.parseDouble(string);
                }
                catch (NumberFormatException e) {
                    throw new ValueConverterException(e.getMessage(), node, (Exception)e);
                }
            }

            protected String internalToString(Double value) {
                return BigDecimal.valueOf(value).toPlainString();
            }
        };
    }

    @ValueConverter(rule="ConstantValue")
    public IValueConverter<String> ConstantValue() {
        return new AbstractNullSafeConverter<String>(){

            protected String internalToValue(String string, INode node) {
                try {
                    string = string.replace("\\${", "${");
                    return Strings.convertFromJavaString((String)string, (boolean)false);
                }
                catch (IllegalArgumentException e) {
                    throw new ValueConverterException(e.getMessage(), node, (Exception)e);
                }
            }

            protected String internalToString(String value) {
                String result = Strings.convertToJavaString((String)value, (boolean)false);
                result = result.replace("${", "\\${");
                return result;
            }
        };
    }

    public class FQNConverter
    extends AbstractNullSafeConverter<String> {
        private Set<String> allKeywords;

        public FQNConverter() {
            this.allKeywords = ImmutableSet.copyOf((Collection)GrammarUtil.getAllKeywords((Grammar)Mwe2ValueConverters.this.getGrammar()));
        }

        protected String internalToValue(String string, INode node) {
            return string.replaceAll("[\\^\\s]", "");
        }

        protected String internalToString(String value) {
            String[] segments = value.split("\\.");
            StringBuilder builder = new StringBuilder(value.length());
            boolean first = true;
            String[] stringArray = segments;
            int n = segments.length;
            int n2 = 0;
            while (n2 < n) {
                String segment = stringArray[n2];
                if (!first) {
                    builder.append('.');
                }
                if (this.allKeywords.contains(segment)) {
                    builder.append("^");
                }
                builder.append(segment);
                first = false;
                ++n2;
            }
            return builder.toString();
        }
    }
}

