/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo;

import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.CDOState;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.eresource.CDOResourceNode;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.spi.cdo.FSMUtil;
import org.eclipse.emf.spi.cdo.InternalCDOObject;
import org.eclipse.net4j.util.AdapterUtil;

public class CDOElement
extends AdapterImpl
implements IAdaptable {
    private static final Class<CDOElement> TYPE = CDOElement.class;
    private final EObject delegate;
    private final List<Object> children = new ArrayList<Object>();

    public CDOElement(EObject delegate) {
        this.delegate = (EObject)CDOElement.getInstance(delegate);
    }

    public Object getDelegate() {
        return this.delegate;
    }

    public Object getParent() {
        return CDOElement.getParentOf(this.delegate);
    }

    public Object[] getChildren() {
        return this.children.toArray();
    }

    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChild(Object child) {
        EList<Adapter> adapters = CDOElement.removeFrom(child = CDOElement.getInstance(child));
        if (adapters != null) {
            Class<CDOElement> clazz = TYPE;
            synchronized (clazz) {
                adapters.add((Object)this);
            }
        }
        this.children.add(child);
    }

    public void reset() {
        this.children.clear();
    }

    public boolean isAdapterForType(Object type) {
        return type == TYPE;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == EObject.class) {
            return this.delegate;
        }
        return AdapterUtil.adapt((Object)((Object)this), (Class)adapter, (boolean)false);
    }

    public String toString(Object child) {
        return child.toString();
    }

    public String toString() {
        return this.delegate.toString();
    }

    public static EObject getParentOf(EObject eObject) {
        CDOView view;
        CDOResource resource;
        if (eObject == null) {
            return null;
        }
        CDOObject cdoObject = CDOUtil.getCDOObject(eObject, false);
        if (cdoObject != null && (FSMUtil.isInvalid(cdoObject) || cdoObject.cdoView() == null || cdoObject.cdoView().isClosed())) {
            return null;
        }
        EObject container = eObject.eContainer();
        if (container != null) {
            return container;
        }
        if (eObject instanceof CDOResource && (resource = (CDOResource)eObject).isRoot()) {
            return null;
        }
        resource = eObject.eResource();
        if (resource instanceof CDOResource) {
            return resource;
        }
        if (eObject instanceof CDOResourceNode && (view = ((CDOResourceNode)eObject).cdoView()) != null) {
            return view.getRootResource();
        }
        return null;
    }

    public static CDOElement getFor(Object object) {
        if (object instanceof Notifier) {
            Notifier notifier = (Notifier)object;
            return (CDOElement)EcoreUtil.getExistingAdapter((Notifier)notifier, TYPE);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EList<Adapter> removeFrom(Object object) {
        if (object instanceof EObject) {
            EObject eObject = (EObject)object;
            EList adapters = eObject.eAdapters();
            Class<CDOElement> clazz = TYPE;
            synchronized (clazz) {
                CDOElement.removeSafe((EList<Adapter>)adapters);
            }
            return adapters;
        }
        return null;
    }

    private static void removeSafe(EList<Adapter> adapters) {
        try {
            Iterator it = adapters.iterator();
            while (it.hasNext()) {
                Adapter adapter = (Adapter)it.next();
                if (!adapter.isAdapterForType(TYPE)) continue;
                it.remove();
            }
        }
        catch (ConcurrentModificationException ex) {
            CDOElement.removeSafe(adapters);
        }
    }

    private static Object getInstance(Object object) {
        if (object instanceof InternalCDOObject) {
            InternalCDOObject cdoObject = (InternalCDOObject)object;
            object = cdoObject.cdoInternalInstance();
        }
        return object;
    }

    public static interface StateProvider {
        public CDOState getState(Object var1);
    }
}

