/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.ui;

import java.util.Collection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Tree;

public final class ViewerUtil {
    public static final Object[] NO_CHILDREN = new Object[0];

    private ViewerUtil() {
    }

    public static void update(StructuredViewer viewer, Object element) {
        ViewerUtil.update(viewer, element, true);
    }

    public static void update(final StructuredViewer viewer, final Object element, boolean async) {
        Control control;
        if (viewer != null && !(control = viewer.getControl()).isDisposed()) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    if (!control.isDisposed()) {
                        if (element instanceof Object[]) {
                            Object[] array = (Object[])element;
                            viewer.update(array, null);
                        } else if (element instanceof Collection) {
                            Collection collection = (Collection)element;
                            viewer.update(collection.toArray(), null);
                        } else {
                            viewer.update(element, null);
                        }
                    }
                }
            };
            Display display = control.getDisplay();
            if (async) {
                display.asyncExec(runnable);
            } else {
                display.syncExec(runnable);
            }
        }
    }

    public static void refresh(StructuredViewer viewer, Object element) {
        ViewerUtil.refresh(viewer, element, true);
    }

    public static void refresh(StructuredViewer viewer, Object element, boolean async) {
        ViewerUtil.refresh(viewer, element, async, false);
    }

    public static void refresh(final StructuredViewer viewer, final Object element, boolean async, final boolean setSelectionBack) {
        Control control;
        if (viewer != null && !(control = viewer.getControl()).isDisposed()) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    if (!viewer.getControl().isDisposed()) {
                        ISelection selection = null;
                        if (setSelectionBack) {
                            selection = viewer.getSelection();
                        }
                        if (element == null) {
                            viewer.refresh();
                        } else if (element instanceof Collection) {
                            Collection collection = (Collection)element;
                            for (Object object : collection) {
                                viewer.refresh(object);
                            }
                        } else {
                            viewer.refresh(element);
                        }
                        if (selection != null) {
                            viewer.setSelection(selection);
                        }
                    }
                }
            };
            Display display = control.getDisplay();
            if (async) {
                display.asyncExec(runnable);
            } else {
                display.syncExec(runnable);
            }
        }
    }

    public static void expand(final TreeViewer viewer, final Object element, final boolean expanded) {
        Tree tree;
        if (viewer != null && !(tree = viewer.getTree()).isDisposed()) {
            Display display = tree.getDisplay();
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!viewer.getControl().isDisposed()) {
                        viewer.setExpandedState(element, expanded);
                    }
                }
            });
        }
    }

    public static final class Error {
        private final Object parent;
        private final String text;

        public Error(Object parent, String text) {
            this.parent = parent;
            this.text = text;
        }

        public Object getParent() {
            return this.parent;
        }

        public String getText() {
            return this.text;
        }

        public String toString() {
            return this.text;
        }
    }

    public static final class Pending {
        private final Object parent;
        private final String text;

        public Pending(Object parent, String text) {
            this.parent = parent;
            this.text = text;
        }

        public Object getParent() {
            return this.parent;
        }

        public String getText() {
            return this.text;
        }

        public String toString() {
            return this.text;
        }
    }
}

