/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.internal.services;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.datatools.connectivity.internal.ConnectivityPlugin;
import org.eclipse.datatools.connectivity.internal.services.PluginResourceLocatorImpl;
import org.eclipse.datatools.connectivity.internal.services.ResourceLocatorDelegate;

class ClassLoaderResourceLocator
extends ResourceLocatorDelegate {
    private static final String PLUGIN_VERSION_SEPARATOR = "_";
    private static final String BUNDLE_MANIFEST_RELATIVE_PATH = "META-INF/MANIFEST.MF";
    private static final String UPPER_RELATIVE_PATH = "..";
    private static final String JAR_FILE_EXTENSION = ".jar";
    private static final String RESOURCE_KEY_PREFIX = "%";
    private static final String RESOURCE_KEY_DOUBLE_PREFIX = "%%";
    private static Map<ClassLoader, Map<String, URL>> sm_loadedPluginLocs = Collections.synchronizedMap(new HashMap());
    private static URL notLoadedURL = ClassLoaderResourceLocator.getNotLoadedURL();
    private static IPath datatoolsInstallPath;

    ClassLoaderResourceLocator() {
    }

    @Override
    URL findPluginEntry(String pluginId, String path, ClassLoader cl) {
        return ClassLoaderResourceLocator.getLoadedPluginEntry(pluginId, path, cl);
    }

    private static URL getLoadedPluginEntry(String pluginId, String path, ClassLoader cl) {
        if (cl == null) {
            cl = ClassLoaderResourceLocator.class.getClassLoader();
        }
        if (path.equals("/")) {
            return ClassLoaderResourceLocator.getLoadedPluginLoc(pluginId, cl);
        }
        if (path.endsWith(JAR_FILE_EXTENSION)) {
            return ClassLoaderResourceLocator.getLoadedJarEntry(pluginId, path, cl);
        }
        return ClassLoaderResourceLocator.findLoadedResources(pluginId, path, cl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private static URL getLoadedPluginLoc(String pluginId, ClassLoader cl) {
        URL cachedPluginLoc;
        Map<String, URL> loaderPluginLocs = sm_loadedPluginLocs.get(cl);
        if (loaderPluginLocs == null || loaderPluginLocs.get(pluginId) == null) {
            URL pluginLoc = ClassLoaderResourceLocator.findLoadedPluginLoc(pluginId, cl);
            if (loaderPluginLocs == null) {
                Class<ClassLoaderResourceLocator> clazz = ClassLoaderResourceLocator.class;
                // MONITORENTER : org.eclipse.datatools.connectivity.internal.services.ClassLoaderResourceLocator.class
                loaderPluginLocs = sm_loadedPluginLocs.get(cl);
                if (loaderPluginLocs == null) {
                    loaderPluginLocs = Collections.synchronizedMap(new HashMap());
                    sm_loadedPluginLocs.put(cl, loaderPluginLocs);
                }
                // MONITOREXIT : clazz
            }
            loaderPluginLocs.put(pluginId, pluginLoc);
        }
        if (notLoadedURL.equals(cachedPluginLoc = loaderPluginLocs.get(pluginId))) {
            return null;
        }
        URL uRL = cachedPluginLoc;
        return uRL;
    }

    private static URL findLoadedPluginLoc(String pluginId, ClassLoader cl) {
        URL manifestURL = ClassLoaderResourceLocator.getLoadedPluginEntry(pluginId, BUNDLE_MANIFEST_RELATIVE_PATH, cl);
        if (manifestURL == null) {
            return notLoadedURL;
        }
        try {
            return new URL(manifestURL, UPPER_RELATIVE_PATH);
        }
        catch (MalformedURLException ex) {
            ConnectivityPlugin.getDefault().logWarning(ex.getMessage());
            return notLoadedURL;
        }
    }

    private static URL findLoadedResources(String pluginId, String path, ClassLoader cl) {
        Enumeration<URL> foundURLs;
        try {
            foundURLs = cl.getResources(path);
        }
        catch (IOException e) {
            ConnectivityPlugin.getDefault().log(e);
            return null;
        }
        ArrayList<URL> matchingEntries = new ArrayList<URL>(2);
        String pluginNameFragment = String.valueOf(pluginId) + PLUGIN_VERSION_SEPARATOR;
        while (foundURLs.hasMoreElements()) {
            URL resourceURL = foundURLs.nextElement();
            if (!resourceURL.getPath().contains(pluginNameFragment)) continue;
            matchingEntries.add(resourceURL);
        }
        if (matchingEntries.isEmpty()) {
            return null;
        }
        if (matchingEntries.size() == 1) {
            return (URL)matchingEntries.get(0);
        }
        if (!pluginId.equals("org.eclipse.datatools.connectivity")) {
            ArrayList<URL> installPathEntries = new ArrayList<URL>(matchingEntries.size());
            String installPath = ClassLoaderResourceLocator.getDatatoolsInstallPath(cl).toString();
            for (URL entry : matchingEntries) {
                String entryFilePath = entry.getPath();
                if (!entryFilePath.contains(installPath)) continue;
                installPathEntries.add(entry);
            }
            if (installPathEntries.size() >= 1) {
                if (installPathEntries.size() == 1) {
                    return (URL)installPathEntries.get(0);
                }
                matchingEntries = installPathEntries;
            }
        }
        URL upperLevelEntry = null;
        int upperEntrySegments = 0;
        for (URL entry : matchingEntries) {
            int entrySegments = new Path(entry.getPath()).segmentCount();
            if (upperLevelEntry != null && entrySegments >= upperEntrySegments) continue;
            upperLevelEntry = entry;
            upperEntrySegments = entrySegments;
        }
        return upperLevelEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static IPath getDatatoolsInstallPath(ClassLoader cl) {
        if (datatoolsInstallPath != null) return datatoolsInstallPath;
        IPath foundPath = ClassLoaderResourceLocator.getParentInstallPath("org.eclipse.datatools.connectivity", ClassLoaderResourceLocator.getLoadedPluginLoc("org.eclipse.datatools.connectivity", cl));
        Class<ClassLoaderResourceLocator> clazz = ClassLoaderResourceLocator.class;
        synchronized (ClassLoaderResourceLocator.class) {
            datatoolsInstallPath = foundPath;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return datatoolsInstallPath;
        }
    }

    private static IPath getParentInstallPath(String pluginId, URL pluginLoc) {
        String pluginNameFragment = String.valueOf(pluginId) + PLUGIN_VERSION_SEPARATOR;
        IPath pluginPath = PluginResourceLocatorImpl.adaptToPath(pluginLoc);
        String[] pathSegments = pluginPath.segments();
        int i = 0;
        while (i < pathSegments.length) {
            if (pathSegments[i].startsWith(pluginNameFragment)) {
                return pluginPath.uptoSegment(i);
            }
            ++i;
        }
        return null;
    }

    private static URL getLoadedJarEntry(String pluginId, String jarFilePath, ClassLoader cl) {
        URL pluginLoc = ClassLoaderResourceLocator.getLoadedPluginLoc(pluginId, cl);
        if (pluginLoc == null && (pluginLoc = ClassLoaderResourceLocator.findLoadedResources(pluginId, jarFilePath, cl)) == null) {
            return null;
        }
        IPath pluginPath = PluginResourceLocatorImpl.adaptToPath(pluginLoc);
        if (pluginPath.lastSegment().equalsIgnoreCase(jarFilePath)) {
            return pluginLoc;
        }
        File jarFile = pluginPath.append(jarFilePath).toFile();
        if (!jarFile.exists()) {
            return null;
        }
        try {
            return jarFile.toURL();
        }
        catch (MalformedURLException e) {
            ConnectivityPlugin.getDefault().logInfo(e.getMessage());
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static URL getNotLoadedURL() {
        if (notLoadedURL != null) return notLoadedURL;
        Class<ClassLoaderResourceLocator> clazz = ClassLoaderResourceLocator.class;
        synchronized (ClassLoaderResourceLocator.class) {
            try {
                if (notLoadedURL != null) return notLoadedURL;
                notLoadedURL = new URL("file:/");
            }
            catch (MalformedURLException malformedURLException) {}
            return notLoadedURL;
        }
    }

    @Override
    URL findPluginResource(String pluginId, String name, ClassLoader cl) {
        return ClassLoaderResourceLocator.getLoadedPluginEntry(pluginId, name, cl);
    }

    @Override
    String findResourceString(String pluginId, String value) {
        String s = value.trim();
        if (!s.startsWith(RESOURCE_KEY_PREFIX, 0)) {
            return s;
        }
        if (s.startsWith(RESOURCE_KEY_DOUBLE_PREFIX, 0)) {
            return s.substring(1);
        }
        int idx = s.indexOf(32);
        String key = idx == -1 ? s.substring(RESOURCE_KEY_PREFIX.length()) : s.substring(RESOURCE_KEY_PREFIX.length(), idx);
        String defaultValue = idx == -1 ? s : s.substring(idx + 1);
        URL pluginPropURL = ClassLoaderResourceLocator.findLoadedResources(pluginId, "plugin.properties", this.getClass().getClassLoader());
        if (pluginPropURL == null) {
            return defaultValue;
        }
        Properties pluginProps = new Properties();
        try {
            pluginProps.load(pluginPropURL.openStream());
        }
        catch (IOException e) {
            ConnectivityPlugin.getDefault().logInfo(e.getMessage());
            return defaultValue;
        }
        return pluginProps.getProperty(key, defaultValue);
    }

    @Override
    IPath findPluginStateLocation(String pluginId) {
        return PluginResourceLocatorImpl.getConfigurableWorkspacePath(pluginId);
    }

    @Override
    URL resolveURL(URL url) throws IOException {
        return url;
    }

    @Override
    URL toFileURL(URL url) throws IOException {
        return url;
    }
}

