/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.help;

import java.util.ArrayList;
import org.eclipse.cdt.ui.FunctionPrototypeSummary;
import org.eclipse.cdt.ui.IFunctionSummary;
import org.eclipse.cdt.ui.IRequiredInclude;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CFunctionSummary
implements IFunctionSummary {
    private static final String ATTR_STD = "standard";
    private static final String NODE_NAME = "name";
    private static final String NODE_DESC = "description";
    private static final String NODE_INCL = "include";
    private static final String NODE_TYPE = "returnType";
    private static final String NODE_ARGS = "arguments";
    private static final String SP = " ";
    private static final String LB = "(";
    private static final String RB = ")";
    private String name = null;
    private String desc = null;
    private IRequiredInclude[] incs = null;
    IFunctionSummary.IFunctionPrototypeSummary fps = null;

    public CFunctionSummary(Element e, String defName) {
        this.name = defName;
        String args = null;
        String type = null;
        NodeList list = e.getChildNodes();
        ArrayList<RequiredInclude> incList = new ArrayList<RequiredInclude>();
        int j = 0;
        while (j < list.getLength()) {
            Node node = list.item(j);
            if (node.getNodeType() == 1) {
                String s = node.getNodeName().trim();
                String t = node.getFirstChild().getNodeValue().trim();
                if (NODE_NAME.equals(s)) {
                    this.name = t;
                } else if (NODE_DESC.equals(s)) {
                    this.desc = t;
                } else if (NODE_ARGS.equals(s)) {
                    args = t;
                } else if (NODE_TYPE.equals(s)) {
                    type = t;
                } else if (NODE_INCL.equals(s)) {
                    boolean std = true;
                    if (((Element)node).hasAttribute(ATTR_STD)) {
                        String st = ((Element)node).getAttribute(ATTR_STD);
                        std = st == null || st.equalsIgnoreCase("true") || st.equalsIgnoreCase("yes");
                    }
                    incList.add(new RequiredInclude(t, std));
                }
            }
            ++j;
        }
        if (incList.size() > 0) {
            this.incs = incList.toArray(new IRequiredInclude[incList.size()]);
        }
        this.fps = new FunctionPrototypeSummary(String.valueOf(type) + SP + this.name + LB + args + RB);
    }

    @Override
    public String getDescription() {
        return this.desc;
    }

    @Override
    public IRequiredInclude[] getIncludes() {
        return this.incs;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getNamespace() {
        return null;
    }

    @Override
    public IFunctionSummary.IFunctionPrototypeSummary getPrototype() {
        return this.fps;
    }

    public String toString() {
        return "<functionSummary> : " + this.getPrototype().getPrototypeString(false);
    }

    private class RequiredInclude
    implements IRequiredInclude {
        private String iname;
        private boolean std;

        private RequiredInclude(String s, boolean b) {
            this.iname = s;
            this.std = b;
        }

        @Override
        public String getIncludeName() {
            return this.iname;
        }

        @Override
        public boolean isStandard() {
            return this.std;
        }

        public String toString() {
            if (this.std) {
                return "#include <" + this.iname + ">";
            }
            return "#include \"" + this.iname + "\"";
        }
    }
}

